/*
 * Decompiled with CFR 0.152.
 */
package phex.http;

import phex.http.HTTPHeader;
import phex.http.HTTPHeaderGroup;

public class HTTPResponse {
    public static final String CRLF = "\r\n";
    private static final char SP = ' ';
    private String httpVersion;
    private short statusCode;
    private String statusReason;
    private HTTPHeaderGroup httpHeaders;

    public HTTPResponse(short s, String string, boolean bl) {
        this("HTTP/1.1", s, string, bl);
    }

    public HTTPResponse(String string, short s, String string2, boolean bl) {
        this.httpVersion = string;
        this.statusCode = s;
        this.statusReason = string2;
        this.httpHeaders = bl ? HTTPHeaderGroup.createDefaultResponseHeaders() : new HTTPHeaderGroup(false);
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getStatusReason() {
        return this.statusReason;
    }

    public String getHTTPVersion() {
        return this.httpVersion;
    }

    public void addHeader(HTTPHeader hTTPHeader) {
        this.httpHeaders.addHeader(hTTPHeader);
    }

    public void addHeaders(HTTPHeader[] hTTPHeaderArray) {
        this.httpHeaders.addHeaders(hTTPHeaderArray);
    }

    public HTTPHeader getHeader(String string) {
        return this.httpHeaders.getHeader(string);
    }

    public HTTPHeader[] getHeaders(String string) {
        return this.httpHeaders.getHeaders(string);
    }

    public String buildHTTPResponseString() {
        return this.httpVersion + ' ' + this.statusCode + ' ' + this.statusReason + CRLF + this.httpHeaders.buildHTTPHeaderString() + CRLF;
    }
}

