/*
 * Decompiled with CFR 0.152.
 */
package phex.http;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import phex.http.Range;
import phex.utils.NLogger;

public class HTTPRangeSet {
    private static final String BYTES = "bytes";
    public static final int NOT_SET = -1;
    private ArrayList rangeList = new ArrayList(4);

    public HTTPRangeSet() {
    }

    public HTTPRangeSet(long l) {
        this();
        Range range = new Range(l);
        this.rangeList.add(range);
    }

    public HTTPRangeSet(long l, long l2) {
        this();
        Range range = new Range(l, l2);
        this.rangeList.add(range);
    }

    public int size() {
        return this.rangeList.size();
    }

    public void addRange(long l) {
        Range range = new Range(l);
        this.rangeList.add(range);
    }

    public void addRange(long l, long l2) {
        Range range = new Range(l, l2);
        this.rangeList.add(range);
    }

    public Range getFirstRange() {
        if (this.rangeList.size() > 0) {
            return (Range)this.rangeList.get(0);
        }
        return null;
    }

    public Iterator getIterator() {
        return this.rangeList.iterator();
    }

    public Collection getRangeSet() {
        return this.rangeList;
    }

    public String buildXAvailableRangesString() {
        if (this.rangeList.size() == 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(30);
        stringBuffer.append("bytes ");
        Iterator iterator = this.rangeList.iterator();
        while (iterator.hasNext()) {
            Range range = (Range)iterator.next();
            stringBuffer.append(range.buildHTTPRangeString());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(',');
        }
        return stringBuffer.toString();
    }

    public static HTTPRangeSet parseHTTPRangeSet(String string, boolean bl) {
        int n;
        if (!(string = string.toLowerCase()).startsWith(BYTES)) {
            return null;
        }
        if (string.length() < 6) {
            return new HTTPRangeSet();
        }
        try {
            string = string.substring(6).trim();
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            NLogger.error("GLOBAL", (Object)("Invalid RangeSet value: '" + string + "'."), (Throwable)stringIndexOutOfBoundsException);
            return null;
        }
        int n2 = 0;
        HTTPRangeSet hTTPRangeSet = new HTTPRangeSet();
        do {
            int n3;
            if ((n = string.indexOf(44, n2)) == -1) {
                n = string.length();
            }
            String string2 = string.substring(n2, n).trim();
            if (bl && string2.charAt(0) == '-') {
                n3 = string2.indexOf(32);
                if (n3 == -1) {
                    n3 = string2.length();
                }
                String string3 = string2.substring(1, n3);
                try {
                    long l = Long.parseLong(string3);
                    hTTPRangeSet.addRange(l);
                }
                catch (NumberFormatException numberFormatException) {
                    return null;
                }
            }
            n3 = string2.indexOf(45);
            try {
                String string4 = string2.substring(0, n3);
                long l = Long.parseLong(string4);
                if (bl && n3 + 1 >= string2.length()) {
                    hTTPRangeSet.addRange(l, -1L);
                } else {
                    String string5 = string2.substring(n3 + 1);
                    long l2 = Long.parseLong(string5);
                    if (l2 >= l) {
                        hTTPRangeSet.addRange(l, l2);
                    }
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                return null;
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
            n2 = n + 1;
        } while (n != string.length());
        return hTTPRangeSet;
    }
}

