/*
 * Decompiled with CFR 0.152.
 */
package phex.http;

import java.io.IOException;
import java.net.SocketException;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import phex.http.HTTPHeader;
import phex.http.HTTPHeaderGroup;
import phex.http.HTTPMessageException;
import phex.http.HTTPRequest;
import phex.http.HTTPResponse;
import phex.net.connection.Connection;

public class HTTPProcessor {
    private static final char SP = ' ';
    private static final char HT = '\t';

    private HTTPProcessor() {
    }

    public static HTTPRequest parseHTTPRequest(Connection connection) throws IOException, HTTPMessageException {
        String string = connection.readLine();
        if (string == null) {
            throw new IOException("Stream unexpectedly ended.");
        }
        HTTPRequest hTTPRequest = HTTPProcessor.parseHTTPRequest(string);
        HTTPProcessor.parseHTTPHeaders(hTTPRequest, connection);
        return hTTPRequest;
    }

    public static HTTPRequest parseHTTPRequest(String string) throws HTTPMessageException {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String string2 = null;
        try {
            string2 = stringTokenizer.nextToken();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        String string3 = null;
        try {
            string3 = stringTokenizer.nextToken();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        String string4 = null;
        try {
            string4 = stringTokenizer.nextToken();
        }
        catch (NoSuchElementException noSuchElementException) {
            string4 = "HTTP/0.9";
        }
        if (string2 == null) {
            throw new HTTPMessageException("HTTPRequest has no method.");
        }
        if (string3 == null) {
            throw new HTTPMessageException("HTTPRequest has no URI.");
        }
        HTTPRequest hTTPRequest = new HTTPRequest(string2, string3, string4, false);
        return hTTPRequest;
    }

    public static HTTPResponse parseHTTPResponse(Connection connection) throws IOException, HTTPMessageException {
        String string = connection.readLine();
        if (string == null) {
            throw new SocketException("Stream unexpectedly ended.");
        }
        string = string.trim();
        int n = string.indexOf(32);
        String string2 = null;
        try {
            string2 = string.substring(0, n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            string2 = null;
        }
        int n2 = -1;
        String string3 = null;
        try {
            n2 = string.indexOf(32, n + 1);
            if (n2 == -1) {
                n2 = string.length();
            }
            string3 = string.substring(n + 1, n2);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            string3 = null;
        }
        String string4 = null;
        if (++n2 < string.length()) {
            try {
                string4 = string.substring(n2, string.length());
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                string4 = "";
            }
        } else {
            string4 = "";
        }
        if (string2 == null) {
            throw new HTTPMessageException("HTTP response has no version: " + string);
        }
        if (string3 == null) {
            throw new HTTPMessageException("HTTP response has no status code: " + string);
        }
        if (string3.length() != 3) {
            throw new HTTPMessageException("HTTP response status code has invalid lenth: " + string3 + " Line: " + string);
        }
        short s = -1;
        try {
            s = Short.parseShort(string3);
        }
        catch (NumberFormatException numberFormatException) {
            throw new HTTPMessageException("Status code of HTTP response is not valid: " + string3);
        }
        HTTPResponse hTTPResponse = new HTTPResponse(string2, s, string4, false);
        HTTPProcessor.parseHTTPHeaders(hTTPResponse, connection);
        return hTTPResponse;
    }

    public static HTTPHeaderGroup parseHTTPHeaders(Connection connection) throws IOException {
        HTTPHeader hTTPHeader;
        HTTPHeaderGroup hTTPHeaderGroup = new HTTPHeaderGroup(true);
        while ((hTTPHeader = HTTPProcessor.parseHTTPHeader(connection)) != null) {
            hTTPHeaderGroup.addHeader(hTTPHeader);
        }
        return hTTPHeaderGroup;
    }

    public static void parseHTTPHeaders(HTTPRequest hTTPRequest, Connection connection) throws IOException {
        HTTPHeader hTTPHeader;
        while ((hTTPHeader = HTTPProcessor.parseHTTPHeader(connection)) != null) {
            int n;
            String string = hTTPHeader.getName().toLowerCase();
            if (string.equals("content-length")) {
                n = -1;
                try {
                    n = Integer.parseInt(hTTPHeader.getValue());
                }
                catch (Exception exception) {
                    throw new IOException("Error parsing content-length: " + hTTPHeader.getName() + " - " + hTTPHeader.getValue());
                }
                hTTPRequest.setContentLength(n, false);
                hTTPRequest.addHeader(hTTPHeader);
                continue;
            }
            if (string.equals("host")) {
                n = hTTPHeader.getValue().indexOf(58);
                if (n < 0) {
                    hTTPRequest.setHost(hTTPHeader.getValue(), -1, false);
                } else {
                    int n2 = -1;
                    try {
                        n2 = Integer.parseInt(hTTPHeader.getValue().substring(n + 1).trim());
                    }
                    catch (Exception exception) {
                        throw new IOException("Error parsing host: " + hTTPHeader.getName() + " - " + hTTPHeader.getValue());
                    }
                    hTTPRequest.setHost(hTTPHeader.getValue().substring(0, n).trim(), n2, false);
                }
                hTTPRequest.addHeader(hTTPHeader);
                continue;
            }
            hTTPRequest.addHeader(hTTPHeader);
        }
    }

    private static void parseHTTPHeaders(HTTPResponse hTTPResponse, Connection connection) throws IOException {
        HTTPHeader hTTPHeader;
        while ((hTTPHeader = HTTPProcessor.parseHTTPHeader(connection)) != null) {
            hTTPResponse.addHeader(hTTPHeader);
        }
    }

    private static HTTPHeader parseHTTPHeader(Connection connection) throws IOException {
        String string = connection.readLine();
        if (string == null || string.length() < 1) {
            return null;
        }
        int n = string.indexOf(58);
        if (n < 0) {
            throw new IOException("Invalid HTTP headers: " + string);
        }
        String string2 = string.substring(0, n).trim();
        StringBuffer stringBuffer = new StringBuffer(string.substring(n + 1).trim());
        char c = (char)connection.readPeek();
        while (c == ' ' || c == '\t') {
            int n2;
            string = connection.readLine();
            int n3 = string.length();
            char[] cArray = string.toCharArray();
            for (n2 = 0; n2 < n3 && (cArray[n2] == ' ' || cArray[n2] == '\t'); ++n2) {
            }
            if (n2 > 0) {
                string = string.substring(n2, n3);
            }
            stringBuffer.ensureCapacity(string.length() + 1);
            stringBuffer.append(' ');
            stringBuffer.append(string);
            c = (char)connection.readPeek();
        }
        String string3 = stringBuffer.toString();
        return new HTTPHeader(string2, string3);
    }
}

