/*
 * Decompiled with CFR 0.152.
 */
package phex.http;

import phex.common.URN;
import phex.utils.URLCodecUtils;

public class GnutellaRequest {
    public static final String GNUTELLA_GET_PREFIX = "/get/";
    public static final String GNUTELLA_URI_RES_PREFIX = "/uri-res/N2R?";
    public static final String GNUTELLA_URI_RES_THEX_PREFIX = "/uri-res/N2X?";
    private int fileIndex;
    private String filename;
    private URN urn;
    private boolean isTigerTreeRequest;

    public GnutellaRequest(URN uRN, boolean bl) {
        this.urn = uRN;
        this.fileIndex = -1;
        this.filename = null;
        this.isTigerTreeRequest = bl;
    }

    public GnutellaRequest(int n, String string) {
        this.fileIndex = n;
        this.filename = string;
        this.urn = null;
        this.isTigerTreeRequest = false;
    }

    public String getFileName() {
        return this.filename;
    }

    public int getFileIndex() {
        return this.fileIndex;
    }

    public URN getURN() {
        return this.urn;
    }

    public void setContentURN(URN uRN) {
        this.urn = uRN;
    }

    public boolean isTigerTreeRequest() {
        return this.isTigerTreeRequest;
    }

    public static GnutellaRequest parseGnutellaRequest(String string) {
        int n = string.indexOf(GNUTELLA_GET_PREFIX);
        if (n != -1) {
            int n2;
            int n3 = string.indexOf(47, n += 5);
            String string2 = string.substring(n, n3);
            try {
                n2 = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                n2 = -1;
            }
            String string3 = URLCodecUtils.decodeURL(string.substring(n3 + 1));
            return new GnutellaRequest(n2, string3);
        }
        n = string.indexOf(GNUTELLA_URI_RES_PREFIX);
        if (n != -1) {
            String string4 = URLCodecUtils.decodeURL(string.substring(n += 13));
            URN uRN = new URN(string4);
            return new GnutellaRequest(uRN, false);
        }
        n = string.indexOf(GNUTELLA_URI_RES_THEX_PREFIX);
        if (n != -1) {
            String string5 = string.substring(n += GNUTELLA_URI_RES_THEX_PREFIX.length());
            URN uRN = new URN(string5);
            return new GnutellaRequest(uRN, true);
        }
        return null;
    }
}

