/*
 * Decompiled with CFR 0.152.
 */
package phex.host;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import phex.common.ServiceManager;
import phex.common.ThreadPool;
import phex.common.address.DestAddress;
import phex.connection.OutgoingConnectionDispatcher;
import phex.event.AsynchronousDispatcher;
import phex.event.NetworkHostsChangeListener;
import phex.event.NetworkListener;
import phex.host.Host;
import phex.host.HostManager;
import phex.msg.MsgManager;
import phex.udp.UdpConnectionManager;
import phex.utils.Localizer;
import phex.utils.NLogger;

public final class NetworkHostsContainer
implements NetworkListener {
    private HostManager hostMgr;
    private ArrayList networkHosts;
    private ArrayList peerConnections;
    private ArrayList ultrapeerConnections;
    private int leafUltrapeerConnectionCount;
    private ArrayList leafConnections;
    private ArrayList listenerList = new ArrayList(3);

    public NetworkHostsContainer() {
        this.networkHosts = new ArrayList();
        this.peerConnections = new ArrayList();
        this.ultrapeerConnections = new ArrayList();
        this.leafConnections = new ArrayList();
        this.hostMgr = HostManager.getInstance();
    }

    public synchronized boolean isShieldedLeafNode() {
        return this.leafUltrapeerConnectionCount > 0;
    }

    public synchronized boolean hasLeafConnections() {
        return !this.leafConnections.isEmpty();
    }

    public synchronized boolean hasUltrapeerConnections() {
        return !this.ultrapeerConnections.isEmpty();
    }

    public boolean hasPeerSlotsAvailable() {
        if (this.hostMgr.isUltrapeer()) {
            return this.peerConnections.size() < ServiceManager.sCfg.up2peerConnections;
        }
        if (this.isShieldedLeafNode()) {
            return this.peerConnections.size() < ServiceManager.sCfg.leaf2peerConnections;
        }
        return this.peerConnections.size() < ServiceManager.sCfg.peerConnections;
    }

    public boolean hasUltrapeerSlotsAvailable() {
        return this.ultrapeerConnections.size() < ServiceManager.sCfg.up2upConnections;
    }

    public int getOpenUltrapeerSlotsCount() {
        return ServiceManager.sCfg.up2upConnections - this.ultrapeerConnections.size();
    }

    public boolean hasLeafSlotForUltrapeerAvailable() {
        return this.hasLeafSlotsAvailable() && this.ultrapeerConnections.size() < ServiceManager.sCfg.up2upConnections + 1;
    }

    public boolean hasLeafSlotsAvailable() {
        return this.leafConnections.size() < ServiceManager.sCfg.up2leafConnections;
    }

    public int getOpenLeafSlotsCount() {
        if (this.hostMgr.isUltrapeer()) {
            return ServiceManager.sCfg.up2leafConnections - this.leafConnections.size();
        }
        return 0;
    }

    public synchronized Host[] getUltrapeerConnections() {
        Host[] hostArray = new Host[this.ultrapeerConnections.size()];
        this.ultrapeerConnections.toArray(hostArray);
        return hostArray;
    }

    public synchronized Host[] getLeafConnections() {
        Host[] hostArray = new Host[this.leafConnections.size()];
        this.leafConnections.toArray(hostArray);
        return hostArray;
    }

    public synchronized Host[] getPeerConnections() {
        Host[] hostArray = new Host[this.peerConnections.size()];
        this.peerConnections.toArray(hostArray);
        return hostArray;
    }

    public synchronized int getTotalConnectionCount() {
        return this.ultrapeerConnections.size() + this.leafConnections.size() + this.peerConnections.size();
    }

    public int getLeafConnectionCount() {
        return this.leafConnections.size();
    }

    public synchronized int getUltrapeerConnectionCount() {
        return this.ultrapeerConnections.size();
    }

    public DestAddress[] getPushProxies() {
        if (this.isShieldedLeafNode()) {
            Object object;
            Iterator iterator = this.ultrapeerConnections.iterator();
            HashSet<DestAddress> hashSet = new HashSet<DestAddress>();
            while (iterator.hasNext() && hashSet.size() != 4) {
                object = (Host)iterator.next();
                DestAddress destAddress = ((Host)object).getPushProxyAddress();
                if (destAddress == null) continue;
                hashSet.add(destAddress);
            }
            object = new DestAddress[hashSet.size()];
            hashSet.toArray((T[])object);
            return object;
        }
        return null;
    }

    public synchronized void addConnectedHost(Host host) {
        if (!this.networkHosts.contains(host)) {
            this.disconnectHost(host);
            return;
        }
        if (host.isUltrapeer()) {
            this.ultrapeerConnections.add(host);
            if (host.isLeafUltrapeerConnection()) {
                ++this.leafUltrapeerConnectionCount;
            }
        } else if (host.isUltrapeerLeafConnection()) {
            this.leafConnections.add(host);
        } else {
            this.peerConnections.add(host);
        }
    }

    public synchronized void disconnectHost(Host host) {
        if (host == null) {
            return;
        }
        if (host.isUltrapeer()) {
            boolean bl = this.ultrapeerConnections.remove(host);
            if (bl && host.isLeafUltrapeerConnection()) {
                --this.leafUltrapeerConnectionCount;
            }
        } else if (host.isUltrapeerLeafConnection()) {
            this.leafConnections.remove(host);
        } else {
            this.peerConnections.remove(host);
        }
        host.disconnect();
        MsgManager.getInstance().removeHost(host);
        this.fireNetworkHostChanged(host);
    }

    public synchronized void periodicallyCheckHosts() {
        long l = System.currentTimeMillis();
        Host[] hostArray = new Host[this.networkHosts.size()];
        int n = 0;
        Iterator iterator = this.networkHosts.iterator();
        while (iterator.hasNext()) {
            Host host = (Host)iterator.next();
            int n2 = host.getStatus();
            if (n2 == 4) {
                host.checkForStableConnection(l);
                if (ServiceManager.sCfg.mDisconnectApplyPolicy) {
                    String string = null;
                    if (host.tooManyDropPackets()) {
                        string = Localizer.getString("TooManyDroppedPackets");
                    } else if (host.isSendQueueTooLong()) {
                        string = Localizer.getString("SendQueueTooLong");
                    } else if (host.isNoVendorDisconnectApplying()) {
                        string = Localizer.getString("NoVendorString");
                    } else if (host.isFreeloader(l)) {
                        string = Localizer.getString("FreeloaderNotSharing");
                    }
                    if (string != null) {
                        host.setStatus(1, string, l);
                        this.disconnectHost(host);
                    }
                }
            }
            if (!ServiceManager.sCfg.mAutoCleanup || n2 == 4 || n2 == 2 || n2 == 3 || !host.isErrorStatusExpired(l)) continue;
            hostArray[n] = host;
            ++n;
        }
        if (n > 0) {
            this.removeNetworkHosts(hostArray);
        }
    }

    public synchronized Host getNetworkHostAt(int n) {
        if (n < 0 || n >= this.networkHosts.size()) {
            return null;
        }
        return (Host)this.networkHosts.get(n);
    }

    public synchronized Host[] getNetworkHostsAt(int[] nArray) {
        int n = nArray.length;
        Host[] hostArray = new Host[n];
        for (int i = 0; i < n; ++i) {
            hostArray[i] = (Host)this.networkHosts.get(nArray[i]);
        }
        return hostArray;
    }

    public synchronized Host getNetworkHost(DestAddress destAddress) {
        Iterator iterator = this.networkHosts.iterator();
        while (iterator.hasNext()) {
            Host host = (Host)iterator.next();
            DestAddress destAddress2 = host.getHostAddress();
            if (!destAddress2.equals(destAddress)) continue;
            return host;
        }
        return null;
    }

    public synchronized int getNetworkHostCount() {
        return this.networkHosts.size();
    }

    public synchronized int getNetworkHostCount(int n) {
        int n2 = 0;
        Iterator iterator = this.networkHosts.iterator();
        while (iterator.hasNext()) {
            Host host = (Host)iterator.next();
            if (host.getStatus() != n) continue;
            ++n2;
        }
        return n2;
    }

    public synchronized void addNetworkHost(Host host) {
        int n = this.networkHosts.size();
        this.networkHosts.add(host);
        this.fireNetworkHostAdded(n);
        try {
            UdpConnectionManager.getInstance().sendUdpPing(host.getHostAddress());
        }
        catch (IOException iOException) {
            NLogger.warn("UDP_OUTGOING_MESSAGES", (Object)(" could  not send udp ping to : " + host), (Throwable)iOException);
        }
    }

    public synchronized boolean isConnectedToHost(DestAddress destAddress) {
        for (int i = 0; i < this.networkHosts.size(); ++i) {
            Host host = (Host)this.networkHosts.get(i);
            if (!host.getHostAddress().equals(destAddress)) continue;
            return true;
        }
        return false;
    }

    public synchronized void createOutgoingConnectionToHost(DestAddress destAddress) {
        OutgoingConnectionDispatcher outgoingConnectionDispatcher = new OutgoingConnectionDispatcher();
        outgoingConnectionDispatcher.setHostAddressToConnect(destAddress);
        ThreadPool.getInstance().addJob(outgoingConnectionDispatcher, "OutgoingConnectionDispatcher-" + Integer.toHexString(this.hashCode()));
    }

    public synchronized void createOutConnectionToNextHosts(int n) {
        for (int i = 0; i < n; ++i) {
            OutgoingConnectionDispatcher outgoingConnectionDispatcher = new OutgoingConnectionDispatcher();
            ThreadPool.getInstance().addJob(outgoingConnectionDispatcher, "OutgoingConnectionDispatcher-" + Integer.toHexString(this.hashCode()));
        }
    }

    public synchronized void addIncomingHost(Host host) {
        this.addNetworkHost(host);
        this.addConnectedHost(host);
    }

    public synchronized void removeAllNetworkHosts() {
        while (this.networkHosts.size() > 0) {
            Host host = (Host)this.networkHosts.get(0);
            this.internalRemoveNetworkHost(host);
        }
    }

    public synchronized void removeNetworkHosts(Host[] hostArray) {
        int n = hostArray.length;
        for (int i = 0; i < n; ++i) {
            Host host = hostArray[i];
            this.internalRemoveNetworkHost(host);
        }
    }

    public synchronized void removeNetworkHost(Host host) {
        this.internalRemoveNetworkHost(host);
    }

    private synchronized void internalRemoveNetworkHost(Host host) {
        if (host == null) {
            return;
        }
        this.disconnectHost(host);
        int n = this.networkHosts.indexOf(host);
        if (n >= 0) {
            this.networkHosts.remove(n);
            this.fireNetworkHostRemoved(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNetworkHostsChangeListener(NetworkHostsChangeListener networkHostsChangeListener) {
        ArrayList arrayList = this.listenerList;
        synchronized (arrayList) {
            this.listenerList.add(networkHostsChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNetworkHostsChangeListener(NetworkHostsChangeListener networkHostsChangeListener) {
        ArrayList arrayList = this.listenerList;
        synchronized (arrayList) {
            this.listenerList.remove(networkHostsChangeListener);
        }
    }

    private void fireNetworkHostChanged(final int n) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = NetworkHostsContainer.this.listenerList.toArray();
                for (int i = objectArray.length - 1; i >= 0; --i) {
                    NetworkHostsChangeListener networkHostsChangeListener = (NetworkHostsChangeListener)objectArray[i];
                    networkHostsChangeListener.networkHostChanged(n);
                }
            }
        });
    }

    private void fireNetworkHostAdded(final int n) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = NetworkHostsContainer.this.listenerList.toArray();
                for (int i = objectArray.length - 1; i >= 0; --i) {
                    NetworkHostsChangeListener networkHostsChangeListener = (NetworkHostsChangeListener)objectArray[i];
                    networkHostsChangeListener.networkHostAdded(n);
                }
            }
        });
    }

    private void fireNetworkHostRemoved(final int n) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                try {
                    Object[] objectArray = NetworkHostsContainer.this.listenerList.toArray();
                    for (int i = objectArray.length - 1; i >= 0; --i) {
                        NetworkHostsChangeListener networkHostsChangeListener = (NetworkHostsChangeListener)objectArray[i];
                        networkHostsChangeListener.networkHostRemoved(n);
                    }
                }
                catch (Throwable throwable) {
                    NLogger.error("GLOBAL", (Object)throwable, throwable);
                }
            }
        });
    }

    public void fireNetworkHostChanged(Host host) {
        int n = this.networkHosts.indexOf(host);
        if (n >= 0) {
            this.fireNetworkHostChanged(n);
        }
    }

    public void connectedToNetwork() {
    }

    public void disconnectedFromNetwork() {
        this.removeAllNetworkHosts();
    }

    public void networkIPChanged(DestAddress destAddress) {
    }
}

