/*
 * Decompiled with CFR 0.152.
 */
package phex.host;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TimerTask;
import phex.common.Environment;
import phex.common.ThreadPool;
import phex.common.address.DefaultDestAddress;
import phex.common.address.DestAddress;
import phex.common.file.FileManager;
import phex.common.file.ManagedFile;
import phex.common.file.ManagedFileException;
import phex.connection.NetworkManager;
import phex.event.AsynchronousDispatcher;
import phex.event.BookmarkedHostsChangeListener;
import phex.host.FavoriteHost;
import phex.utils.NLogger;
import phex.utils.VersionUtils;
import phex.xml.sax.DPhex;
import phex.xml.sax.DSubElementList;
import phex.xml.sax.XMLBuilder;
import phex.xml.sax.favorites.DFavoriteHost;

public class FavoritesContainer {
    private ArrayList listenerList = new ArrayList(2);
    private ArrayList favoritesList = new ArrayList();
    private boolean hasChangedSinceLastSave = false;

    public FavoritesContainer() {
        Environment.getInstance().scheduleTimerTask(new SaveFavoritesTimer(), 60000L, 60000L);
    }

    public void initializeFavorites() {
        this.favoritesList.clear();
        this.loadFromFile();
    }

    public synchronized void addFavorites(DestAddress[] destAddressArray) {
        for (int i = 0; i < destAddressArray.length; ++i) {
            FavoriteHost favoriteHost = new FavoriteHost(destAddressArray[i]);
            this.insertBookmarkedHost(favoriteHost, this.favoritesList.size());
        }
    }

    public synchronized void addFavorite(DestAddress destAddress) {
        FavoriteHost favoriteHost = new FavoriteHost(destAddress);
        this.insertBookmarkedHost(favoriteHost, this.favoritesList.size());
    }

    private void loadFromFile() {
        NLogger.debug("Favorites", (Object)"Loading favorites file.");
        NetworkManager networkManager = NetworkManager.getInstance();
        File file = networkManager.getGnutellaNetwork().getFavoritesFile();
        try {
            if (!file.exists()) {
                return;
            }
            FileManager fileManager = FileManager.getInstance();
            ManagedFile managedFile = fileManager.getReadWriteManagedFile(file);
            DPhex dPhex = XMLBuilder.loadDPhexFromFile(managedFile);
            if (dPhex == null) {
                NLogger.debug("Favorites", (Object)"No bookmarked hosts file found.");
                return;
            }
            DSubElementList dSubElementList = dPhex.getFavoritesList();
            if (dSubElementList == null) {
                NLogger.warn("Favorites", (Object)"No DFavoritesList found.");
            }
            Iterator iterator = dSubElementList.getSubElementList().iterator();
            while (iterator.hasNext()) {
                DFavoriteHost dFavoriteHost = (DFavoriteHost)iterator.next();
                int n = dFavoriteHost.getPort();
                DefaultDestAddress defaultDestAddress = null;
                String string = dFavoriteHost.getHostName();
                byte[] byArray = dFavoriteHost.getIp();
                if (string != null) {
                    defaultDestAddress = new DefaultDestAddress(string, n);
                } else if (byArray != null) {
                    defaultDestAddress = new DefaultDestAddress(byArray, n);
                }
                if (defaultDestAddress == null) continue;
                FavoriteHost favoriteHost = new FavoriteHost(defaultDestAddress);
                this.insertBookmarkedHost(favoriteHost, this.favoritesList.size());
            }
        }
        catch (IOException iOException) {
            NLogger.error("Favorites", (Object)iOException, (Throwable)iOException);
            Environment.getInstance().fireDisplayUserMessage("FavoritesSettingsLoadFailed", new String[]{iOException.toString()});
            return;
        }
        catch (ManagedFileException managedFileException) {
            NLogger.error("Favorites", (Object)managedFileException, (Throwable)managedFileException);
            Environment.getInstance().fireDisplayUserMessage("FavoritesSettingsLoadFailed", new String[]{managedFileException.toString()});
            return;
        }
    }

    public synchronized void saveFavoriteHosts() {
        if (!this.hasChangedSinceLastSave) {
            return;
        }
        try {
            Object object;
            Object object2;
            Object object3;
            DPhex dPhex = new DPhex();
            dPhex.setPhexVersion(VersionUtils.getFullProgramVersion());
            DSubElementList dSubElementList = new DSubElementList("favorites-list");
            dPhex.setFavoritesList(dSubElementList);
            List list = dSubElementList.getSubElementList();
            Iterator iterator = this.favoritesList.iterator();
            while (iterator.hasNext()) {
                object3 = (FavoriteHost)iterator.next();
                object2 = new DFavoriteHost();
                object = ((FavoriteHost)object3).getHostAddress();
                if (object.isIpHostName()) {
                    ((DFavoriteHost)object2).setIp(object.getIpAddress().getHostIP());
                } else {
                    ((DFavoriteHost)object2).setHostName(object.getHostName());
                }
                ((DFavoriteHost)object2).setPort(object.getPort());
                list.add(object2);
            }
            object3 = NetworkManager.getInstance();
            object2 = ((NetworkManager)object3).getGnutellaNetwork().getFavoritesFile();
            object = FileManager.getInstance().getReadWriteManagedFile((File)object2);
            XMLBuilder.saveToFile((ManagedFile)object, dPhex);
            this.hasChangedSinceLastSave = false;
        }
        catch (IOException iOException) {
            NLogger.error("Favorites", (Object)iOException, (Throwable)iOException);
            Environment.getInstance().fireDisplayUserMessage("FavoritesSettingsSaveFailed", new String[]{iOException.toString()});
        }
        catch (ManagedFileException managedFileException) {
            NLogger.error("Favorites", (Object)managedFileException, (Throwable)managedFileException);
            Environment.getInstance().fireDisplayUserMessage("FavoritesSettingsSaveFailed", new String[]{managedFileException.toString()});
        }
    }

    public synchronized int getBookmarkedHostsCount() {
        return this.favoritesList.size();
    }

    public synchronized FavoriteHost getBookmarkedHostAt(int n) {
        if (n >= this.favoritesList.size()) {
            return null;
        }
        return (FavoriteHost)this.favoritesList.get(n);
    }

    private synchronized void insertBookmarkedHost(FavoriteHost favoriteHost, int n) {
        if (!this.favoritesList.contains(favoriteHost)) {
            this.favoritesList.add(n, favoriteHost);
            this.hasChangedSinceLastSave = true;
            this.fireBookmarkedHostAdded(n);
        }
    }

    public synchronized void removeBookmarkedHost(FavoriteHost favoriteHost) {
        int n = this.favoritesList.indexOf(favoriteHost);
        if (n >= 0) {
            this.favoritesList.remove(n);
            this.fireBookmarkedHostRemoved(n);
            this.hasChangedSinceLastSave = true;
        }
    }

    public void addBookmarkedHostsChangeListener(BookmarkedHostsChangeListener bookmarkedHostsChangeListener) {
        this.listenerList.add(bookmarkedHostsChangeListener);
    }

    public void removeBookmarkedHostsChangeListener(BookmarkedHostsChangeListener bookmarkedHostsChangeListener) {
        this.listenerList.remove(bookmarkedHostsChangeListener);
    }

    private void fireBookmarkedHostAdded(final int n) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = FavoritesContainer.this.listenerList.toArray();
                for (int i = objectArray.length - 1; i >= 0; --i) {
                    BookmarkedHostsChangeListener bookmarkedHostsChangeListener = (BookmarkedHostsChangeListener)objectArray[i];
                    bookmarkedHostsChangeListener.bookmarkedHostAdded(n);
                }
            }
        });
    }

    private void fireBookmarkedHostRemoved(final int n) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = FavoritesContainer.this.listenerList.toArray();
                for (int i = objectArray.length - 1; i >= 0; --i) {
                    BookmarkedHostsChangeListener bookmarkedHostsChangeListener = (BookmarkedHostsChangeListener)objectArray[i];
                    bookmarkedHostsChangeListener.bookmarkedHostRemoved(n);
                }
            }
        });
    }

    private class SaveFavoritesTimer
    extends TimerTask {
        public static final long TIMER_PERIOD = 60000L;

        private SaveFavoritesTimer() {
        }

        public void run() {
            try {
                ThreadPool.getInstance().addJob(new SaveFavoritesRunner(), "SaveBookmarkedHosts");
            }
            catch (Throwable throwable) {
                NLogger.error("Favorites", (Object)throwable, throwable);
            }
        }
    }

    private class SaveFavoritesRunner
    implements Runnable {
        private SaveFavoritesRunner() {
        }

        public void run() {
            FavoritesContainer.this.saveFavoriteHosts();
        }
    }
}

