/*
 * Decompiled with CFR 0.152.
 */
package phex.host;

import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import phex.common.ServiceManager;
import phex.common.address.DestAddress;
import phex.host.CaughtHost;
import phex.host.CaughtHostComparator;

public class CatchedHostCache {
    private TreeSet sortedHosts = new TreeSet(new CaughtHostComparator());
    private HashMap addressHostMapping = new HashMap();

    public synchronized CaughtHost getCaughHost(DestAddress destAddress) {
        return (CaughtHost)this.addressHostMapping.get(destAddress);
    }

    public synchronized void add(CaughtHost caughtHost) {
        if (this.addressHostMapping.containsKey(caughtHost.getHostAddress())) {
            return;
        }
        if (this.sortedHosts.size() < ServiceManager.sCfg.mNetMaxHostToCatch) {
            this.addressHostMapping.put(caughtHost.getHostAddress(), caughtHost);
            this.sortedHosts.add(caughtHost);
        } else {
            this.addressHostMapping.put(caughtHost.getHostAddress(), caughtHost);
            this.sortedHosts.add(caughtHost);
            this.check();
            if (this.sortedHosts.size() >= ServiceManager.sCfg.mNetMaxHostToCatch) {
                CaughtHost caughtHost2 = (CaughtHost)this.sortedHosts.first();
                this.remove(caughtHost2);
            }
        }
        this.check();
    }

    public synchronized void remove(CaughtHost caughtHost) {
        CaughtHost caughtHost2 = (CaughtHost)this.addressHostMapping.remove(caughtHost.getHostAddress());
        if (caughtHost2 != null) {
            this.sortedHosts.remove(caughtHost2);
        }
        this.check();
    }

    public synchronized void clear() {
        this.sortedHosts.clear();
        this.addressHostMapping.clear();
    }

    public synchronized Iterator iterator() {
        return this.sortedHosts.iterator();
    }

    private void check() {
    }
}

