/*
 * Decompiled with CFR 0.152.
 */
package phex.gwebcache;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import phex.common.GeneralGnutellaNetwork;
import phex.common.ThreadPool;
import phex.common.address.AddressUtils;
import phex.common.address.DestAddress;
import phex.connection.NetworkManager;
import phex.connection.ProtocolNotSupportedException;
import phex.gwebcache.GWebCache;
import phex.gwebcache.GWebCacheComparator;
import phex.gwebcache.GWebCacheConnection;
import phex.host.CaughtHostsContainer;
import phex.host.HostManager;
import phex.utils.NLogger;
import phex.utils.NormalizableURL;
import phex.utils.StringUtils;

public class GWebCacheContainer {
    private static int MIN_G_WEB_CACHES_SIZE;
    private static int MAX_G_WEB_CACHES_SIZE;
    private static List BLOCKED_WEB_CACHES;
    private static List PHEX_WEB_CACHES;
    private ArrayList allGWebCaches;
    private ArrayList functionalGWebCaches;
    private ArrayList phexGWebCaches;
    private Set uniqueGWebCacheURLs;
    private TreeSet sortedGWebCaches;
    private Random random;
    static final /* synthetic */ boolean $assertionsDisabled;

    public GWebCacheContainer() {
        NLogger.debug("GWEBCACHE", (Object)"Initializing GWebCacheContainer");
        this.allGWebCaches = new ArrayList();
        this.phexGWebCaches = new ArrayList();
        this.functionalGWebCaches = new ArrayList();
        this.uniqueGWebCacheURLs = new HashSet();
        this.sortedGWebCaches = new TreeSet(new GWebCacheComparator());
        this.random = new Random();
        NLogger.debug("GWEBCACHE", (Object)"Initialized GWebCacheContainer");
    }

    public void initializeGWebCacheContainer() {
        this.allGWebCaches.clear();
        this.phexGWebCaches.clear();
        this.functionalGWebCaches.clear();
        this.uniqueGWebCacheURLs.clear();
        this.sortedGWebCaches.clear();
        this.insertPhexGWebCaches();
        Runnable runnable = new Runnable(){

            public void run() {
                GWebCacheContainer.this.loadGWebCacheFromFile();
            }
        };
        ThreadPool.getInstance().addJob(runnable, "LoadGWebCacheRunner");
    }

    public boolean queryMoreHosts(boolean bl) {
        int n = 0;
        boolean bl2 = false;
        do {
            ++n;
            GWebCacheConnection gWebCacheConnection = this.getRandomGWebCacheConnection(bl);
            if (gWebCacheConnection == null) continue;
            DestAddress[] destAddressArray = gWebCacheConnection.sendHostFileRequest();
            if (!this.verifyGWebCache(gWebCacheConnection) || destAddressArray == null) continue;
            CaughtHostsContainer caughtHostsContainer = HostManager.getInstance().getCaughtHostsContainer();
            for (int i = 0; i < destAddressArray.length; ++i) {
                caughtHostsContainer.addCaughtHost(destAddressArray[i], (short)2);
            }
            bl2 = true;
        } while (!bl2 && n < 5);
        return bl2;
    }

    public boolean updateRemoteGWebCache(DestAddress destAddress, boolean bl) {
        String string = null;
        if (destAddress != null) {
            string = destAddress.getFullHostName();
        }
        int n = 0;
        boolean bl2 = false;
        do {
            ++n;
            GWebCacheConnection gWebCacheConnection = this.getRandomGWebCacheConnection(bl);
            if (gWebCacheConnection == null) continue;
            GWebCache gWebCache = this.getGWebCacheForUpdate(gWebCacheConnection.getGWebCache());
            if (!($assertionsDisabled || !gWebCache.isPhexCache() && gWebCache.equals(gWebCacheConnection.getGWebCache()))) {
                throw new AssertionError((Object)("isPhexCache: " + gWebCache.isPhexCache() + ",equals " + gWebCache.getUrl() + " - " + gWebCacheConnection.getGWebCache().getUrl()));
            }
            String string2 = null;
            if (gWebCache != null) {
                string2 = gWebCache.getUrl().toExternalForm();
            }
            if (string == null && string2 == null) continue;
            bl2 = gWebCacheConnection.updateRequest(string, string2);
            if (this.verifyGWebCache(gWebCacheConnection) && bl2) continue;
        } while (!bl2 && n < 5);
        return bl2;
    }

    public boolean queryMoreGWebCaches(boolean bl) {
        int n = 0;
        boolean bl2 = false;
        do {
            ++n;
            GWebCacheConnection gWebCacheConnection = this.getRandomGWebCacheConnection(bl);
            if (gWebCacheConnection == null) continue;
            URL[] uRLArray = gWebCacheConnection.sendURLFileRequest();
            if (!this.verifyGWebCache(gWebCacheConnection) || uRLArray == null) continue;
            for (int i = 0; i < uRLArray.length; ++i) {
                try {
                    GWebCache gWebCache = new GWebCache(uRLArray[i]);
                    if (!this.isCacheAccessAllowed(gWebCache)) continue;
                    this.insertGWebCache(gWebCache);
                    continue;
                }
                catch (IOException iOException) {
                    NLogger.debug("GWEBCACHE", (Object)iOException);
                }
            }
            bl2 = true;
        } while (!bl2 && n < 5);
        return bl2;
    }

    public int getGWebCacheCount() {
        return this.allGWebCaches.size();
    }

    private GWebCache getGWebCacheForUpdate(GWebCache gWebCache) {
        GWebCache gWebCache2 = null;
        int n = this.functionalGWebCaches.size();
        if (n == 0) {
            return null;
        }
        if (n == 1) {
            gWebCache2 = (GWebCache)this.functionalGWebCaches.get(0);
            if (gWebCache2.equals(gWebCache)) {
                return null;
            }
            if (!$assertionsDisabled && gWebCache2.isPhexCache()) {
                throw new AssertionError();
            }
            return gWebCache2;
        }
        int n2 = 0;
        do {
            int n3;
            if ((gWebCache2 = (GWebCache)this.functionalGWebCaches.get(n3 = this.random.nextInt(n - 1))).equals(gWebCache)) continue;
            if (!$assertionsDisabled && gWebCache2.isPhexCache()) {
                throw new AssertionError();
            }
            return gWebCache2;
        } while (++n2 < 10);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GWebCache getRandomGWebCache(boolean bl) {
        this.ensureMinGWebCaches();
        ArrayList arrayList = this.allGWebCaches;
        synchronized (arrayList) {
            GWebCache gWebCache;
            boolean bl2;
            boolean bl3 = bl2 = bl && this.random.nextInt(8) == 0;
            if (bl2 && this.phexGWebCaches.size() > 0) {
                int n = this.random.nextInt(this.phexGWebCaches.size());
                return (GWebCache)this.phexGWebCaches.get(n);
            }
            int n = this.allGWebCaches.size();
            if (n == 0) {
                return null;
            }
            long l = System.currentTimeMillis();
            if (l > (gWebCache = (GWebCache)this.sortedGWebCaches.first()).getEarliestReConnectTime()) {
                return gWebCache;
            }
            return null;
        }
    }

    private GWebCacheConnection getRandomGWebCacheConnection(boolean bl) {
        GWebCacheConnection gWebCacheConnection = null;
        GWebCache gWebCache = null;
        try {
            gWebCache = this.getRandomGWebCache(bl);
            if (gWebCache == null) {
                return null;
            }
            gWebCacheConnection = new GWebCacheConnection(gWebCache);
        }
        catch (ProtocolNotSupportedException protocolNotSupportedException) {
            this.removeGWebCache(gWebCache, true);
            return null;
        }
        return gWebCacheConnection;
    }

    private boolean verifyGWebCache(GWebCacheConnection gWebCacheConnection) {
        GWebCache gWebCache = gWebCacheConnection.getGWebCache();
        this.sortedGWebCaches.remove(gWebCache);
        gWebCache.countConnectionAttempt(gWebCacheConnection.isCacheBad());
        this.sortedGWebCaches.add(gWebCache);
        if (!(gWebCacheConnection.isCacheBad() || gWebCache.isPhexCache() || this.functionalGWebCaches.contains(gWebCache))) {
            this.functionalGWebCaches.add(gWebCache);
        }
        this.saveGWebCacheToFile();
        return true;
    }

    private GWebCache parseGWebCacheFromLine(String string) throws IOException {
        int n;
        long l;
        String string2;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        int n2 = stringTokenizer.countTokens();
        if (n2 == 1) {
            string2 = string;
            l = -1L;
            n = -1;
        } else if (n2 == 3) {
            string2 = stringTokenizer.nextToken();
            try {
                l = Long.parseLong(stringTokenizer.nextToken());
            }
            catch (NumberFormatException numberFormatException) {
                l = -1L;
            }
            try {
                n = Integer.parseInt(stringTokenizer.nextToken());
            }
            catch (NumberFormatException numberFormatException) {
                n = -1;
            }
        } else {
            NLogger.warn("GWEBCACHE", (Object)("Unknown HostCache line format: " + string));
            return null;
        }
        NormalizableURL normalizableURL = new NormalizableURL(string2);
        normalizableURL.normalize();
        URL uRL = new URL(normalizableURL.toExternalForm());
        GWebCache gWebCache = new GWebCache(uRL);
        if (l > 0L) {
            gWebCache.setLastRequestTime(l);
        }
        if (n > 0) {
            gWebCache.setFailedInRowCount(n);
        }
        return gWebCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertGWebCache(GWebCache gWebCache) {
        ArrayList arrayList = this.allGWebCaches;
        synchronized (arrayList) {
            if (this.allGWebCaches.size() >= MAX_G_WEB_CACHES_SIZE) {
                NLogger.error("GWEBCACHE", "Limit of 1000 GWebCaches reached.");
                this.removeGWebCache((GWebCache)this.sortedGWebCaches.last(), true);
                return;
            }
            String string = gWebCache.getHostDomain();
            if (!this.uniqueGWebCacheURLs.contains(string)) {
                this.allGWebCaches.add(gWebCache);
                this.sortedGWebCaches.add(gWebCache);
                this.uniqueGWebCacheURLs.add(string);
                if (gWebCache.isPhexCache()) {
                    this.phexGWebCaches.add(gWebCache);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeGWebCache(GWebCache gWebCache, boolean bl) {
        ArrayList arrayList = this.allGWebCaches;
        synchronized (arrayList) {
            if (this.allGWebCaches.size() > MIN_G_WEB_CACHES_SIZE || bl) {
                this.allGWebCaches.remove(gWebCache);
                this.functionalGWebCaches.remove(gWebCache);
                this.sortedGWebCaches.remove(gWebCache);
                String string = gWebCache.getHostDomain();
                this.uniqueGWebCacheURLs.remove(string);
                if (gWebCache.isPhexCache()) {
                    this.phexGWebCaches.remove(gWebCache);
                }
                this.saveGWebCacheToFile();
            }
        }
    }

    private void insertGWebCacheFromLine(String string) {
        try {
            GWebCache gWebCache = this.parseGWebCacheFromLine(string);
            if (gWebCache != null && this.isCacheAccessAllowed(gWebCache)) {
                this.insertGWebCache(gWebCache);
            }
        }
        catch (IOException iOException) {
            NLogger.debug("GWEBCACHE", (Object)iOException);
        }
    }

    private void ensureMinGWebCaches() {
        if (this.allGWebCaches.size() >= 10) {
            return;
        }
        NetworkManager networkManager = NetworkManager.getInstance();
        if (!(networkManager.getGnutellaNetwork() instanceof GeneralGnutellaNetwork)) {
            return;
        }
        NLogger.debug("GWEBCACHE", (Object)"Load default GWebCache file.");
        InputStream inputStream = ClassLoader.getSystemResourceAsStream("phex/resources/gwebcache.cfg");
        if (inputStream != null) {
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            try {
                this.loadGWebCacheFromReader(inputStreamReader);
                this.saveGWebCacheToFile();
            }
            catch (IOException iOException) {
                NLogger.warn("GWEBCACHE", (Object)iOException, (Throwable)iOException);
            }
        } else {
            NLogger.warn("GWEBCACHE", (Object)"Default GWebCache file not found.");
        }
        if (this.allGWebCaches.size() < 1) {
            this.insertPhexGWebCaches();
            this.saveGWebCacheToFile();
        }
    }

    private void insertPhexGWebCaches() {
        NetworkManager networkManager = NetworkManager.getInstance();
        if (!(networkManager.getGnutellaNetwork() instanceof GeneralGnutellaNetwork)) {
            return;
        }
        Iterator iterator = PHEX_WEB_CACHES.iterator();
        while (iterator.hasNext()) {
            try {
                String string = (String)iterator.next();
                URL uRL = new URL(string);
                GWebCache gWebCache = new GWebCache(uRL, true);
                this.insertGWebCache(gWebCache);
            }
            catch (IOException iOException) {
                NLogger.error("GWEBCACHE", (Object)iOException, (Throwable)iOException);
            }
        }
    }

    private boolean isCacheAccessAllowed(GWebCache gWebCache) {
        URL uRL = gWebCache.getUrl();
        String string = uRL.getHost();
        if (AddressUtils.isIPHostName(string) && StringUtils.isEmpty(uRL.getPath())) {
            return false;
        }
        Iterator iterator = BLOCKED_WEB_CACHES.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (string.indexOf(string2) == -1) continue;
            NLogger.debug("GWEBCACHE", (Object)"GWebCache host blocked.");
            return false;
        }
        return true;
    }

    public boolean isPhexGWebCache(String string) {
        return PHEX_WEB_CACHES.indexOf(string) != -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadGWebCacheFromFile() {
        try {
            NetworkManager networkManager = NetworkManager.getInstance();
            File file = networkManager.getGnutellaNetwork().getGWebCacheFile();
            if (!file.exists()) {
                return;
            }
            this.loadGWebCacheFromReader(new FileReader(file));
        }
        catch (IOException iOException) {
            NLogger.error("GWEBCACHE", (Object)iOException, (Throwable)iOException);
        }
        finally {
            this.ensureMinGWebCaches();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadGWebCacheFromReader(Reader reader) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(reader);
        ArrayList arrayList = this.allGWebCaches;
        synchronized (arrayList) {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                if (string.startsWith("#")) continue;
                this.insertGWebCacheFromLine(string);
            }
        }
        bufferedReader.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveGWebCacheToFile() {
        NLogger.debug("GWEBCACHE", (Object)"Saving GWebCaches.");
        try {
            NetworkManager networkManager = NetworkManager.getInstance();
            File file = networkManager.getGnutellaNetwork().getGWebCacheFile();
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            ArrayList arrayList = this.allGWebCaches;
            synchronized (arrayList) {
                Iterator iterator = this.allGWebCaches.iterator();
                while (iterator.hasNext()) {
                    GWebCache gWebCache = (GWebCache)iterator.next();
                    if (gWebCache.isPhexCache()) continue;
                    bufferedWriter.write(gWebCache.getUrl().toExternalForm() + " " + gWebCache.getLastRequestTime() + " " + gWebCache.getFailedInRowCount());
                    bufferedWriter.newLine();
                }
            }
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            NLogger.error("GWEBCACHE", (Object)iOException, (Throwable)iOException);
        }
    }

    static {
        $assertionsDisabled = !GWebCacheContainer.class.desiredAssertionStatus();
        MIN_G_WEB_CACHES_SIZE = 5;
        MAX_G_WEB_CACHES_SIZE = 1000;
        String[] stringArray = new String[]{"http://gc-phex02.draketo.de/gcache.php", "http://phexgwc.kouk.de/gcache.php"};
        PHEX_WEB_CACHES = Collections.unmodifiableList(Arrays.asList(stringArray));
        String[] stringArray2 = new String[]{"gavinroy.com"};
        BLOCKED_WEB_CACHES = Collections.unmodifiableList(Arrays.asList(stringArray2));
    }
}

