/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs.search.monitor;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.tree.TreePath;
import phex.chat.ChatManager;
import phex.common.ServiceManager;
import phex.common.ThreadPool;
import phex.common.address.DestAddress;
import phex.download.RemoteFile;
import phex.download.swarming.SWDownloadFile;
import phex.download.swarming.SwarmingManager;
import phex.gui.actions.BanHostActionUtils;
import phex.gui.actions.FWAction;
import phex.gui.actions.GUIActionPerformer;
import phex.gui.common.BrowserLauncher;
import phex.gui.common.FWElegantPanel;
import phex.gui.common.FWToolBar;
import phex.gui.common.GUIRegistry;
import phex.gui.common.GUIUtils;
import phex.gui.common.LabeledIcon;
import phex.gui.common.table.FWTable;
import phex.gui.common.table.FWTableColumn;
import phex.gui.common.table.FWTableColumnModel;
import phex.gui.common.table.FWTableModel;
import phex.gui.common.table.SortedTableHeaderRenderer;
import phex.gui.common.treetable.JTreeTable;
import phex.gui.dialogs.DownloadConfigDialog;
import phex.gui.models.ISearchDataModel;
import phex.gui.models.SearchTreeTableModel;
import phex.gui.renderer.SearchResultsRowRenderer;
import phex.gui.renderer.SearchTreeCellRenderer;
import phex.gui.tabs.FWTab;
import phex.gui.tabs.search.SearchResultElement;
import phex.gui.tabs.search.monitor.ResultMonitorDataModel;
import phex.msg.MsgManager;
import phex.query.QueryResultMonitor;
import phex.query.SearchFilter;
import phex.utils.Localizer;
import phex.utils.NLogger;
import phex.utils.StringUtils;
import phex.utils.URLUtil;
import phex.xml.sax.gui.DGuiSettings;
import phex.xml.sax.gui.DTable;
import phex.xml.sax.gui.DTableColumnList;

public class ResultMonitorTab
extends FWTab {
    private static final RemoteFile[] EMPTY_REMOTE_FILE_ARRAY = new RemoteFile[0];
    private static final String PASSIVE_SEARCH_TABLE_IDENTIFIER = "PassiveSearchTable";
    private JPopupMenu searchResultPopup;
    private JTextField mPassiveSearch;
    private JButton mPassiveButton;
    private JTreeTable searchTreeTable;
    private SearchTreeTableModel searchTreeTableModel;
    private FWTableColumnModel searchTreeColumnModel;
    private ResultMonitorDataModel resultDataModel;
    private JScrollPane searchTreeTableScrollPane;
    private static final String QUICK_DOWNLOAD_ACTION_KEY = "SWQuickDownloadAction";
    private static final String CONFIG_DOWNLOAD_ACTION_KEY = "SWConfigDownloadAction";
    private static final String VIEW_BITZI_TICKET_ACTION_KEY = "ViewBitziTicketAction";
    private static final String CHAT_TO_HOST_ACTION_KEY = "ChatToHostAction";
    private static final String BROWSE_HOST_ACTION_KEY = "BrowseHostAction";
    private static final String ADD_TO_FAVORITES_ACTION_KEY = "AddToFavoritesAction";

    public ResultMonitorTab() {
        super(1009, Localizer.getString("ResultMonitorTab_ResultMonitor"), GUIRegistry.getInstance().getIconFactory().getIcon("Monitor"), Localizer.getString("ResultMonitorTab_TTTResultMonitor"), Localizer.getChar("ResultMonitorTab_Mnemonic"), KeyStroke.getKeyStroke(Localizer.getString("ResultMonitorTab_Accelerator")), 8);
    }

    public void initComponent(DGuiSettings dGuiSettings) {
        Serializable serializable;
        CellConstraints cellConstraints = new CellConstraints();
        FormLayout formLayout = new FormLayout("2dlu, fill:d:grow, 2dlu", "2dlu, fill:p:grow, 2dlu");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout, this);
        JPanel jPanel = new JPanel();
        FWElegantPanel fWElegantPanel = new FWElegantPanel(Localizer.getString("ResultMonitorTab_ResultMonitor"), jPanel);
        panelBuilder.add((Component)fWElegantPanel, cellConstraints.xy(2, 2));
        FormLayout formLayout2 = new FormLayout("fill:d:grow", "p, 1dlu, fill:d:grow, 1dlu, p");
        PanelBuilder panelBuilder2 = new PanelBuilder(formLayout2, jPanel);
        JPanel jPanel2 = new JPanel();
        panelBuilder2.add((Component)jPanel2, cellConstraints.xy(1, 1));
        FormLayout formLayout3 = new FormLayout("d, 1dlu, d, 1dlu, d, 1dlu, d", "p");
        PanelBuilder panelBuilder3 = new PanelBuilder(formLayout3, jPanel2);
        panelBuilder3.addLabel(Localizer.getString("ResultMonitorTab_ResultFilter"), cellConstraints.xy(1, 1));
        this.mPassiveSearch = new JTextField("", 20);
        this.mPassiveSearch.setToolTipText(Localizer.getString("ResultMonitorTab_TTTPassiveSearch"));
        panelBuilder3.add((Component)this.mPassiveSearch, cellConstraints.xy(3, 1));
        this.mPassiveButton = new JButton(Localizer.getString("ResultMonitorTab_StartPassiveSearch"));
        this.mPassiveButton.setToolTipText(Localizer.getString("ResultMonitorTab_TTTStartPassiveSearch"));
        this.mPassiveButton.addActionListener(new PassiveSearchHandler());
        panelBuilder3.add((Component)this.mPassiveButton, cellConstraints.xy(5, 1));
        MouseHandler mouseHandler = new MouseHandler();
        this.searchTreeTableModel = new SearchTreeTableModel();
        this.searchTreeTable = new JTreeTable(this.searchTreeTableModel);
        this.buildSearchTreeTableColumnModel(dGuiSettings);
        this.searchTreeTable.setColumnModel(this.searchTreeColumnModel);
        this.searchTreeTable.activateHeaderPopupMenu();
        this.searchTreeTable.activateColumnResizeToFit();
        JTableHeader jTableHeader = this.searchTreeTable.getTableHeader();
        jTableHeader.setDefaultRenderer(new SortedTableHeaderRenderer(this.searchTreeTable));
        jTableHeader.addMouseListener(new TableHeaderMouseHandler());
        this.searchTreeTable.addMouseListener(mouseHandler);
        this.searchTreeTable.setAutoResizeMode(0);
        this.searchTreeTable.setClosedIcon(new LabeledIcon(UIManager.getIcon("Tree.closedIcon"), null));
        this.searchTreeTable.getSelectionModel().addListSelectionListener(new SearchTreeTableSelectionListener());
        this.searchTreeTable.setTreeCellRenderer(new SearchTreeCellRenderer());
        SearchResultsRowRenderer searchResultsRowRenderer = new SearchResultsRowRenderer(this.searchTreeTableModel);
        Enumeration<TableColumn> enumeration = this.searchTreeColumnModel.getColumns();
        while (enumeration.hasMoreElements()) {
            serializable = enumeration.nextElement();
            ((TableColumn)serializable).setCellRenderer(searchResultsRowRenderer);
        }
        this.searchTreeTableScrollPane = FWTable.createFWTableScrollPane(this.searchTreeTable);
        this.searchTreeTableScrollPane.addMouseListener(mouseHandler);
        panelBuilder2.add((Component)this.searchTreeTableScrollPane, cellConstraints.xy(1, 3));
        this.resultDataModel = new ResultMonitorDataModel();
        this.searchTreeTableModel.setDisplayedSearch(this.resultDataModel);
        serializable = new FWToolBar(0);
        ((JToolBar)serializable).setBorderPainted(false);
        ((JToolBar)serializable).setFloatable(false);
        panelBuilder2.add((Component)serializable, cellConstraints.xy(1, 5));
        this.searchResultPopup = new JPopupMenu();
        FWAction fWAction = new SWQuickDownloadAction();
        this.addTabAction(QUICK_DOWNLOAD_ACTION_KEY, fWAction);
        ((FWToolBar)serializable).addAction(fWAction);
        this.searchResultPopup.add(fWAction);
        fWAction = new SWConfigDownloadAction();
        this.addTabAction(CONFIG_DOWNLOAD_ACTION_KEY, fWAction);
        ((FWToolBar)serializable).addAction(fWAction);
        this.searchResultPopup.add(fWAction);
        fWAction = new ViewBitziTicketAction();
        this.addTabAction(VIEW_BITZI_TICKET_ACTION_KEY, fWAction);
        ((FWToolBar)serializable).addAction(fWAction);
        this.searchResultPopup.add(fWAction);
        this.searchResultPopup.addSeparator();
        fWAction = new AddToFavoritesAction();
        this.addTabAction(ADD_TO_FAVORITES_ACTION_KEY, fWAction);
        this.searchResultPopup.add(fWAction);
        fWAction = new BrowseHostAction();
        this.addTabAction(BROWSE_HOST_ACTION_KEY, fWAction);
        ((FWToolBar)serializable).addAction(fWAction);
        this.searchResultPopup.add(fWAction);
        fWAction = new ChatToHostAction();
        this.addTabAction(CHAT_TO_HOST_ACTION_KEY, fWAction);
        ((FWToolBar)serializable).addAction(fWAction);
        this.searchResultPopup.add(fWAction);
        BanHostActionProvider banHostActionProvider = new BanHostActionProvider();
        BanHostActionUtils.BanHostActionMenu banHostActionMenu = BanHostActionUtils.createActionMenu(banHostActionProvider);
        this.searchResultPopup.add(banHostActionMenu.menu);
        this.addTabActions(banHostActionMenu.actions);
        fWAction = BanHostActionUtils.createToolBarAction(banHostActionProvider);
        ((FWToolBar)serializable).addAction(fWAction);
        this.addTabAction(fWAction);
        this.searchResultPopup.addSeparator();
    }

    public boolean isVisibleByDefault() {
        return false;
    }

    public void updateUI() {
        super.updateUI();
        if (this.searchTreeTableScrollPane != null) {
            FWTable.updateFWTableScrollPane(this.searchTreeTableScrollPane);
        }
    }

    private RemoteFile getSelectedRemoteFile(boolean bl) {
        RemoteFile remoteFile;
        ISearchDataModel iSearchDataModel = this.searchTreeTableModel.getDisplayedResultsData();
        if (iSearchDataModel == null) {
            return null;
        }
        TreePath treePath = this.searchTreeTable.getTreeSelectionModel().getSelectionPath();
        if (treePath == null) {
            return null;
        }
        if (treePath.getPathCount() == 3) {
            remoteFile = (RemoteFile)treePath.getPathComponent(2);
        } else {
            SearchResultElement searchResultElement = (SearchResultElement)treePath.getPathComponent(1);
            if (!bl && searchResultElement.getRemoteFileListCount() != 0) {
                return null;
            }
            remoteFile = searchResultElement.getSingleRemoteFile();
        }
        return remoteFile;
    }

    public RemoteFile[] getSelectedRemoteFiles(boolean bl) {
        ISearchDataModel iSearchDataModel = this.searchTreeTableModel.getDisplayedResultsData();
        if (iSearchDataModel == null) {
            return EMPTY_REMOTE_FILE_ARRAY;
        }
        TreePath[] treePathArray = this.searchTreeTable.getTreeSelectionModel().getSelectionPaths();
        if (treePathArray.length == 0) {
            return EMPTY_REMOTE_FILE_ARRAY;
        }
        HashSet<Object> hashSet = new HashSet<Object>();
        for (int i = 0; i < treePathArray.length; ++i) {
            RemoteFile[] remoteFileArray;
            Object object;
            if (treePathArray[i].getPathCount() == 3) {
                if (bl) {
                    object = (SearchResultElement)treePathArray[i].getPathComponent(1);
                    remoteFileArray = ((SearchResultElement)object).getRemoteFiles();
                    hashSet.addAll(Arrays.asList(remoteFileArray));
                    continue;
                }
                object = (RemoteFile)treePathArray[i].getPathComponent(2);
                hashSet.add(object);
                continue;
            }
            object = (SearchResultElement)treePathArray[i].getPathComponent(1);
            remoteFileArray = ((SearchResultElement)object).getRemoteFiles();
            hashSet.addAll(Arrays.asList(remoteFileArray));
        }
        RemoteFile[] remoteFileArray = new RemoteFile[hashSet.size()];
        hashSet.toArray(remoteFileArray);
        return remoteFileArray;
    }

    private void buildSearchTreeTableColumnModel(DGuiSettings dGuiSettings) {
        DTable dTable = GUIUtils.getDGuiTableByIdentifier(dGuiSettings, PASSIVE_SEARCH_TABLE_IDENTIFIER);
        int[] nArray = SearchTreeTableModel.getColumnIdArray();
        DTableColumnList dTableColumnList = null;
        if (dTable != null) {
            dTableColumnList = dTable.getTableColumnList();
        }
        this.searchTreeColumnModel = new FWTableColumnModel((FWTableModel)this.searchTreeTable.getModel(), nArray, dTableColumnList);
    }

    public void appendDGuiSettings(DGuiSettings dGuiSettings) {
        super.appendDGuiSettings(dGuiSettings);
        DTableColumnList dTableColumnList = this.searchTreeColumnModel.createDGuiTableColumnList();
        DTable dTable = new DTable();
        dTable.setTableColumnList(dTableColumnList);
        dTable.setTableIdentifier(PASSIVE_SEARCH_TABLE_IDENTIFIER);
        dGuiSettings.getTableList().getTableList().add(dTable);
    }

    private class SearchTreeTableSelectionListener
    implements ListSelectionListener {
        private SearchTreeTableSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                ResultMonitorTab.this.refreshTabActions();
            }
        }
    }

    private class TableHeaderMouseHandler
    extends MouseAdapter
    implements MouseListener {
        private TableHeaderMouseHandler() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            FWTableColumn fWTableColumn = ResultMonitorTab.this.searchTreeTable.getResizingColumn(mouseEvent.getPoint());
            int n = mouseEvent.getClickCount();
            if (fWTableColumn == null && n == 1) {
                this.handleColumnSorting(mouseEvent);
            }
        }

        private void handleColumnSorting(MouseEvent mouseEvent) {
            int n = ResultMonitorTab.this.searchTreeTable.getColumnModel().getColumnIndexAtX(mouseEvent.getX());
            int n2 = ResultMonitorTab.this.searchTreeTable.convertColumnIndexToModel(n);
            if (n2 == -1) {
                return;
            }
            FWTableColumn fWTableColumn = (FWTableColumn)ResultMonitorTab.this.searchTreeTable.getColumnModel().getColumn(n);
            boolean bl = fWTableColumn.reverseSortingOrder();
            ResultMonitorTab.this.searchTreeTableModel.sortByColumn(n2, bl);
        }
    }

    private class PassiveSearchHandler
    implements ActionListener {
        private PassiveSearchHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MsgManager msgManager = MsgManager.getInstance();
            QueryResultMonitor queryResultMonitor = msgManager.getQueryResultMonitor();
            if (queryResultMonitor.getPassiveSearchFilter() == null) {
                String string = ResultMonitorTab.this.mPassiveSearch.getText().trim();
                SearchFilter searchFilter = new SearchFilter();
                searchFilter.updateSearchFilter(string);
                queryResultMonitor.updatePassiveSearchFilter(searchFilter);
                ResultMonitorTab.this.mPassiveButton.setText(Localizer.getString("ResultMonitorTab_StopPassiveSearch"));
            } else {
                queryResultMonitor.updatePassiveSearchFilter(null);
                ResultMonitorTab.this.mPassiveButton.setText(Localizer.getString("ResultMonitorTab_StartPassiveSearch"));
            }
        }
    }

    private class MouseHandler
    extends MouseAdapter
    implements MouseListener {
        private MouseHandler() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2 && mouseEvent.getSource() == ResultMonitorTab.this.searchTreeTable) {
                ResultMonitorTab.this.getTabAction(ResultMonitorTab.QUICK_DOWNLOAD_ACTION_KEY).actionPerformed(null);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.popupMenu((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.popupMenu((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
            }
        }

        private void popupMenu(Component component, int n, int n2) {
            if (component == ResultMonitorTab.this.searchTreeTable || component == ResultMonitorTab.this.searchTreeTableScrollPane) {
                ResultMonitorTab.this.searchResultPopup.show(component, n, n2);
            }
        }
    }

    private class AddToFavoritesAction
    extends FWAction {
        public AddToFavoritesAction() {
            super(Localizer.getString("AddToFavorites"), GUIRegistry.getInstance().getIconFactory().getIcon("FavoriteHost"), Localizer.getString("TTTAddToFavorites"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            RemoteFile[] remoteFileArray = ResultMonitorTab.this.getSelectedRemoteFiles(false);
            DestAddress[] destAddressArray = new DestAddress[remoteFileArray.length];
            for (int i = 0; i < remoteFileArray.length; ++i) {
                destAddressArray[i] = remoteFileArray[i].getHostAddress();
            }
            GUIActionPerformer.addHostsToFavorites(destAddressArray);
        }

        public void refreshActionState() {
            if (ResultMonitorTab.this.searchTreeTable.getSelectedRow() < 0) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
        }
    }

    private final class BanHostActionProvider
    implements BanHostActionUtils.BanHostActionProvider {
        private BanHostActionProvider() {
        }

        public DestAddress[] getBanHostAddresses() {
            RemoteFile[] remoteFileArray = ResultMonitorTab.this.getSelectedRemoteFiles(false);
            DestAddress[] destAddressArray = new DestAddress[remoteFileArray.length];
            for (int i = 0; i < remoteFileArray.length; ++i) {
                destAddressArray[i] = remoteFileArray[i].getHostAddress();
            }
            return destAddressArray;
        }

        public boolean isBanHostActionEnabled(boolean bl) {
            return ResultMonitorTab.this.searchTreeTable.getSelectedRow() >= 0 && (bl || ResultMonitorTab.this.searchTreeTable.getSelectedRowCount() <= 1);
        }
    }

    private class BrowseHostAction
    extends FWAction {
        public BrowseHostAction() {
            super(Localizer.getString("BrowseHost"), GUIRegistry.getInstance().getIconFactory().getIcon("BrowseHost"), Localizer.getString("TTTBrowseHost"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            RemoteFile remoteFile = ResultMonitorTab.this.getSelectedRemoteFile(false);
            if (remoteFile == null) {
                return;
            }
            if (!remoteFile.getQueryHitHost().isBrowseHostSupported()) {
                return;
            }
            GUIActionPerformer.browseHost(remoteFile.getHostAddress());
        }

        public void refreshActionState() {
            RemoteFile remoteFile;
            if (ResultMonitorTab.this.searchTreeTable.getSelectedRowCount() == 1 && (remoteFile = ResultMonitorTab.this.getSelectedRemoteFile(false)) != null && remoteFile.getQueryHitHost().isBrowseHostSupported()) {
                this.setEnabled(true);
                return;
            }
            this.setEnabled(false);
        }
    }

    private class ChatToHostAction
    extends FWAction {
        public ChatToHostAction() {
            super(Localizer.getString("ChatToHost"), GUIRegistry.getInstance().getIconFactory().getIcon("Chat"), Localizer.getString("TTTChatToHost"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            RemoteFile remoteFile = ResultMonitorTab.this.getSelectedRemoteFile(false);
            if (remoteFile == null) {
                return;
            }
            if (!remoteFile.getQueryHitHost().isChatSupported()) {
                return;
            }
            ChatManager.getInstance().openChat(remoteFile.getHostAddress());
        }

        public void refreshActionState() {
            RemoteFile remoteFile;
            if (ResultMonitorTab.this.searchTreeTable.getSelectedRowCount() == 1 && (remoteFile = ResultMonitorTab.this.getSelectedRemoteFile(false)) != null && remoteFile.getQueryHitHost().isChatSupported()) {
                this.setEnabled(true);
                return;
            }
            this.setEnabled(false);
        }
    }

    private class ViewBitziTicketAction
    extends FWAction {
        public ViewBitziTicketAction() {
            super(Localizer.getString("ViewBitziTicket"), GUIRegistry.getInstance().getIconFactory().getIcon("Bitzi"), Localizer.getString("TTTViewBitziTicket"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            block3: {
                RemoteFile remoteFile = ResultMonitorTab.this.getSelectedRemoteFile(true);
                if (remoteFile == null) {
                    return;
                }
                String string = URLUtil.buildBitziLookupURL(remoteFile.getURN());
                try {
                    BrowserLauncher.openURL(string);
                }
                catch (IOException iOException) {
                    NLogger.warn("USER_INTERFACE", (Object)iOException, (Throwable)iOException);
                    Object[] objectArray = new Object[]{Localizer.getString("Yes"), Localizer.getString("No")};
                    int n = JOptionPane.showOptionDialog(ResultMonitorTab.this, Localizer.getString("FailedToLaunchBrowserURLInClipboard"), Localizer.getString("FailedToLaunchBrowser"), 0, 2, null, objectArray, Localizer.getString("Yes"));
                    if (n != 0) break block3;
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(string), null);
                }
            }
        }

        public void refreshActionState() {
            if (ResultMonitorTab.this.searchTreeTable.getSelectedRowCount() == 1) {
                RemoteFile remoteFile = ResultMonitorTab.this.getSelectedRemoteFile(true);
                if (remoteFile != null && remoteFile.getURN() != null) {
                    this.setEnabled(true);
                    return;
                }
            } else {
                this.setEnabled(false);
            }
        }
    }

    private class SWConfigDownloadAction
    extends FWAction {
        public SWConfigDownloadAction() {
            super(Localizer.getString("Download"), GUIRegistry.getInstance().getIconFactory().getIcon("ConfigDownload"), Localizer.getString("TTTDownload"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SwarmingManager swarmingManager = SwarmingManager.getInstance();
            RemoteFile[] remoteFileArray = ResultMonitorTab.this.getSelectedRemoteFiles(true);
            for (int i = 0; i < remoteFileArray.length; ++i) {
                SWDownloadFile sWDownloadFile = swarmingManager.getDownloadFile(remoteFileArray[i].getFileSize(), remoteFileArray[i].getURN());
                if (sWDownloadFile != null) {
                    sWDownloadFile.addDownloadCandidate(remoteFileArray[i]);
                    remoteFileArray[i].setInDownloadQueue(true);
                    continue;
                }
                RemoteFile remoteFile = new RemoteFile(remoteFileArray[i]);
                DownloadConfigDialog downloadConfigDialog = new DownloadConfigDialog(remoteFile);
                downloadConfigDialog.show();
                if (!remoteFile.isInDownloadQueue()) continue;
                remoteFileArray[i].setInDownloadQueue(true);
            }
        }

        public void refreshActionState() {
            if (ResultMonitorTab.this.searchTreeTable.getSelectedRow() < 0) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
        }
    }

    private class SWQuickDownloadAction
    extends FWAction {
        public SWQuickDownloadAction() {
            super(Localizer.getString("QuickDownload"), GUIRegistry.getInstance().getIconFactory().getIcon("Download"), Localizer.getString("TTTQuickDownload"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            final RemoteFile[] remoteFileArray = ResultMonitorTab.this.getSelectedRemoteFiles(true);
            Runnable runnable = new Runnable(){

                public void run() {
                    try {
                        SwarmingManager swarmingManager = SwarmingManager.getInstance();
                        for (int i = 0; i < remoteFileArray.length; ++i) {
                            remoteFileArray[i].setInDownloadQueue(true);
                            SWDownloadFile sWDownloadFile = swarmingManager.getDownloadFile(remoteFileArray[i].getFileSize(), remoteFileArray[i].getURN());
                            if (sWDownloadFile != null) {
                                sWDownloadFile.addDownloadCandidate(remoteFileArray[i]);
                                continue;
                            }
                            RemoteFile remoteFile = new RemoteFile(remoteFileArray[i]);
                            String string = StringUtils.createNaturalSearchTerm(remoteFile.getFilename());
                            swarmingManager.addFileToDownload(remoteFile, ServiceManager.sCfg.mDownloadDir + File.separator + remoteFile.getFilename(), string);
                        }
                    }
                    catch (Throwable throwable) {
                        NLogger.error("USER_INTERFACE", (Object)throwable, throwable);
                    }
                }
            };
            ThreadPool.getInstance().addJob(runnable, "QuickDownloadAction");
        }

        public void refreshActionState() {
            if (ResultMonitorTab.this.searchTreeTable.getSelectedRow() < 0) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
        }
    }
}

