/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs.search.filterpanel;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicButtonUI;
import phex.gui.common.GUIRegistry;
import phex.gui.common.GUIUtils;
import phex.gui.common.IconFactory;
import phex.gui.common.PhexColors;
import phex.gui.tabs.search.SearchResultsDataModel;
import phex.gui.tabs.search.SearchTab;
import phex.gui.tabs.search.filterpanel.FilterListPanel;
import phex.gui.tabs.search.filterpanel.QuickFilterPanel;
import phex.utils.Localizer;

public class SearchFilterPanel
extends JPanel {
    private static Border LEFT_BUTTON_BORDER = new CompoundBorder(BorderFactory.createMatteBorder(1, 1, 1, 0, UIManager.getDefaults().getColor("window")), new EmptyBorder(5, 7, 5, 11));
    private SearchTab searchTab;
    private JPanel topLayoutPanel;
    private JPanel leftLayoutPanel;
    private JPanel filterContentPanel;
    private JToggleButton quickFilterBtn;
    private JToggleButton filterListBtn;
    private QuickFilterPanel quickFilterPanel;
    private FilterListPanel filterListPanel;
    private Rectangle insideBorderBounds = new Rectangle();
    private Rectangle clipBounds = new Rectangle();

    public SearchFilterPanel(SearchTab searchTab) {
        this.searchTab = searchTab;
        this.setBorder(BorderFactory.createLineBorder(PhexColors.getBoxPanelBorderColor()));
        this.setBackground(UIManager.getDefaults().getColor("window"));
        CellConstraints cellConstraints = new CellConstraints();
        FormLayout formLayout = new FormLayout("p, fill:p:grow", "d, fill:d:grow");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout, this);
        this.topLayoutPanel = new JPanel();
        this.topLayoutPanel.setOpaque(false);
        formLayout = new FormLayout("4dlu, p, fill:8dlu:grow, p, 4dlu", "2dlu, p, 2dlu");
        PanelBuilder panelBuilder2 = new PanelBuilder(formLayout, this.topLayoutPanel);
        JLabel jLabel = new JLabel(Localizer.getString("SearchTab_SearchFilterOptions"));
        Font font = jLabel.getFont();
        Font font2 = font.deriveFont(1, font.getSize() + 2);
        jLabel.setFont(font2);
        panelBuilder2.add((Component)jLabel, cellConstraints.xy(2, 2));
        JButton jButton = new JButton(searchTab.getTabAction("FilterPanelToggleAction"));
        jButton.setText(null);
        jButton.setIcon(GUIRegistry.getInstance().getIconFactory().getIcon("Close"));
        jButton.setCursor(Cursor.getPredefinedCursor(12));
        jButton.setBorder(GUIUtils.ROLLOVER_BUTTON_BORDER);
        jButton.setRolloverEnabled(true);
        jButton.setOpaque(false);
        panelBuilder2.add((Component)jButton, cellConstraints.xy(4, 2));
        panelBuilder.add((Component)this.topLayoutPanel, cellConstraints.xywh(1, 1, 2, 1));
        this.leftLayoutPanel = new JPanel();
        this.leftLayoutPanel.setBackground(this.getBackground());
        this.leftLayoutPanel.setOpaque(false);
        formLayout = new FormLayout("4dlu, p, 0dlu", "23px, d, 0dlu, d, 23px");
        PanelBuilder panelBuilder3 = new PanelBuilder(formLayout, this.leftLayoutPanel);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.quickFilterBtn = new JToggleButton(Localizer.getString("SearchTab_QuickFilter"), GUIRegistry.getInstance().getIconFactory().getIcon("Filter"));
        this.quickFilterBtn.setBorder(new CompoundBorder(BorderFactory.createMatteBorder(2, 2, 1, 0, this.getBackground()), new EmptyBorder(5, 7, 5, 11)));
        buttonGroup.add(this.quickFilterBtn);
        this.updateLeftBtnProps(this.quickFilterBtn);
        panelBuilder3.add((Component)this.quickFilterBtn, cellConstraints.xy(2, 2));
        this.quickFilterBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SearchFilterPanel.this.activateQuickFilterPanel();
            }
        });
        this.filterListBtn = new JToggleButton(Localizer.getString("SearchTab_FilterRules"), IconFactory.EMPTY_IMAGE_16);
        this.filterListBtn.setBorder(new CompoundBorder(BorderFactory.createMatteBorder(1, 2, 2, 0, this.getBackground()), new EmptyBorder(5, 7, 5, 11)));
        buttonGroup.add(this.filterListBtn);
        this.updateLeftBtnProps(this.filterListBtn);
        panelBuilder3.add((Component)this.filterListBtn, cellConstraints.xy(2, 4));
        this.filterListBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SearchFilterPanel.this.activateFilterListPanel();
            }
        });
        panelBuilder.add((Component)this.leftLayoutPanel, cellConstraints.xywh(1, 2, 1, 1));
        this.quickFilterPanel = new QuickFilterPanel();
        this.filterListPanel = new FilterListPanel();
        this.filterContentPanel = new JPanel(new BorderLayout());
        this.filterContentPanel.setOpaque(false);
        panelBuilder.add((Component)this.filterContentPanel, cellConstraints.xywh(2, 2, 1, 1));
        this.quickFilterBtn.doClick();
    }

    public void setDisplayedSearch(SearchResultsDataModel searchResultsDataModel) {
        this.quickFilterPanel.setDisplayedSearch(searchResultsDataModel);
        this.filterListPanel.setDisplayedSearch(searchResultsDataModel);
    }

    public void activateQuickFilterPanel() {
        this.filterContentPanel.removeAll();
        this.filterContentPanel.add((Component)this.quickFilterPanel, "Center");
        this.filterContentPanel.doLayout();
        this.filterContentPanel.revalidate();
        this.filterContentPanel.repaint();
    }

    public void activateFilterListPanel() {
        this.filterContentPanel.removeAll();
        this.filterContentPanel.add((Component)this.filterListPanel, "Center");
        this.filterContentPanel.doLayout();
        this.filterContentPanel.revalidate();
        this.filterContentPanel.repaint();
    }

    private void updateLeftBtnProps(AbstractButton abstractButton) {
        abstractButton.setUI(new LeftButtonUI());
        abstractButton.setIconTextGap(8);
        abstractButton.setHorizontalAlignment(2);
        abstractButton.setCursor(Cursor.getPredefinedCursor(12));
        abstractButton.setRolloverEnabled(true);
        abstractButton.setOpaque(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        graphics.getClipBounds(this.clipBounds);
        if (this.isOpaque()) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(this.clipBounds.x, this.clipBounds.y, this.clipBounds.width, this.clipBounds.height);
        }
        Insets insets = this.getInsets();
        int n = this.getWidth() - insets.left - insets.right;
        int n2 = this.getHeight() - insets.top - insets.bottom;
        Graphics2D graphics2D = (Graphics2D)graphics.create(insets.left, insets.top, n, n2);
        try {
            this.insideBorderBounds.setBounds(0, 0, n, n2);
            this.paintInsideBorder(graphics2D);
        }
        finally {
            graphics2D.dispose();
        }
    }

    private void paintInsideBorder(Graphics2D graphics2D) {
        Rectangle rectangle = this.topLayoutPanel.getBounds();
        int n = rectangle.height;
        Rectangle rectangle2 = this.leftLayoutPanel.getBounds();
        int n2 = rectangle2.width;
        graphics2D.setColor(PhexColors.getBoxPanelBackground());
        graphics2D.fillRect(0, 0, this.insideBorderBounds.width, n * 2);
        graphics2D.fillRect(0, n * 2, n2, this.insideBorderBounds.height);
        graphics2D.setColor(this.getBackground());
        graphics2D.fillRoundRect(n2, n, this.insideBorderBounds.width, this.insideBorderBounds.height, 40, 40);
    }

    private static class LeftButtonUI
    extends BasicButtonUI {
        private Color rolloverColor = PhexColors.getBoxPanelBackground().darker();

        private LeftButtonUI() {
        }

        public void update(Graphics graphics, JComponent jComponent) {
            AbstractButton abstractButton;
            int n = jComponent.getWidth();
            int n2 = jComponent.getHeight();
            if (jComponent.isOpaque()) {
                graphics.setColor(PhexColors.getBoxPanelBackground());
                graphics.fillRect(0, 0, n, n2);
            }
            if ((abstractButton = (AbstractButton)jComponent).isSelected()) {
                graphics.setColor(jComponent.getParent().getBackground());
                graphics.fillRect(0, 0, n, n2);
            } else if (abstractButton.getModel().isRollover()) {
                graphics.setColor(this.rolloverColor);
                graphics.fillRect(0, 0, n, n2);
            }
            this.paint(graphics, jComponent);
        }
    }
}

