/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs.search.filterpanel;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.text.Keymap;
import phex.common.MediaType;
import phex.gui.common.FWSizeDefComboBox;
import phex.gui.common.GUIUtils;
import phex.gui.common.IntegerTextField;
import phex.gui.renderer.MediaTypeListRenderer;
import phex.gui.tabs.search.SearchResultsDataModel;
import phex.rules.Rule;
import phex.rules.condition.Condition;
import phex.rules.condition.FileSizeCondition;
import phex.rules.condition.FilenameCondition;
import phex.rules.condition.MediaTypeCondition;
import phex.rules.condition.NotCondition;
import phex.rules.condition.OrConcatCondition;
import phex.rules.consequence.FilterFromSearchConsequence;
import phex.utils.Localizer;

public class QuickFilterPanel
extends JPanel {
    private static final String QUICK_FILTER_RULE_NAME = "?<#}PhexQuickFilterRule";
    private SearchResultsDataModel currentResultsDataModel;
    private Rule currentQuickFilterRule;
    private JTextField withTermsTF;
    private JTextField withoutTermsTF;
    private JComboBox mediaTypeComboBox;
    private JTextField minFileSizeTF;
    private FWSizeDefComboBox minFileSizeUnitComboBox;
    private JTextField maxFileSizeTF;
    private FWSizeDefComboBox maxFileSizeUnitComboBox;
    private Timer activateQuickFilterTimer;

    public QuickFilterPanel() {
        this.initializeComponent();
        this.updateUI();
        this.activateQuickFilterTimer = new Timer(0, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                QuickFilterPanel.this.activateQuickFilter();
            }
        });
        this.activateQuickFilterTimer.setRepeats(false);
        this.activateQuickFilterTimer.setInitialDelay(500);
    }

    private void initializeComponent() {
        this.setOpaque(false);
        CellConstraints cellConstraints = new CellConstraints();
        FormLayout formLayout = new FormLayout("6dlu, right:d, 2dlu, d, 2dlu, d, 8dlu, right:d, 2dlu, d, 2dlu, d, 6dlu", "6dlu, p, 4dlu, p, 4dlu, p, 6dlu,");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout, this);
        formLayout.setColumnGroups(new int[][]{{2, 8}, {4, 10}, {6, 12}});
        JLabel jLabel = panelBuilder.addLabel(Localizer.getString("SearchTab_WithTerms"), cellConstraints.xywh(2, 2, 1, 1));
        jLabel.setToolTipText(Localizer.getString("SearchTab_TTTWithTerms"));
        QuickFilterActivationHandler quickFilterActivationHandler = new QuickFilterActivationHandler();
        this.withTermsTF = new JTextField(8);
        this.withTermsTF.addKeyListener(quickFilterActivationHandler);
        this.withTermsTF.setToolTipText(Localizer.getString("SearchTab_TTTWithTerms"));
        Keymap keymap = JTextField.addKeymap("SearchFilterTextEditor", this.withTermsTF.getKeymap());
        this.withTermsTF.setKeymap(keymap);
        GUIUtils.assignKeymapToTextField(keymap, this.withTermsTF);
        panelBuilder.add((Component)this.withTermsTF, cellConstraints.xywh(4, 2, 3, 1));
        jLabel = panelBuilder.addLabel(Localizer.getString("SearchTab_WithoutTerms"), cellConstraints.xywh(8, 2, 1, 1));
        jLabel.setToolTipText(Localizer.getString("SearchTab_TTTWithoutTerms"));
        this.withoutTermsTF = new JTextField(8);
        this.withoutTermsTF.addKeyListener(quickFilterActivationHandler);
        this.withoutTermsTF.setToolTipText(Localizer.getString("SearchTab_TTTWithoutTerms"));
        keymap = JTextField.addKeymap("SearchFilterTextEditor", this.withoutTermsTF.getKeymap());
        this.withoutTermsTF.setKeymap(keymap);
        GUIUtils.assignKeymapToTextField(keymap, this.withoutTermsTF);
        panelBuilder.add((Component)this.withoutTermsTF, cellConstraints.xywh(10, 2, 3, 1));
        jLabel = panelBuilder.addLabel(Localizer.getString("SearchTab_FileType"), cellConstraints.xywh(2, 4, 1, 1));
        jLabel.setToolTipText(Localizer.getString("SearchTab_TTTFileType"));
        this.mediaTypeComboBox = new JComboBox<MediaType>(MediaType.getAllMediaTypes());
        this.mediaTypeComboBox.addItemListener(quickFilterActivationHandler);
        this.mediaTypeComboBox.setRenderer(new MediaTypeListRenderer());
        panelBuilder.add((Component)this.mediaTypeComboBox, cellConstraints.xywh(4, 4, 3, 1));
        jLabel = panelBuilder.addLabel(Localizer.getString("SearchTab_MinFileSize"), cellConstraints.xywh(2, 6, 1, 1));
        jLabel.setToolTipText(Localizer.getString("SearchTab_TTTMinFileSize"));
        this.minFileSizeTF = new IntegerTextField(9);
        this.minFileSizeTF.addKeyListener(quickFilterActivationHandler);
        this.minFileSizeTF.setToolTipText(Localizer.getString("SearchTab_TTTMinFileSize"));
        keymap = JTextField.getKeymap("SearchFilterTextEditor");
        this.minFileSizeTF.setKeymap(keymap);
        GUIUtils.assignKeymapToTextField(keymap, this.minFileSizeTF);
        panelBuilder.add((Component)this.minFileSizeTF, cellConstraints.xywh(4, 6, 1, 1));
        this.minFileSizeUnitComboBox = new FWSizeDefComboBox();
        this.minFileSizeUnitComboBox.addItemListener(quickFilterActivationHandler);
        this.minFileSizeUnitComboBox.setToolTipText(Localizer.getString("SearchTab_TTTMinFileSize"));
        panelBuilder.add((Component)this.minFileSizeUnitComboBox, cellConstraints.xywh(6, 6, 1, 1));
        jLabel = panelBuilder.addLabel(Localizer.getString("SearchTab_MaxFileSize"), cellConstraints.xywh(8, 6, 1, 1));
        jLabel.setToolTipText(Localizer.getString("SearchTab_TTTMaxFileSize"));
        this.maxFileSizeTF = new IntegerTextField(9);
        this.maxFileSizeTF.addKeyListener(quickFilterActivationHandler);
        this.maxFileSizeTF.setToolTipText(Localizer.getString("SearchTab_TTTMaxFileSize"));
        keymap = JTextField.getKeymap("SearchFilterTextEditor");
        this.maxFileSizeTF.setKeymap(keymap);
        GUIUtils.assignKeymapToTextField(keymap, this.maxFileSizeTF);
        panelBuilder.add((Component)this.maxFileSizeTF, cellConstraints.xywh(10, 6, 1, 1));
        this.maxFileSizeUnitComboBox = new FWSizeDefComboBox();
        this.maxFileSizeUnitComboBox.addItemListener(quickFilterActivationHandler);
        this.maxFileSizeUnitComboBox.setToolTipText(Localizer.getString("SearchTab_TTTMaxFileSize"));
        panelBuilder.add((Component)this.maxFileSizeUnitComboBox, cellConstraints.xywh(12, 6, 1, 1));
    }

    private void activateQuickFilter() {
        StringTokenizer stringTokenizer;
        String string;
        Object object;
        if (this.currentResultsDataModel == null) {
            return;
        }
        if (this.currentQuickFilterRule == null) {
            this.currentQuickFilterRule = new Rule();
            this.currentQuickFilterRule.setName(QUICK_FILTER_RULE_NAME);
            this.currentQuickFilterRule.addConsequence(FilterFromSearchConsequence.INSTANCE);
        }
        this.currentQuickFilterRule.clearConditions();
        OrConcatCondition orConcatCondition = new OrConcatCondition();
        if (this.withTermsTF.getText().trim().length() > 0) {
            object = new FilenameCondition();
            string = this.withTermsTF.getText();
            stringTokenizer = new StringTokenizer(string, " ");
            while (stringTokenizer.hasMoreTokens()) {
                ((FilenameCondition)object).addTerm(stringTokenizer.nextToken());
            }
            orConcatCondition.addCondition(new NotCondition((Condition)object));
        }
        if (this.withoutTermsTF.getText().trim().length() > 0) {
            object = new FilenameCondition();
            string = this.withoutTermsTF.getText();
            stringTokenizer = new StringTokenizer(string, " ");
            while (stringTokenizer.hasMoreTokens()) {
                ((FilenameCondition)object).addTerm(stringTokenizer.nextToken());
            }
            orConcatCondition.addCondition((Condition)object);
        }
        object = (MediaType)this.mediaTypeComboBox.getSelectedItem();
        orConcatCondition.addCondition(new NotCondition(new MediaTypeCondition((MediaType)object)));
        string = this.minFileSizeTF.getText().trim();
        long l = -1L;
        try {
            if (string.length() > 0) {
                long l2 = Integer.parseInt(string);
                long l3 = this.minFileSizeUnitComboBox.getDefMultiplier();
                l = l3 * l2;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        String string2 = this.maxFileSizeTF.getText().trim();
        long l4 = -1L;
        try {
            if (string2.length() > 0) {
                long l5 = Integer.parseInt(string2);
                long l6 = this.maxFileSizeUnitComboBox.getDefMultiplier();
                l4 = l6 * l5;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (l >= 0L || l4 >= 0L) {
            FileSizeCondition fileSizeCondition = new FileSizeCondition(l, l4);
            orConcatCondition.addCondition(new NotCondition(fileSizeCondition));
        }
        if (orConcatCondition.getConditionCount() > 0) {
            this.currentQuickFilterRule.addCondition(orConcatCondition);
        }
        this.currentResultsDataModel.setQuickFilterRule(this.currentQuickFilterRule);
    }

    public void setDisplayedSearch(SearchResultsDataModel searchResultsDataModel) {
        this.currentResultsDataModel = null;
        this.currentQuickFilterRule = null;
        Rule rule = null;
        if (searchResultsDataModel != null) {
            rule = searchResultsDataModel.getQuickFilterRule();
        }
        this.withTermsTF.setText("");
        this.withoutTermsTF.setText("");
        this.mediaTypeComboBox.setSelectedIndex(0);
        this.minFileSizeTF.setText("");
        this.maxFileSizeTF.setText("");
        if (rule != null) {
            List list = rule.getConditions();
            Iterator iterator = list.iterator();
            if (iterator.hasNext()) {
                list = ((OrConcatCondition)iterator.next()).getConditions();
                iterator = list.iterator();
            }
            while (iterator.hasNext()) {
                Object object;
                Object object2;
                Object object3;
                Condition condition;
                Condition condition2 = (Condition)iterator.next();
                if (condition2 instanceof NotCondition) {
                    int n;
                    if ((condition2 = ((NotCondition)condition2).getContainedCondition()) instanceof FilenameCondition) {
                        condition = (FilenameCondition)condition2;
                        object3 = new StringBuffer();
                        object2 = ((FilenameCondition)condition).getTerms();
                        if (object2.size() > 0) {
                            object = object2.iterator();
                            while (object.hasNext()) {
                                String string = (String)object.next();
                                ((StringBuffer)object3).append(string);
                                if (!object.hasNext()) continue;
                                ((StringBuffer)object3).append(" ");
                            }
                        }
                        this.withTermsTF.setText(((StringBuffer)object3).toString());
                        continue;
                    }
                    if (condition2 instanceof MediaTypeCondition) {
                        condition = (MediaTypeCondition)condition2;
                        object3 = ((MediaTypeCondition)condition).getTypes();
                        object2 = object3.iterator();
                        if (!object2.hasNext()) continue;
                        object = (MediaType)object2.next();
                        this.mediaTypeComboBox.setSelectedItem(object);
                        continue;
                    }
                    if (!(condition2 instanceof FileSizeCondition) || !(object2 = (object3 = ((FileSizeCondition)(condition = (FileSizeCondition)condition2)).getRanges()).iterator()).hasNext()) continue;
                    object = (FileSizeCondition.Range)object2.next();
                    if (((FileSizeCondition.Range)object).min > 0L) {
                        this.minFileSizeUnitComboBox.setSelectedIndex(0);
                        for (n = FWSizeDefComboBox.SIZE_DEFINITIONS.length - 1; n >= 0; --n) {
                            FWSizeDefComboBox.SizeDefinition sizeDefinition = FWSizeDefComboBox.SIZE_DEFINITIONS[n];
                            long l = ((FileSizeCondition.Range)object).min % sizeDefinition.getMultiplier();
                            if (l != 0L) continue;
                            this.minFileSizeUnitComboBox.setSelectedIndex(n);
                            ((FileSizeCondition.Range)object).min /= sizeDefinition.getMultiplier();
                            break;
                        }
                        this.minFileSizeTF.setText(String.valueOf(((FileSizeCondition.Range)object).min));
                    }
                    if (((FileSizeCondition.Range)object).max <= 0L) continue;
                    this.maxFileSizeUnitComboBox.setSelectedIndex(0);
                    for (n = FWSizeDefComboBox.SIZE_DEFINITIONS.length - 1; n >= 0; --n) {
                        FWSizeDefComboBox.SizeDefinition sizeDefinition = FWSizeDefComboBox.SIZE_DEFINITIONS[n];
                        long l = ((FileSizeCondition.Range)object).max % sizeDefinition.getMultiplier();
                        if (l != 0L) continue;
                        this.maxFileSizeUnitComboBox.setSelectedIndex(n);
                        ((FileSizeCondition.Range)object).max /= sizeDefinition.getMultiplier();
                        break;
                    }
                    this.maxFileSizeTF.setText(String.valueOf(((FileSizeCondition.Range)object).max));
                    continue;
                }
                if (!(condition2 instanceof FilenameCondition)) continue;
                condition = (FilenameCondition)condition2;
                object3 = new StringBuffer();
                object2 = ((FilenameCondition)condition).getTerms();
                if (object2.size() > 0) {
                    object = object2.iterator();
                    while (object.hasNext()) {
                        String string = (String)object.next();
                        ((StringBuffer)object3).append(string);
                        if (!object.hasNext()) continue;
                        ((StringBuffer)object3).append(" ");
                    }
                }
                this.withoutTermsTF.setText(((StringBuffer)object3).toString());
            }
        }
        this.currentResultsDataModel = searchResultsDataModel;
        this.currentQuickFilterRule = rule;
    }

    private class QuickFilterActivationHandler
    extends KeyAdapter
    implements ItemListener {
        private QuickFilterActivationHandler() {
        }

        public void keyTyped(KeyEvent keyEvent) {
            QuickFilterPanel.this.activateQuickFilterTimer.restart();
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            QuickFilterPanel.this.activateQuickFilterTimer.restart();
        }
    }
}

