/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs.search.filterpanel;

import javax.swing.table.AbstractTableModel;
import phex.gui.tabs.search.SearchResultsDataModel;
import phex.gui.tabs.search.filterpanel.FilterListPanel;
import phex.query.QueryManager;
import phex.rules.Rule;
import phex.rules.SearchFilterRules;
import phex.utils.Localizer;

public class FilterListTableModel
extends AbstractTableModel {
    private FilterListPanel filterListPanel;
    private SearchFilterRules rules;
    private SearchResultsDataModel displayedDataModel;

    public FilterListTableModel(FilterListPanel filterListPanel) {
        this.filterListPanel = filterListPanel;
        this.rules = QueryManager.getInstance().getSearchFilterRules();
    }

    public void setDisplayedSearch(SearchResultsDataModel searchResultsDataModel) {
        if (this.displayedDataModel != searchResultsDataModel) {
            this.displayedDataModel = searchResultsDataModel;
            this.fireTableDataChanged();
        }
    }

    public int getColumnCount() {
        return 2;
    }

    public int getRowCount() {
        return this.rules.getCount();
    }

    public Object getValueAt(int n, int n2) {
        Rule rule = this.rules.getRuleAt(n);
        switch (n2) {
            case 0: {
                if (this.displayedDataModel == null) {
                    return Boolean.FALSE;
                }
                return this.displayedDataModel.isRuleActive(rule) ? Boolean.TRUE : Boolean.FALSE;
            }
            case 1: {
                return this.rules.getRuleAt(n);
            }
        }
        return "";
    }

    public String getColumnName(int n) {
        switch (n) {
            case 1: {
                return Localizer.getString("SearchTab_SelectRulesToActivate");
            }
        }
        return " ";
    }

    public Class getColumnClass(int n) {
        switch (n) {
            case 0: {
                return Boolean.class;
            }
            case 1: {
                return Rule.class;
            }
        }
        return Object.class;
    }

    public boolean isCellEditable(int n, int n2) {
        return n2 == 0 && this.displayedDataModel != null;
    }

    public void setValueAt(Object object, int n, int n2) {
        Boolean bl = (Boolean)object;
        Rule rule = this.rules.getRuleAt(n);
        if (bl.booleanValue()) {
            this.displayedDataModel.activateRule(rule);
        } else {
            this.displayedDataModel.deactivateRule(rule);
        }
    }
}

