/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs.search.cp;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.Timer;
import phex.gui.common.BoxPanel;
import phex.gui.tabs.search.SearchResultsDataModel;
import phex.gui.tabs.search.SearchVisualizer;
import phex.gui.tabs.search.cp.SearchControlPanel;
import phex.query.Search;
import phex.utils.Localizer;
import phex.utils.NLogger;

public class SearchInfoBox
extends BoxPanel {
    private Timer updateDisplayTimer;
    private SearchControlPanel controlPanel;
    private SearchResultsDataModel displayedDataModel;
    private JLabel searchStatusLbl;
    private JProgressBar progressBar;
    private JLabel totalResultsLbl;
    private JLabel displayedResultsLbl;
    private JLabel filteredResultsLbl;
    static /* synthetic */ Class class$phex$gui$tabs$search$cp$SearchInfoBox;

    public SearchInfoBox(SearchControlPanel searchControlPanel) {
        super(Localizer.getString("SearchTab_Information"));
        this.controlPanel = searchControlPanel;
        CellConstraints cellConstraints = new CellConstraints();
        FormLayout formLayout = new FormLayout("6dlu, d, 2dlu, fill:p:grow, 6dlu", "4dlu, p, 2dlu, p, 2dlu, p, 2dlu, p, 2dlu,p, 2dlu, p, 2dlu, p, 2dlu, p, 6dlu");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout, this.getContentPanel());
        JLabel jLabel = panelBuilder.addLabel(Localizer.getString("SearchTab_Status"), cellConstraints.xy(2, 2));
        jLabel.setToolTipText(Localizer.getString("SearchTab_TTTStatus"));
        this.searchStatusLbl = new JLabel();
        panelBuilder.add((Component)this.searchStatusLbl, cellConstraints.xy(4, 2));
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setToolTipText(Localizer.getString("SearchTab_TTTProgress"));
        this.progressBar.setStringPainted(true);
        panelBuilder.add((Component)this.progressBar, cellConstraints.xywh(2, 4, 3, 1));
        jLabel = panelBuilder.addLabel(Localizer.getString("SearchTab_TotalResults"), cellConstraints.xy(2, 6));
        jLabel.setToolTipText(Localizer.getString("SearchTab_TTTTotalResults"));
        this.totalResultsLbl = new JLabel();
        panelBuilder.add((Component)this.totalResultsLbl, cellConstraints.xy(4, 6));
        jLabel = panelBuilder.addLabel(Localizer.getString("SearchTab_DisplayedResults"), cellConstraints.xy(2, 8));
        jLabel.setToolTipText(Localizer.getString("SearchTab_TTTDisplayedResults"));
        this.displayedResultsLbl = new JLabel();
        panelBuilder.add((Component)this.displayedResultsLbl, cellConstraints.xy(4, 8));
        jLabel = panelBuilder.addLabel(Localizer.getString("SearchTab_FilteredResults"), cellConstraints.xy(2, 10));
        jLabel.setToolTipText(Localizer.getString("SearchTab_TTTFilteredResults"));
        this.filteredResultsLbl = new JLabel();
        panelBuilder.add((Component)this.filteredResultsLbl, cellConstraints.xy(4, 10));
        this.updateDisplayTimer = new Timer(2000, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    SearchInfoBox.this.updateDisplay();
                }
                catch (Throwable throwable) {
                    NLogger.error(class$phex$gui$tabs$search$cp$SearchInfoBox == null ? (class$phex$gui$tabs$search$cp$SearchInfoBox = SearchInfoBox.class$("phex.gui.tabs.search.cp.SearchInfoBox")) : class$phex$gui$tabs$search$cp$SearchInfoBox, (Object)throwable, throwable);
                }
            }
        });
    }

    public void setDisplayedSearch(SearchResultsDataModel searchResultsDataModel) {
        this.displayedDataModel = searchResultsDataModel;
        if (this.displayedDataModel != null && !this.updateDisplayTimer.isRunning()) {
            this.updateDisplayTimer.start();
        } else if (this.updateDisplayTimer.isRunning()) {
            this.updateDisplayTimer.stop();
        }
        this.updateDisplay();
    }

    private void updateDisplay() {
        if (this.displayedDataModel != null) {
            Search search = this.displayedDataModel.getSearch();
            this.searchStatusLbl.setText(SearchVisualizer.visualizeSearchStatus(search));
            int n = this.displayedDataModel.getAllSearchResultCount();
            int n2 = this.displayedDataModel.getFilteredElementCount();
            this.progressBar.setValue(search.getProgress());
            this.totalResultsLbl.setText(String.valueOf(n));
            this.displayedResultsLbl.setText(String.valueOf(n - n2));
            this.filteredResultsLbl.setText(String.valueOf(n2));
        } else {
            this.searchStatusLbl.setText("");
            this.progressBar.setValue(0);
            this.totalResultsLbl.setText("");
            this.displayedResultsLbl.setText("");
            this.filteredResultsLbl.setText("");
        }
    }
}

