/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs.search.cp;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.text.Keymap;
import phex.common.Cfg;
import phex.common.ServiceManager;
import phex.gui.common.BoxPanel;
import phex.gui.common.GUIRegistry;
import phex.gui.common.GUIUtils;
import phex.gui.tabs.search.cp.SearchControlPanel;
import phex.query.KeywordSearch;
import phex.utils.Localizer;
import phex.utils.NLogger;

public class KeywordSearchBox
extends BoxPanel {
    private SearchControlPanel controlPanel;
    private DefaultComboBoxModel searchComboModel;
    private JComboBox searchTermComboBox;
    private JButton searchButton;
    private JButton stopButton;

    public KeywordSearchBox(SearchControlPanel searchControlPanel) {
        super(Localizer.getString("SearchTab_KeywordSearch"));
        this.controlPanel = searchControlPanel;
        CellConstraints cellConstraints = new CellConstraints();
        FormLayout formLayout = new FormLayout("6dlu, p, 6dlu", "4dlu, p, 2dlu, p, 6dlu, p, 4dlu");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout, this.getContentPanel());
        panelBuilder.addLabel(Localizer.getString("SearchTab_TypeYourSearch"), cellConstraints.xy(2, 2));
        SubmitSearchHandler submitSearchHandler = new SubmitSearchHandler();
        this.searchComboModel = new DefaultComboBoxModel<Object>(ServiceManager.sCfg.searchTermHistory.toArray());
        this.searchTermComboBox = new JComboBox(this.searchComboModel);
        this.searchTermComboBox.setEditable(true);
        JTextField jTextField = (JTextField)this.searchTermComboBox.getEditor().getEditorComponent();
        Keymap keymap = JTextField.addKeymap("SearchTermEditor", jTextField.getKeymap());
        jTextField.setKeymap(keymap);
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(10, 0), submitSearchHandler);
        GUIUtils.assignKeymapToComboBoxEditor(keymap, this.searchTermComboBox);
        this.searchTermComboBox.setSelectedItem("");
        panelBuilder.add((Component)this.searchTermComboBox, cellConstraints.xy(2, 4));
        this.searchButton = new JButton(Localizer.getString("SearchTab_StartSearch"), GUIRegistry.getInstance().getIconFactory().getIcon("Search"));
        this.searchButton.setCursor(Cursor.getPredefinedCursor(12));
        this.searchButton.setToolTipText(Localizer.getString("SearchTab_TTTStartSearch"));
        this.searchButton.setMargin(GUIUtils.NARROW_BUTTON_INSETS);
        this.searchButton.addActionListener(submitSearchHandler);
        StopSearchHandler stopSearchHandler = new StopSearchHandler();
        this.stopButton = new JButton(Localizer.getString("SearchTab_StopSearch"), GUIRegistry.getInstance().getIconFactory().getIcon("Stop"));
        this.stopButton.setCursor(Cursor.getPredefinedCursor(12));
        this.stopButton.setToolTipText(Localizer.getString("SearchTab_TTTStopSearch"));
        this.stopButton.setMargin(GUIUtils.NARROW_BUTTON_INSETS);
        this.stopButton.addActionListener(stopSearchHandler);
        ButtonBarBuilder buttonBarBuilder = new ButtonBarBuilder();
        buttonBarBuilder.setLeftToRightButtonOrder(true);
        buttonBarBuilder.addFixedNarrow(this.searchButton);
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixedNarrow(this.stopButton);
        buttonBarBuilder.addGlue();
        JPanel jPanel = buttonBarBuilder.getPanel();
        jPanel.setOpaque(false);
        panelBuilder.add((Component)jPanel, cellConstraints.xy(2, 6));
        this.adjustComponents();
    }

    private void adjustComponents() {
        Serializable serializable;
        Object object;
        if (this.searchTermComboBox != null) {
            GUIUtils.adjustComboBoxHeight(this.searchTermComboBox);
            object = this.searchTermComboBox.getRenderer();
            if (object != null) {
                serializable = this.searchTermComboBox.getFontMetrics(this.searchTermComboBox.getFont());
                int n = ((FontMetrics)serializable).getMaxAdvance() * 10;
                int n2 = ((FontMetrics)serializable).getMaxAdvance() * 8;
                Dimension dimension = this.searchTermComboBox.getMaximumSize();
                dimension.width = Math.max(n2, Math.min(n, dimension.width));
                this.searchTermComboBox.setMaximumSize(dimension);
                Dimension dimension2 = this.searchTermComboBox.getPreferredSize();
                dimension2.width = Math.max(n2, Math.min(n, dimension2.width));
                this.searchTermComboBox.setPreferredSize(dimension2);
            }
        }
        if (this.searchButton != null) {
            object = this.searchButton.getText();
            this.searchButton.setText(Localizer.getString("SearchTab_StartSearch"));
            serializable = this.searchButton.getPreferredSize();
            this.searchButton.setText(Localizer.getString("SearchTab_Searching"));
            Dimension dimension = this.searchButton.getPreferredSize();
            ((Dimension)serializable).width = Math.max(((Dimension)serializable).width, dimension.width);
            this.searchButton.setPreferredSize((Dimension)serializable);
            this.searchButton.setText((String)object);
        }
    }

    public void clearSearchHistory() {
        this.searchComboModel.removeAllElements();
        ServiceManager.sCfg.searchTermHistory.clear();
        ServiceManager.sCfg.save();
    }

    public void focusInputField() {
        this.searchTermComboBox.requestFocus();
    }

    public void updateUI() {
        super.updateUI();
        this.adjustComponents();
    }

    public void updateControlPanel(KeywordSearch keywordSearch) {
        if (keywordSearch != null) {
            String string = keywordSearch.getSearchString();
            this.searchTermComboBox.setSelectedItem(string);
            ((JTextField)this.searchTermComboBox.getEditor().getEditorComponent()).setText(string);
            if (keywordSearch.isSearching()) {
                this.searchButton.setText(Localizer.getString("SearchTab_Searching"));
                this.searchButton.setToolTipText(Localizer.getString("SearchTab_TTTSearching"));
                this.searchButton.setEnabled(false);
                this.searchTermComboBox.setEnabled(false);
            } else {
                this.searchButton.setText(Localizer.getString("SearchTab_StartSearch"));
                this.searchButton.setToolTipText(Localizer.getString("SearchTab_TTTStartSearch"));
                this.searchButton.setEnabled(true);
                this.searchTermComboBox.setEnabled(true);
            }
        } else {
            this.searchTermComboBox.setSelectedItem(null);
            ((JTextField)this.searchTermComboBox.getEditor().getEditorComponent()).setText("");
            this.searchButton.setText(Localizer.getString("SearchTab_StartSearch"));
            this.searchButton.setToolTipText(Localizer.getString("SearchTab_TTTStartSearch"));
            this.searchButton.setEnabled(true);
            this.searchTermComboBox.setEnabled(true);
        }
    }

    private class StopSearchHandler
    extends AbstractAction
    implements ActionListener {
        private StopSearchHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            KeywordSearchBox.this.controlPanel.stopSearching();
        }
    }

    private class SubmitSearchHandler
    extends AbstractAction
    implements ActionListener {
        private SubmitSearchHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = (String)KeywordSearchBox.this.searchTermComboBox.getEditor().getItem();
            KeywordSearchBox.this.searchComboModel.setSelectedItem(string);
            string = string.trim();
            if (string.length() == 0) {
                return;
            }
            if (string.length() < Cfg.MIN_SEARCH_TERM_LENGTH) {
                Object[] objectArray = new Object[]{new Integer(Cfg.MIN_SEARCH_TERM_LENGTH)};
                GUIUtils.showErrorMessage(Localizer.getFormatedString("MinSearchTerm", objectArray));
                KeywordSearchBox.this.searchTermComboBox.getEditor().selectAll();
                try {
                    ((JComponent)KeywordSearchBox.this.searchTermComboBox.getEditor().getEditorComponent()).requestFocus();
                }
                catch (Exception exception) {
                    NLogger.error("USER_INTERFACE", (Object)KeywordSearchBox.this.searchTermComboBox.getEditor().toString(), (Throwable)exception);
                }
                return;
            }
            boolean bl = KeywordSearchBox.this.controlPanel.startKeywordSearch(string);
            if (!bl) {
                return;
            }
            int n = KeywordSearchBox.this.searchComboModel.getIndexOf(string);
            if (n < 0) {
                KeywordSearchBox.this.searchComboModel.insertElementAt(string, 0);
                if (KeywordSearchBox.this.searchComboModel.getSize() > ServiceManager.sCfg.maxConnectToHistorySize) {
                    KeywordSearchBox.this.searchComboModel.removeElementAt(KeywordSearchBox.this.searchComboModel.getSize() - 1);
                }
                this.saveSearchList();
            } else if (n > 0) {
                KeywordSearchBox.this.searchComboModel.removeElementAt(n);
                KeywordSearchBox.this.searchComboModel.insertElementAt(string, 0);
                this.saveSearchList();
            }
        }

        private void saveSearchList() {
            int n = KeywordSearchBox.this.searchComboModel.getSize();
            ArrayList arrayList = new ArrayList(n);
            for (int i = 0; i < n; ++i) {
                arrayList.add(KeywordSearchBox.this.searchComboModel.getElementAt(i));
            }
            ServiceManager.sCfg.searchTermHistory.clear();
            ServiceManager.sCfg.searchTermHistory.addAll(arrayList);
            ServiceManager.sCfg.save();
        }
    }
}

