/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs.search.cp;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.text.Keymap;
import phex.common.ServiceManager;
import phex.common.address.DestAddress;
import phex.gui.common.BoxPanel;
import phex.gui.common.GUIRegistry;
import phex.gui.common.GUIUtils;
import phex.gui.tabs.search.cp.SearchControlPanel;
import phex.query.BrowseHostResults;
import phex.utils.Localizer;

public class BrowseHostSearchBox
extends BoxPanel {
    private SearchControlPanel controlPanel;
    private DefaultComboBoxModel hostNameComboModel;
    private JComboBox hostNameComboBox;
    private JButton browseButton;
    private JButton stopButton;

    public BrowseHostSearchBox(SearchControlPanel searchControlPanel) {
        super(Localizer.getString("SearchTab_BrowseHost"));
        this.controlPanel = searchControlPanel;
        CellConstraints cellConstraints = new CellConstraints();
        FormLayout formLayout = new FormLayout("6dlu, p, 6dlu", "4dlu, p, 2dlu, p, 6dlu, p, 4dlu");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout, this.getContentPanel());
        panelBuilder.addLabel(Localizer.getString("SearchTab_TypeHostAddress"), cellConstraints.xy(2, 2));
        SubmitSearchHandler submitSearchHandler = new SubmitSearchHandler();
        this.hostNameComboModel = new DefaultComboBoxModel<Object>(ServiceManager.sCfg.browseHostHistory.toArray());
        this.hostNameComboBox = new JComboBox(this.hostNameComboModel);
        this.hostNameComboBox.setEditable(true);
        JTextField jTextField = (JTextField)this.hostNameComboBox.getEditor().getEditorComponent();
        Keymap keymap = JTextField.addKeymap("SearchTermEditor", jTextField.getKeymap());
        jTextField.setKeymap(keymap);
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(10, 0), submitSearchHandler);
        GUIUtils.assignKeymapToComboBoxEditor(keymap, this.hostNameComboBox);
        this.hostNameComboBox.setSelectedItem("");
        panelBuilder.add((Component)this.hostNameComboBox, cellConstraints.xy(2, 4));
        this.browseButton = new JButton(Localizer.getString("SearchTab_StartBrowseHost"), GUIRegistry.getInstance().getIconFactory().getIcon("Search"));
        this.browseButton.setCursor(Cursor.getPredefinedCursor(12));
        this.browseButton.setToolTipText(Localizer.getString("SearchTab_TTTStartBrowseHost"));
        this.browseButton.setMargin(GUIUtils.NARROW_BUTTON_INSETS);
        this.browseButton.addActionListener(submitSearchHandler);
        StopSearchHandler stopSearchHandler = new StopSearchHandler();
        this.stopButton = new JButton(Localizer.getString("SearchTab_StopSearch"), GUIRegistry.getInstance().getIconFactory().getIcon("Stop"));
        this.stopButton.setCursor(Cursor.getPredefinedCursor(12));
        this.stopButton.setToolTipText(Localizer.getString("SearchTab_TTTStopSearch"));
        this.stopButton.setMargin(GUIUtils.NARROW_BUTTON_INSETS);
        this.stopButton.addActionListener(stopSearchHandler);
        ButtonBarBuilder buttonBarBuilder = new ButtonBarBuilder();
        buttonBarBuilder.setLeftToRightButtonOrder(true);
        buttonBarBuilder.addFixedNarrow(this.browseButton);
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixedNarrow(this.stopButton);
        buttonBarBuilder.addGlue();
        JPanel jPanel = buttonBarBuilder.getPanel();
        jPanel.setOpaque(false);
        panelBuilder.add((Component)jPanel, cellConstraints.xy(2, 6));
        this.adjustComponents();
    }

    private void adjustComponents() {
        Serializable serializable;
        Object object;
        if (this.hostNameComboBox != null) {
            GUIUtils.adjustComboBoxHeight(this.hostNameComboBox);
            object = this.hostNameComboBox.getRenderer();
            if (object != null) {
                serializable = this.hostNameComboBox.getFontMetrics(this.hostNameComboBox.getFont());
                int n = ((FontMetrics)serializable).getMaxAdvance() * 10;
                int n2 = ((FontMetrics)serializable).getMaxAdvance() * 8;
                Dimension dimension = this.hostNameComboBox.getMaximumSize();
                dimension.width = Math.max(n2, Math.min(n, dimension.width));
                this.hostNameComboBox.setMaximumSize(dimension);
                dimension = this.hostNameComboBox.getPreferredSize();
                dimension.width = Math.max(n2, Math.min(n, dimension.width));
                this.hostNameComboBox.setPreferredSize(dimension);
            }
        }
        if (this.browseButton != null) {
            object = this.browseButton.getText();
            this.browseButton.setText(Localizer.getString("SearchTab_BrowseHost"));
            serializable = this.browseButton.getPreferredSize();
            this.browseButton.setText(Localizer.getString("SearchTab_Searching"));
            Dimension dimension = this.browseButton.getPreferredSize();
            ((Dimension)serializable).width = Math.max(((Dimension)serializable).width, dimension.width);
            this.browseButton.setPreferredSize((Dimension)serializable);
            this.browseButton.setText((String)object);
        }
    }

    public void clearBrowseHostHistory() {
        this.hostNameComboModel.removeAllElements();
        ServiceManager.sCfg.browseHostHistory.clear();
        ServiceManager.sCfg.save();
    }

    public void focusInputField() {
        this.hostNameComboBox.requestFocus();
    }

    public void updateUI() {
        super.updateUI();
        this.adjustComponents();
    }

    public void updateControlPanel(BrowseHostResults browseHostResults) {
        if (browseHostResults != null) {
            DestAddress destAddress = browseHostResults.getDestAddress();
            this.hostNameComboBox.setSelectedItem(destAddress.getFullHostName());
            ((JTextField)this.hostNameComboBox.getEditor().getEditorComponent()).setText(destAddress.getFullHostName());
            if (browseHostResults.isSearching()) {
                this.browseButton.setText(Localizer.getString("SearchTab_Searching"));
                this.browseButton.setToolTipText(Localizer.getString("SearchTab_TTTSearching"));
                this.browseButton.setEnabled(false);
                this.hostNameComboBox.setEnabled(false);
            } else {
                this.browseButton.setText(Localizer.getString("SearchTab_BrowseHost"));
                this.browseButton.setToolTipText(Localizer.getString("SearchTab_TTTBrowseHost"));
                this.browseButton.setEnabled(true);
                this.hostNameComboBox.setEnabled(true);
            }
        } else {
            this.hostNameComboBox.setSelectedItem(null);
            ((JTextField)this.hostNameComboBox.getEditor().getEditorComponent()).setText("");
            this.browseButton.setText(Localizer.getString("SearchTab_BrowseHost"));
            this.browseButton.setToolTipText(Localizer.getString("SearchTab_TTTBrowseHost"));
            this.browseButton.setEnabled(true);
            this.hostNameComboBox.setEnabled(true);
        }
    }

    private class StopSearchHandler
    extends AbstractAction
    implements ActionListener {
        private StopSearchHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            BrowseHostSearchBox.this.controlPanel.stopSearching();
        }
    }

    private class SubmitSearchHandler
    extends AbstractAction
    implements ActionListener {
        private SubmitSearchHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = (String)BrowseHostSearchBox.this.hostNameComboBox.getEditor().getItem();
            BrowseHostSearchBox.this.hostNameComboModel.setSelectedItem(string);
            string = string.trim();
            if (string.length() == 0) {
                return;
            }
            boolean bl = BrowseHostSearchBox.this.controlPanel.startBrowseHost(string);
            if (!bl) {
                return;
            }
            int n = BrowseHostSearchBox.this.hostNameComboModel.getIndexOf(string);
            if (n < 0) {
                BrowseHostSearchBox.this.hostNameComboModel.insertElementAt(string, 0);
                if (BrowseHostSearchBox.this.hostNameComboModel.getSize() > ServiceManager.sCfg.maxConnectToHistorySize) {
                    BrowseHostSearchBox.this.hostNameComboModel.removeElementAt(BrowseHostSearchBox.this.hostNameComboModel.getSize() - 1);
                }
                this.saveSearchList();
            } else if (n > 0) {
                BrowseHostSearchBox.this.hostNameComboModel.removeElementAt(n);
                BrowseHostSearchBox.this.hostNameComboModel.insertElementAt(string, 0);
                this.saveSearchList();
            }
        }

        private void saveSearchList() {
            int n = BrowseHostSearchBox.this.hostNameComboModel.getSize();
            ArrayList arrayList = new ArrayList(n);
            for (int i = 0; i < n; ++i) {
                arrayList.add(BrowseHostSearchBox.this.hostNameComboModel.getElementAt(i));
            }
            ServiceManager.sCfg.browseHostHistory.clear();
            ServiceManager.sCfg.browseHostHistory.addAll(arrayList);
            ServiceManager.sCfg.save();
        }
    }
}

