/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs.search;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import phex.gui.actions.FWAction;
import phex.gui.actions.FWToggleAction;
import phex.gui.common.FWElegantPanel;
import phex.gui.common.GUIRegistry;
import phex.gui.common.GUIUtils;
import phex.gui.tabs.FWTab;
import phex.gui.tabs.search.SearchButtonBar;
import phex.gui.tabs.search.SearchListPanel;
import phex.gui.tabs.search.SearchResultsDataModel;
import phex.gui.tabs.search.SearchResultsPanel;
import phex.gui.tabs.search.cp.SearchControlPanel;
import phex.gui.tabs.search.filterpanel.SearchFilterPanel;
import phex.query.QueryManager;
import phex.query.SearchContainer;
import phex.utils.Localizer;
import phex.xml.sax.gui.DGuiSettings;

public class SearchTab
extends FWTab {
    private List viewMenuActionList;
    private SearchResultsDataModel displayedDataModel;
    private SearchButtonBar searchButtonBar;
    private JPanel buttonBarContainer;
    private JPanel contentPanel;
    private PanelBuilder contentBuilder;
    private JPanel mainSearchPanel;
    private JSplitPane searchListSplitPane;
    private SearchListPanel searchListPanel;
    private JPanel lowerRightPanel;
    private PanelBuilder lowerRightBuilder;
    private SearchFilterPanel searchFilterPanel;
    private SearchControlPanel searchControlPanel;
    private SearchResultsPanel searchResultPanel;
    public static final String FILTER_PANEL_TOGGLE_ACTION = "FilterPanelToggleAction";
    public static final String CLEAR_SEARCH_RESULTS_ACTION = "ClearSearchResultsAction";
    public static final String CREATE_NEW_SEARCH_ACTION = "CreateNewSearchAction";
    public static final String CLOSE_SEARCH_ACTION = "CloseSearchAction";
    public static final String ADVANCED_FILTER_ACTION = "AdvancedFilterAction";

    public SearchTab() {
        super(1101, Localizer.getString("Search"), GUIRegistry.getInstance().getIconFactory().getIcon("Search"), Localizer.getString("TTTSearchTab"), Localizer.getChar("SearchMnemonic"), KeyStroke.getKeyStroke(Localizer.getString("SearchAccelerator")), 1);
    }

    public void initComponent(DGuiSettings dGuiSettings) {
        boolean bl = true;
        if (dGuiSettings != null && dGuiSettings.isSetSearchBarVisible()) {
            bl = dGuiSettings.isSearchBarVisible();
        }
        boolean bl2 = true;
        if (dGuiSettings != null && dGuiSettings.isSetSearchListVisible()) {
            bl2 = dGuiSettings.isSearchListVisible();
        }
        boolean bl3 = true;
        if (dGuiSettings != null && dGuiSettings.isSetSearchFilterPanelVisible()) {
            bl3 = dGuiSettings.isSearchFilterPanelVisible();
        }
        ToggleSearchFilterAction toggleSearchFilterAction = new ToggleSearchFilterAction(bl3);
        this.addTabAction(FILTER_PANEL_TOGGLE_ACTION, toggleSearchFilterAction);
        this.addTabAction(CLEAR_SEARCH_RESULTS_ACTION, new ClearSearchResultsAction());
        this.addTabAction(CREATE_NEW_SEARCH_ACTION, new CreateNewSearchAction());
        this.addTabAction(CLOSE_SEARCH_ACTION, new CloseSearchAction());
        CellConstraints cellConstraints = new CellConstraints();
        FormLayout formLayout = new FormLayout("2dlu, fill:d:grow, 2dlu", "0dlu, p, 2dlu, fill:p:grow, 2dlu");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout, this);
        this.buttonBarContainer = new JPanel(new BorderLayout());
        panelBuilder.add((Component)this.buttonBarContainer, cellConstraints.xy(2, 2));
        this.contentPanel = new JPanel();
        FWElegantPanel fWElegantPanel = new FWElegantPanel(Localizer.getString("Search"), this.contentPanel);
        panelBuilder.add((Component)fWElegantPanel, cellConstraints.xy(2, 4));
        JPanel jPanel = new JPanel(new FlowLayout());
        jPanel.setOpaque(false);
        JButton jButton = new JButton(toggleSearchFilterAction);
        jButton.setText(null);
        jButton.setCursor(Cursor.getPredefinedCursor(12));
        jButton.setBorder(GUIUtils.ROLLOVER_BUTTON_BORDER);
        jButton.setRolloverEnabled(true);
        jButton.setOpaque(false);
        jPanel.add(jButton);
        fWElegantPanel.addHeaderPanelComponent(jPanel, "East");
        FormLayout formLayout2 = new FormLayout("fill:d:grow", "fill:d:grow");
        this.contentBuilder = new PanelBuilder(formLayout2, this.contentPanel);
        this.searchListPanel = new SearchListPanel(this);
        this.searchListPanel.initializeComponent(dGuiSettings);
        this.mainSearchPanel = new JPanel();
        FormLayout formLayout3 = new FormLayout("p, 1dlu, fill:d:grow", "fill:d:grow");
        PanelBuilder panelBuilder2 = new PanelBuilder(formLayout3, this.mainSearchPanel);
        this.searchControlPanel = new SearchControlPanel(this);
        this.searchControlPanel.setMinimumSize(new Dimension(0, 0));
        panelBuilder2.add((Component)this.searchControlPanel, cellConstraints.xy(1, 1));
        this.lowerRightPanel = new JPanel();
        FormLayout formLayout4 = new FormLayout("fill:d:grow", "p, fill:d:grow");
        this.lowerRightBuilder = new PanelBuilder(formLayout4, this.lowerRightPanel);
        this.searchFilterPanel = new SearchFilterPanel(this);
        this.lowerRightBuilder.add((Component)this.searchFilterPanel, cellConstraints.xy(1, 1));
        this.searchResultPanel = new SearchResultsPanel(this);
        this.searchResultPanel.initializeComponent(dGuiSettings);
        this.lowerRightBuilder.add((Component)this.searchResultPanel, cellConstraints.xy(1, 2));
        panelBuilder2.add((Component)this.lowerRightPanel, cellConstraints.xy(3, 1));
        Dimension dimension = new Dimension(400, 200);
        this.mainSearchPanel.setPreferredSize(dimension);
        this.mainSearchPanel.setMinimumSize(new Dimension(0, 0));
        this.searchListPanel.setMinimumSize(new Dimension(0, 0));
        this.searchListSplitPane = new JSplitPane(0, this.searchListPanel, this.mainSearchPanel);
        this.searchListSplitPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.searchListSplitPane.setDividerSize(4);
        this.searchListSplitPane.setOneTouchExpandable(false);
        this.setSearchButtonBarVisible(bl);
        this.setSearchListVisible(bl2);
        this.setFilterPanelVisible(bl3);
        ArrayList<FWToggleAction> arrayList = new ArrayList<FWToggleAction>();
        arrayList.add(new ToggleSearchBarAction(bl));
        arrayList.add(new ToggleSearchListAction(bl2));
        arrayList.add(toggleSearchFilterAction);
        this.viewMenuActionList = Collections.unmodifiableList(arrayList);
    }

    public void setFilterPanelVisible(boolean bl) {
        CellConstraints cellConstraints = new CellConstraints();
        if (bl) {
            this.lowerRightPanel.removeAll();
            this.lowerRightBuilder.add((Component)this.searchFilterPanel, cellConstraints.xy(1, 1));
            this.lowerRightBuilder.add((Component)this.searchResultPanel, cellConstraints.xy(1, 2));
        } else {
            this.lowerRightPanel.removeAll();
            this.lowerRightBuilder.add((Component)this.searchResultPanel, cellConstraints.xy(1, 2));
        }
        this.validate();
    }

    public void setSearchButtonBarVisible(boolean bl) {
        if (bl) {
            this.buttonBarContainer.removeAll();
            this.searchButtonBar = new SearchButtonBar(this);
            this.buttonBarContainer.add((Component)this.searchButtonBar, "Center");
            this.validate();
        } else {
            this.buttonBarContainer.removeAll();
            this.validate();
            this.searchButtonBar = null;
        }
    }

    public void setSearchListVisible(boolean bl) {
        CellConstraints cellConstraints = new CellConstraints();
        if (bl) {
            this.contentPanel.removeAll();
            this.searchListSplitPane.setLeftComponent(this.searchListPanel);
            this.searchListSplitPane.setRightComponent(this.mainSearchPanel);
            this.contentBuilder.add((Component)this.searchListSplitPane, cellConstraints.xy(1, 1));
            this.validate();
        } else {
            this.contentPanel.removeAll();
            this.contentBuilder.add((Component)this.mainSearchPanel, cellConstraints.xy(1, 1));
            this.validate();
        }
    }

    public void setDisplayedSearch(SearchResultsDataModel searchResultsDataModel) {
        if (this.displayedDataModel == searchResultsDataModel) {
            return;
        }
        this.displayedDataModel = searchResultsDataModel;
        if (this.searchButtonBar != null) {
            this.searchButtonBar.setDisplayedSearch(this.displayedDataModel);
        }
        this.searchResultPanel.setDisplayedSearch(this.displayedDataModel);
        this.searchListPanel.setDisplayedSearch(this.displayedDataModel);
        this.searchFilterPanel.setDisplayedSearch(this.displayedDataModel);
        this.searchControlPanel.setDisplayedSearch(this.displayedDataModel);
        this.refreshTabActions();
    }

    public void clearSearchHistory() {
        this.searchControlPanel.clearSearchHistory();
    }

    public void appendDGuiSettings(DGuiSettings dGuiSettings) {
        super.appendDGuiSettings(dGuiSettings);
        dGuiSettings.setSearchBarVisible(this.searchButtonBar != null);
        dGuiSettings.setSearchFilterPanelVisible(this.searchFilterPanel.getParent() != null);
        dGuiSettings.setSearchListVisible(this.searchListSplitPane.getParent() != null);
        this.searchListPanel.appendDGuiSettings(dGuiSettings);
        this.searchResultPanel.appendDGuiSettings(dGuiSettings);
    }

    public List getViewMenuActions() {
        return this.viewMenuActionList;
    }

    public class ToggleSearchFilterAction
    extends FWToggleAction {
        public ToggleSearchFilterAction(boolean bl) {
            super(Localizer.getString("SearchTab_ToggleSearchFilterAction"), GUIRegistry.getInstance().getIconFactory().getIcon("Filter"), null, null, null, null);
            this.setSelected(bl);
            this.updateTooltip();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = !this.isSelected();
            this.setSelected(bl);
            SearchTab.this.setFilterPanelVisible(bl);
            this.updateTooltip();
        }

        private void updateTooltip() {
            if (this.isSelected()) {
                this.setToolTipText(Localizer.getString("SearchTab_TTTToggleSearchFilterActionHide"));
            } else {
                this.setToolTipText(Localizer.getString("SearchTab_TTTToggleSearchFilterActionShow"));
            }
        }

        public void refreshActionState() {
        }
    }

    public class ToggleSearchListAction
    extends FWToggleAction {
        public ToggleSearchListAction(boolean bl) {
            super(Localizer.getString("SearchTab_ToggleSearchListAction"), null, null, null, null, null);
            this.setSelected(bl);
            this.updateTooltip();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = !this.isSelected();
            this.setSelected(bl);
            SearchTab.this.setSearchListVisible(bl);
            this.updateTooltip();
        }

        private void updateTooltip() {
            if (this.isSelected()) {
                this.setToolTipText(Localizer.getString("SearchTab_TTTToggleSearchListActionHide"));
            } else {
                this.setToolTipText(Localizer.getString("SearchTab_TTTToggleSearchListActionShow"));
            }
        }

        public void refreshActionState() {
        }
    }

    public class ToggleSearchBarAction
    extends FWToggleAction {
        public ToggleSearchBarAction(boolean bl) {
            super(Localizer.getString("SearchTab_ToggleSearchBarAction"), null, null, null, null, null);
            this.setSelected(bl);
            this.updateTooltip();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = !this.isSelected();
            this.setSelected(bl);
            SearchTab.this.setSearchButtonBarVisible(bl);
            this.updateTooltip();
        }

        private void updateTooltip() {
            if (this.isSelected()) {
                this.setToolTipText(Localizer.getString("SearchTab_TTTToggleSearchBarActionHide"));
            } else {
                this.setToolTipText(Localizer.getString("SearchTab_TTTToggleSearchBarActionShow"));
            }
        }

        public void refreshActionState() {
        }
    }

    private class CreateNewSearchAction
    extends FWAction {
        public CreateNewSearchAction() {
            super(Localizer.getString("CreateNewSearch"), GUIRegistry.getInstance().getIconFactory().getIcon("Search"), Localizer.getString("TTTCreateNewSearch"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SearchTab.this.setDisplayedSearch(null);
        }

        public void refreshActionState() {
            this.setEnabled(true);
        }
    }

    private class ClearSearchResultsAction
    extends FWAction {
        public ClearSearchResultsAction() {
            super(Localizer.getString("ClearSearchResults"), GUIRegistry.getInstance().getIconFactory().getIcon("Remove"), Localizer.getString("TTTClearSearchResults"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (SearchTab.this.displayedDataModel != null) {
                SearchTab.this.displayedDataModel.clearSearchResults();
            }
        }

        public void refreshActionState() {
            if (SearchTab.this.displayedDataModel == null || SearchTab.this.displayedDataModel.getSearchElementCount() + SearchTab.this.displayedDataModel.getFilteredElementCount() == 0) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
        }
    }

    private class CloseSearchAction
    extends FWAction {
        private SearchContainer searchContainer;

        public CloseSearchAction() {
            super(Localizer.getString("CloseSearch"), GUIRegistry.getInstance().getIconFactory().getIcon("Close"), Localizer.getString("TTTCloseSearch"), null, KeyStroke.getKeyStroke(127, 0));
            this.searchContainer = QueryManager.getInstance().getSearchContainer();
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (SearchTab.this.displayedDataModel != null) {
                this.searchContainer.removeSearch(SearchTab.this.displayedDataModel.getSearch());
                SearchTab.this.setDisplayedSearch(null);
            }
        }

        public void refreshActionState() {
            if (SearchTab.this.displayedDataModel == null) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
        }
    }
}

