/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs.search;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.tree.TreePath;
import phex.chat.ChatManager;
import phex.common.ServiceManager;
import phex.common.ThreadPool;
import phex.common.address.DestAddress;
import phex.download.RemoteFile;
import phex.download.swarming.SWDownloadFile;
import phex.download.swarming.SwarmingManager;
import phex.gui.actions.BanHostActionUtils;
import phex.gui.actions.FWAction;
import phex.gui.actions.GUIActionPerformer;
import phex.gui.common.BrowserLauncher;
import phex.gui.common.FWToolBar;
import phex.gui.common.GUIRegistry;
import phex.gui.common.GUIUtils;
import phex.gui.common.LabeledIcon;
import phex.gui.common.table.FWTable;
import phex.gui.common.table.FWTableColumn;
import phex.gui.common.table.FWTableColumnModel;
import phex.gui.common.table.FWTableModel;
import phex.gui.common.table.SortedTableHeaderRenderer;
import phex.gui.common.treetable.JTreeTable;
import phex.gui.dialogs.DownloadConfigDialog;
import phex.gui.models.ISearchDataModel;
import phex.gui.models.SearchTreeTableModel;
import phex.gui.renderer.SearchResultsRowRenderer;
import phex.gui.renderer.SearchTreeCellRenderer;
import phex.gui.tabs.search.SearchResultElement;
import phex.gui.tabs.search.SearchResultsDataModel;
import phex.gui.tabs.search.SearchTab;
import phex.utils.Localizer;
import phex.utils.NLogger;
import phex.utils.StringUtils;
import phex.utils.URLUtil;
import phex.xml.sax.gui.DGuiSettings;
import phex.xml.sax.gui.DTable;
import phex.xml.sax.gui.DTableColumnList;

public class SearchResultsPanel
extends JPanel {
    private static final String SEARCH_TREE_TABLE_IDENTIFIER = "SearchTreeTable";
    private static final RemoteFile[] EMPTY_REMOTE_FILE_ARRAY = new RemoteFile[0];
    private SearchTab searchTab;
    private JPopupMenu searchResultPopup;
    private JTreeTable searchTreeTable;
    private SearchTreeTableModel searchTreeTableModel;
    private FWTableColumnModel searchTreeColumnModel;
    private JScrollPane searchTreeTableScrollPane;
    private static final String QUICK_DOWNLOAD_ACTION_KEY = "SWQuickDownloadAction";
    private static final String CONFIG_DOWNLOAD_ACTION_KEY = "SWConfigDownloadAction";
    private static final String VIEW_BITZI_TICKET_ACTION_KEY = "ViewBitziTicketAction";
    private static final String CHAT_TO_HOST_ACTION_KEY = "ChatToHostAction";
    private static final String BROWSE_HOST_ACTION_KEY = "BrowseHostAction";
    private static final String ADD_TO_FAVORITES_ACTION_KEY = "AddToFavoritesAction";

    public SearchResultsPanel(SearchTab searchTab) {
        this.searchTab = searchTab;
    }

    public void initializeComponent(DGuiSettings dGuiSettings) {
        Serializable serializable;
        CellConstraints cellConstraints = new CellConstraints();
        FormLayout formLayout = new FormLayout("fill:d:grow", "fill:d:grow, 1dlu, p");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout, this);
        MouseHandler mouseHandler = new MouseHandler();
        this.searchTreeTableModel = new SearchTreeTableModel();
        this.searchTreeTable = new JTreeTable(this.searchTreeTableModel);
        this.buildSearchTreeTableColumnModel(dGuiSettings);
        this.searchTreeTable.setColumnModel(this.searchTreeColumnModel);
        this.searchTreeTable.activateHeaderPopupMenu();
        this.searchTreeTable.activateColumnResizeToFit();
        JTableHeader jTableHeader = this.searchTreeTable.getTableHeader();
        jTableHeader.setDefaultRenderer(new SortedTableHeaderRenderer(this.searchTreeTable));
        jTableHeader.addMouseListener(new TableHeaderMouseHandler());
        this.searchTreeTable.addMouseListener(mouseHandler);
        this.searchTreeTable.setAutoResizeMode(0);
        this.searchTreeTable.setClosedIcon(new LabeledIcon(UIManager.getIcon("Tree.closedIcon"), null));
        this.searchTreeTable.getSelectionModel().addListSelectionListener(new SearchTreeTableSelectionListener());
        this.searchTreeTable.setTreeCellRenderer(new SearchTreeCellRenderer());
        SearchResultsRowRenderer searchResultsRowRenderer = new SearchResultsRowRenderer(this.searchTreeTableModel);
        Enumeration<TableColumn> enumeration = this.searchTreeColumnModel.getColumns();
        while (enumeration.hasMoreElements()) {
            serializable = enumeration.nextElement();
            ((TableColumn)serializable).setCellRenderer(searchResultsRowRenderer);
        }
        this.searchTreeTableScrollPane = FWTable.createFWTableScrollPane(this.searchTreeTable);
        this.searchTreeTableScrollPane.addMouseListener(mouseHandler);
        panelBuilder.add((Component)this.searchTreeTableScrollPane, cellConstraints.xy(1, 1));
        serializable = new FWToolBar(0);
        ((JToolBar)serializable).setBorderPainted(false);
        ((JToolBar)serializable).setFloatable(false);
        panelBuilder.add((Component)serializable, cellConstraints.xy(1, 3));
        this.searchResultPopup = new JPopupMenu();
        FWAction fWAction = new SWQuickDownloadAction();
        this.searchTab.addTabAction(QUICK_DOWNLOAD_ACTION_KEY, fWAction);
        ((FWToolBar)serializable).addAction(fWAction);
        this.searchResultPopup.add(fWAction);
        fWAction = new SWConfigDownloadAction();
        this.searchTab.addTabAction(CONFIG_DOWNLOAD_ACTION_KEY, fWAction);
        ((FWToolBar)serializable).addAction(fWAction);
        this.searchResultPopup.add(fWAction);
        fWAction = new ViewBitziTicketAction();
        this.searchTab.addTabAction(VIEW_BITZI_TICKET_ACTION_KEY, fWAction);
        ((FWToolBar)serializable).addAction(fWAction);
        this.searchResultPopup.add(fWAction);
        this.searchResultPopup.addSeparator();
        fWAction = new AddToFavoritesAction();
        this.searchTab.addTabAction(ADD_TO_FAVORITES_ACTION_KEY, fWAction);
        this.searchResultPopup.add(fWAction);
        fWAction = new BrowseHostAction();
        this.searchTab.addTabAction(BROWSE_HOST_ACTION_KEY, fWAction);
        ((FWToolBar)serializable).addAction(fWAction);
        this.searchResultPopup.add(fWAction);
        fWAction = new ChatToHostAction();
        this.searchTab.addTabAction(CHAT_TO_HOST_ACTION_KEY, fWAction);
        this.searchResultPopup.add(fWAction);
        BanHostActionProvider banHostActionProvider = new BanHostActionProvider();
        BanHostActionUtils.BanHostActionMenu banHostActionMenu = BanHostActionUtils.createActionMenu(banHostActionProvider);
        this.searchResultPopup.add(banHostActionMenu.menu);
        this.searchTab.addTabActions(banHostActionMenu.actions);
        fWAction = BanHostActionUtils.createToolBarAction(banHostActionProvider);
        ((FWToolBar)serializable).addAction(fWAction);
        this.searchTab.addTabAction(fWAction);
        this.searchResultPopup.addSeparator();
        this.searchResultPopup.add(this.searchTab.getTabAction("CreateNewSearchAction"));
        this.searchResultPopup.add(this.searchTab.getTabAction("ClearSearchResultsAction"));
        this.searchResultPopup.add(this.searchTab.getTabAction("CloseSearchAction"));
    }

    public void setDisplayedSearch(SearchResultsDataModel searchResultsDataModel) {
        this.searchTreeTableModel.setDisplayedSearch(searchResultsDataModel);
    }

    private void buildSearchTreeTableColumnModel(DGuiSettings dGuiSettings) {
        DTable dTable = GUIUtils.getDGuiTableByIdentifier(dGuiSettings, SEARCH_TREE_TABLE_IDENTIFIER);
        int[] nArray = SearchTreeTableModel.getColumnIdArray();
        DTableColumnList dTableColumnList = null;
        if (dTable != null) {
            dTableColumnList = dTable.getTableColumnList();
        }
        this.searchTreeColumnModel = new FWTableColumnModel((FWTableModel)this.searchTreeTable.getModel(), nArray, dTableColumnList);
    }

    public RemoteFile[] getSelectedRemoteFiles(boolean bl) {
        ISearchDataModel iSearchDataModel = this.searchTreeTableModel.getDisplayedResultsData();
        if (iSearchDataModel == null) {
            return EMPTY_REMOTE_FILE_ARRAY;
        }
        TreePath[] treePathArray = this.searchTreeTable.getTreeSelectionModel().getSelectionPaths();
        if (treePathArray.length == 0) {
            return EMPTY_REMOTE_FILE_ARRAY;
        }
        HashSet<Object> hashSet = new HashSet<Object>();
        for (int i = 0; i < treePathArray.length; ++i) {
            RemoteFile[] remoteFileArray;
            Object object;
            if (treePathArray[i].getPathCount() == 3) {
                if (bl) {
                    object = (SearchResultElement)treePathArray[i].getPathComponent(1);
                    remoteFileArray = ((SearchResultElement)object).getRemoteFiles();
                    hashSet.addAll(Arrays.asList(remoteFileArray));
                    continue;
                }
                object = (RemoteFile)treePathArray[i].getPathComponent(2);
                hashSet.add(object);
                continue;
            }
            object = (SearchResultElement)treePathArray[i].getPathComponent(1);
            remoteFileArray = ((SearchResultElement)object).getRemoteFiles();
            hashSet.addAll(Arrays.asList(remoteFileArray));
        }
        RemoteFile[] remoteFileArray = new RemoteFile[hashSet.size()];
        hashSet.toArray(remoteFileArray);
        return remoteFileArray;
    }

    private RemoteFile getSelectedRemoteFile(boolean bl) {
        RemoteFile remoteFile;
        ISearchDataModel iSearchDataModel = this.searchTreeTableModel.getDisplayedResultsData();
        if (iSearchDataModel == null) {
            return null;
        }
        TreePath treePath = this.searchTreeTable.getTreeSelectionModel().getSelectionPath();
        if (treePath == null) {
            return null;
        }
        if (treePath.getPathCount() == 3) {
            remoteFile = (RemoteFile)treePath.getPathComponent(2);
        } else {
            SearchResultElement searchResultElement = (SearchResultElement)treePath.getPathComponent(1);
            if (!bl && searchResultElement.getRemoteFileListCount() != 0) {
                return null;
            }
            remoteFile = searchResultElement.getSingleRemoteFile();
        }
        return remoteFile;
    }

    public void updateUI() {
        super.updateUI();
        if (this.searchTreeTableScrollPane != null) {
            FWTable.updateFWTableScrollPane(this.searchTreeTableScrollPane);
        }
    }

    public void appendDGuiSettings(DGuiSettings dGuiSettings) {
        DTableColumnList dTableColumnList = this.searchTreeColumnModel.createDGuiTableColumnList();
        DTable dTable = new DTable();
        dTable.setTableColumnList(dTableColumnList);
        dTable.setTableIdentifier(SEARCH_TREE_TABLE_IDENTIFIER);
        dGuiSettings.getTableList().getTableList().add(dTable);
    }

    private class SearchTreeTableSelectionListener
    implements ListSelectionListener {
        private SearchTreeTableSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            try {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    SearchResultsPanel.this.searchTab.refreshTabActions();
                }
            }
            catch (Throwable throwable) {
                NLogger.error("USER_INTERFACE", (Object)throwable, throwable);
            }
        }
    }

    private class TableHeaderMouseHandler
    extends MouseAdapter
    implements MouseListener {
        private TableHeaderMouseHandler() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            try {
                FWTableColumn fWTableColumn = SearchResultsPanel.this.searchTreeTable.getResizingColumn(mouseEvent.getPoint());
                int n = mouseEvent.getClickCount();
                if (fWTableColumn == null && n == 1) {
                    this.handleColumnSorting(mouseEvent);
                }
            }
            catch (Throwable throwable) {
                NLogger.error("USER_INTERFACE", (Object)throwable, throwable);
            }
        }

        private void handleColumnSorting(MouseEvent mouseEvent) {
            int n = SearchResultsPanel.this.searchTreeTable.getColumnModel().getColumnIndexAtX(mouseEvent.getX());
            int n2 = SearchResultsPanel.this.searchTreeTable.convertColumnIndexToModel(n);
            if (n2 == -1) {
                return;
            }
            FWTableColumn fWTableColumn = (FWTableColumn)SearchResultsPanel.this.searchTreeTable.getColumnModel().getColumn(n);
            boolean bl = fWTableColumn.reverseSortingOrder();
            SearchResultsPanel.this.searchTreeTableModel.sortByColumn(n2, bl);
        }
    }

    private class MouseHandler
    extends MouseAdapter
    implements MouseListener {
        private MouseHandler() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            try {
                if (mouseEvent.getClickCount() == 2 && mouseEvent.getSource() == SearchResultsPanel.this.searchTreeTable) {
                    SearchResultsPanel.this.searchTab.getTabAction(SearchResultsPanel.QUICK_DOWNLOAD_ACTION_KEY).actionPerformed(null);
                }
            }
            catch (Throwable throwable) {
                NLogger.error("USER_INTERFACE", (Object)throwable, throwable);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            try {
                if (mouseEvent.isPopupTrigger()) {
                    this.popupMenu((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
            catch (Throwable throwable) {
                NLogger.error("USER_INTERFACE", (Object)throwable, throwable);
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            try {
                if (mouseEvent.isPopupTrigger()) {
                    this.popupMenu((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
            catch (Throwable throwable) {
                NLogger.error("USER_INTERFACE", (Object)throwable, throwable);
            }
        }

        private void popupMenu(Component component, int n, int n2) {
            if (component == SearchResultsPanel.this.searchTreeTable || component == SearchResultsPanel.this.searchTreeTableScrollPane) {
                SearchResultsPanel.this.searchResultPopup.show(component, n, n2);
            }
        }
    }

    private class AddToFavoritesAction
    extends FWAction {
        public AddToFavoritesAction() {
            super(Localizer.getString("AddToFavorites"), GUIRegistry.getInstance().getIconFactory().getIcon("FavoriteHost"), Localizer.getString("TTTAddToFavorites"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            RemoteFile[] remoteFileArray = SearchResultsPanel.this.getSelectedRemoteFiles(false);
            DestAddress[] destAddressArray = new DestAddress[remoteFileArray.length];
            for (int i = 0; i < remoteFileArray.length; ++i) {
                destAddressArray[i] = remoteFileArray[i].getHostAddress();
            }
            GUIActionPerformer.addHostsToFavorites(destAddressArray);
        }

        public void refreshActionState() {
            if (SearchResultsPanel.this.searchTreeTable.getSelectedRow() < 0) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
        }
    }

    private final class BanHostActionProvider
    implements BanHostActionUtils.BanHostActionProvider {
        private BanHostActionProvider() {
        }

        public DestAddress[] getBanHostAddresses() {
            RemoteFile[] remoteFileArray = SearchResultsPanel.this.getSelectedRemoteFiles(false);
            DestAddress[] destAddressArray = new DestAddress[remoteFileArray.length];
            for (int i = 0; i < remoteFileArray.length; ++i) {
                destAddressArray[i] = remoteFileArray[i].getHostAddress();
            }
            return destAddressArray;
        }

        public boolean isBanHostActionEnabled(boolean bl) {
            return SearchResultsPanel.this.searchTreeTable.getSelectedRow() >= 0 && (bl || SearchResultsPanel.this.searchTreeTable.getSelectedRowCount() <= 1);
        }
    }

    private class BrowseHostAction
    extends FWAction {
        public BrowseHostAction() {
            super(Localizer.getString("BrowseHost"), GUIRegistry.getInstance().getIconFactory().getIcon("BrowseHost"), Localizer.getString("TTTBrowseHost"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            RemoteFile remoteFile = SearchResultsPanel.this.getSelectedRemoteFile(false);
            if (remoteFile == null) {
                return;
            }
            if (!remoteFile.getQueryHitHost().isBrowseHostSupported()) {
                return;
            }
            GUIActionPerformer.browseHost(remoteFile.getHostAddress());
        }

        public void refreshActionState() {
            RemoteFile remoteFile;
            if (SearchResultsPanel.this.searchTreeTable.getSelectedRowCount() == 1 && (remoteFile = SearchResultsPanel.this.getSelectedRemoteFile(false)) != null && remoteFile.getQueryHitHost().isBrowseHostSupported()) {
                this.setEnabled(true);
                return;
            }
            this.setEnabled(false);
        }
    }

    private class ChatToHostAction
    extends FWAction {
        public ChatToHostAction() {
            super(Localizer.getString("ChatToHost"), GUIRegistry.getInstance().getIconFactory().getIcon("Chat"), Localizer.getString("TTTChatToHost"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            RemoteFile remoteFile = SearchResultsPanel.this.getSelectedRemoteFile(false);
            if (remoteFile == null) {
                return;
            }
            if (!remoteFile.getQueryHitHost().isChatSupported()) {
                return;
            }
            ChatManager.getInstance().openChat(remoteFile.getHostAddress());
        }

        public void refreshActionState() {
            RemoteFile remoteFile;
            if (SearchResultsPanel.this.searchTreeTable.getSelectedRowCount() == 1 && (remoteFile = SearchResultsPanel.this.getSelectedRemoteFile(false)) != null && remoteFile.getQueryHitHost().isChatSupported()) {
                this.setEnabled(true);
                return;
            }
            this.setEnabled(false);
        }
    }

    private class ViewBitziTicketAction
    extends FWAction {
        public ViewBitziTicketAction() {
            super(Localizer.getString("ViewBitziTicket"), GUIRegistry.getInstance().getIconFactory().getIcon("Bitzi"), Localizer.getString("TTTViewBitziTicket"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            block3: {
                RemoteFile remoteFile = SearchResultsPanel.this.getSelectedRemoteFile(true);
                if (remoteFile == null) {
                    return;
                }
                String string = URLUtil.buildBitziLookupURL(remoteFile.getURN());
                try {
                    BrowserLauncher.openURL(string);
                }
                catch (IOException iOException) {
                    NLogger.warn("USER_INTERFACE", (Object)iOException, (Throwable)iOException);
                    Object[] objectArray = new Object[]{Localizer.getString("Yes"), Localizer.getString("No")};
                    int n = JOptionPane.showOptionDialog(SearchResultsPanel.this.searchTab, Localizer.getString("FailedToLaunchBrowserURLInClipboard"), Localizer.getString("FailedToLaunchBrowser"), 0, 2, null, objectArray, Localizer.getString("Yes"));
                    if (n != 0) break block3;
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(string), null);
                }
            }
        }

        public void refreshActionState() {
            if (SearchResultsPanel.this.searchTreeTable.getSelectedRowCount() == 1) {
                RemoteFile remoteFile = SearchResultsPanel.this.getSelectedRemoteFile(true);
                if (remoteFile != null && remoteFile.getURN() != null) {
                    this.setEnabled(true);
                    return;
                }
            } else {
                this.setEnabled(false);
            }
        }
    }

    private class SWConfigDownloadAction
    extends FWAction {
        public SWConfigDownloadAction() {
            super(Localizer.getString("Download"), GUIRegistry.getInstance().getIconFactory().getIcon("ConfigDownload"), Localizer.getString("TTTDownload"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SwarmingManager swarmingManager = SwarmingManager.getInstance();
            RemoteFile[] remoteFileArray = SearchResultsPanel.this.getSelectedRemoteFiles(true);
            for (int i = 0; i < remoteFileArray.length; ++i) {
                SWDownloadFile sWDownloadFile = swarmingManager.getDownloadFile(remoteFileArray[i].getFileSize(), remoteFileArray[i].getURN());
                if (sWDownloadFile != null) {
                    sWDownloadFile.addDownloadCandidate(remoteFileArray[i]);
                    remoteFileArray[i].setInDownloadQueue(true);
                    continue;
                }
                RemoteFile remoteFile = new RemoteFile(remoteFileArray[i]);
                DownloadConfigDialog downloadConfigDialog = new DownloadConfigDialog(remoteFile);
                downloadConfigDialog.show();
                if (downloadConfigDialog.isDialogCanceled()) {
                    return;
                }
                if (!remoteFile.isInDownloadQueue()) continue;
                remoteFileArray[i].setInDownloadQueue(true);
            }
        }

        public void refreshActionState() {
            if (SearchResultsPanel.this.searchTreeTable.getSelectedRow() < 0) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
        }
    }

    private class SWQuickDownloadAction
    extends FWAction {
        public SWQuickDownloadAction() {
            super(Localizer.getString("QuickDownload"), GUIRegistry.getInstance().getIconFactory().getIcon("Download"), Localizer.getString("TTTQuickDownload"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            final RemoteFile[] remoteFileArray = SearchResultsPanel.this.getSelectedRemoteFiles(true);
            Runnable runnable = new Runnable(){

                public void run() {
                    try {
                        SwarmingManager swarmingManager = SwarmingManager.getInstance();
                        for (int i = 0; i < remoteFileArray.length; ++i) {
                            remoteFileArray[i].setInDownloadQueue(true);
                            SWDownloadFile sWDownloadFile = swarmingManager.getDownloadFile(remoteFileArray[i].getFileSize(), remoteFileArray[i].getURN());
                            if (sWDownloadFile != null) {
                                sWDownloadFile.addDownloadCandidate(remoteFileArray[i]);
                                continue;
                            }
                            RemoteFile remoteFile = new RemoteFile(remoteFileArray[i]);
                            String string = StringUtils.createNaturalSearchTerm(remoteFile.getFilename());
                            swarmingManager.addFileToDownload(remoteFile, ServiceManager.sCfg.mDownloadDir + File.separator + remoteFile.getFilename(), string);
                        }
                    }
                    catch (Throwable throwable) {
                        NLogger.error("USER_INTERFACE", (Object)throwable, throwable);
                    }
                }
            };
            ThreadPool.getInstance().addJob(runnable, "QuickDownloadAction");
        }

        public void refreshActionState() {
            if (SearchResultsPanel.this.searchTreeTable.getSelectedRow() < 0) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
        }
    }
}

