/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs.search;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Set;
import phex.common.IntObj;
import phex.common.address.DestAddress;
import phex.common.address.IpAddress;
import phex.download.RemoteFile;
import phex.event.SearchDataEvent;
import phex.event.SearchDataListener;
import phex.event.SecurityRulesChangeListener;
import phex.gui.models.ISearchDataModel;
import phex.gui.models.SearchTreeTableModel;
import phex.gui.tabs.search.SearchResultElement;
import phex.gui.tabs.search.SearchResultElementComparator;
import phex.query.QueryManager;
import phex.query.Search;
import phex.rules.Rule;
import phex.rules.SearchFilterRules;
import phex.security.IPAccessRule;
import phex.security.PhexSecurityManager;
import phex.security.SecurityRule;

public class SearchResultsDataModel
implements SearchDataListener,
SecurityRulesChangeListener,
ISearchDataModel {
    private static final HashMap searchToDataModelMap = new HashMap();
    private ArrayList allRemoteFiles;
    private HashSet allSearchResultSHA1Set;
    private int allSearchResultCount;
    private ArrayList displayedSearchResults;
    private HashMap displayedSearchResultSHA1Map;
    private SearchTreeTableModel visualizationModel;
    private SearchResultElementComparator comparator;
    private Search search;
    private Rule quickFilterRule;
    private Set searchFilterRuleSet;
    private IntObj searchElementCountObj;
    private IntObj filteredElementCountObj;

    private SearchResultsDataModel(Search search) {
        this.search = search;
        this.allRemoteFiles = new ArrayList();
        this.allSearchResultSHA1Set = new HashSet();
        this.allSearchResultCount = 0;
        this.displayedSearchResults = new ArrayList();
        this.displayedSearchResultSHA1Map = new HashMap();
        this.searchElementCountObj = new IntObj();
        this.filteredElementCountObj = new IntObj();
        this.comparator = new SearchResultElementComparator();
        this.searchFilterRuleSet = new HashSet();
        SearchFilterRules searchFilterRules = QueryManager.getInstance().getSearchFilterRules();
        this.searchFilterRuleSet.addAll(searchFilterRules.getPermanentList());
        search.addSearchChangeListener(this);
        PhexSecurityManager.getInstance().addSecurityRuleChangeListener(this);
    }

    public int getSearchElementCount() {
        return this.displayedSearchResults.size();
    }

    public int getAllSearchResultCount() {
        return this.allSearchResultCount;
    }

    public IntObj getSearchElementCountObj() {
        if (this.searchElementCountObj.intValue() != this.displayedSearchResults.size()) {
            this.searchElementCountObj.setValue(this.displayedSearchResults.size());
        }
        return this.searchElementCountObj;
    }

    public IntObj getFilteredElementCountObj() {
        int n = this.getFilteredElementCount();
        if (this.filteredElementCountObj.intValue() != n) {
            this.filteredElementCountObj.setValue(n);
        }
        return this.filteredElementCountObj;
    }

    public int getFilteredElementCount() {
        return this.allSearchResultCount - this.displayedSearchResults.size();
    }

    public SearchResultElement getSearchElementAt(int n) {
        if (n < 0 || n >= this.displayedSearchResults.size()) {
            return null;
        }
        return (SearchResultElement)this.displayedSearchResults.get(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSearchResults(RemoteFile[] remoteFileArray) {
        this.processFilterRules(remoteFileArray);
        ArrayList arrayList = this.allRemoteFiles;
        synchronized (arrayList) {
            ArrayList arrayList2 = this.displayedSearchResults;
            synchronized (arrayList2) {
                for (int i = 0; i < remoteFileArray.length; ++i) {
                    RemoteFile remoteFile = remoteFileArray[i];
                    if (remoteFile.isFilteredRemoved()) continue;
                    if (!remoteFile.isFilteredHidden()) {
                        this.addSearchResultForDisplay(remoteFile);
                    }
                    this.addSearchResultToAll(remoteFile);
                }
            }
        }
    }

    private void addSearchResultToAll(RemoteFile remoteFile) {
        this.allRemoteFiles.add(remoteFile);
        String string = remoteFile.getSHA1();
        boolean bl = false;
        if (string != null) {
            bl = this.allSearchResultSHA1Set.contains(string);
        }
        if (!bl) {
            ++this.allSearchResultCount;
            if (string != null && string.length() > 0) {
                this.allSearchResultSHA1Set.add(string);
            }
        }
    }

    private void addSearchResultForDisplay(RemoteFile remoteFile) {
        SearchResultElement searchResultElement = null;
        String string = remoteFile.getSHA1();
        if (string != null) {
            searchResultElement = (SearchResultElement)this.displayedSearchResultSHA1Map.get(string);
        }
        if (searchResultElement != null) {
            searchResultElement.addRemoteFile(remoteFile);
            this.fireSearchResultAdded(remoteFile, searchResultElement);
        } else {
            searchResultElement = new SearchResultElement(remoteFile);
            int n = Collections.binarySearch(this.displayedSearchResults, searchResultElement, this.comparator);
            if (n <= 0) {
                if (string != null && string.length() > 0) {
                    this.displayedSearchResultSHA1Map.put(string, searchResultElement);
                }
                this.displayedSearchResults.add(-n - 1, searchResultElement);
                this.fireNewSearchResultAdded(searchResultElement, -n - 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSortBy(int n, boolean bl) {
        ArrayList arrayList = this.displayedSearchResults;
        synchronized (arrayList) {
            this.comparator.setSortField(n, bl);
            Collections.sort(this.displayedSearchResults, this.comparator);
            this.fireAllSearchResultsChanged();
        }
    }

    public void setVisualizationModel(SearchTreeTableModel searchTreeTableModel) {
        this.visualizationModel = searchTreeTableModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearSearchResults() {
        ArrayList arrayList = this.allRemoteFiles;
        synchronized (arrayList) {
            ArrayList arrayList2 = this.displayedSearchResults;
            synchronized (arrayList2) {
                this.allRemoteFiles.clear();
                this.allSearchResultSHA1Set.clear();
                this.allSearchResultCount = 0;
                this.displayedSearchResults.clear();
                this.displayedSearchResultSHA1Map.clear();
                this.fireAllSearchResultsChanged();
                this.search.fireSearchChanged();
            }
        }
    }

    public Search getSearch() {
        return this.search;
    }

    public Rule getQuickFilterRule() {
        return this.quickFilterRule;
    }

    public void setQuickFilterRule(Rule rule) {
        this.quickFilterRule = rule;
        this.updateFilteredQueryList();
    }

    public boolean isRuleActive(Rule rule) {
        return this.searchFilterRuleSet.contains(rule);
    }

    public void activateRule(Rule rule) {
        this.searchFilterRuleSet.add(rule);
        this.updateFilteredQueryList();
    }

    public void deactivateRule(Rule rule) {
        this.searchFilterRuleSet.remove(rule);
        this.updateFilteredQueryList();
    }

    private void processFilterRules(RemoteFile[] remoteFileArray) {
        if (this.searchFilterRuleSet == null) {
            return;
        }
        if (this.quickFilterRule != null) {
            this.quickFilterRule.process(this.search, remoteFileArray);
        }
        Iterator iterator = this.searchFilterRuleSet.iterator();
        while (iterator.hasNext()) {
            Rule rule = (Rule)iterator.next();
            rule.process(this.search, remoteFileArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFilteredQueryList() {
        ArrayList arrayList = this.allRemoteFiles;
        synchronized (arrayList) {
            ArrayList arrayList2 = this.displayedSearchResults;
            synchronized (arrayList2) {
                RemoteFile[] remoteFileArray = new RemoteFile[this.allRemoteFiles.size()];
                this.allRemoteFiles.toArray(remoteFileArray);
                this.allSearchResultCount = 0;
                this.allRemoteFiles.clear();
                this.allSearchResultSHA1Set.clear();
                this.displayedSearchResultSHA1Map.clear();
                this.displayedSearchResults.clear();
                this.fireAllSearchResultsChanged();
                for (int i = 0; i < remoteFileArray.length; ++i) {
                    remoteFileArray[i].clearFilterFlags();
                }
                this.addSearchResults(remoteFileArray);
                this.search.fireSearchChanged();
            }
        }
    }

    public void searchDataChanged(SearchDataEvent searchDataEvent) {
        if (searchDataEvent.getType() == 1) {
            RemoteFile[] remoteFileArray = searchDataEvent.getSearchData();
            this.addSearchResults(remoteFileArray);
        }
    }

    public String toString() {
        return super.toString() + " - " + this.search;
    }

    public void securityRuleChanged(int n) {
    }

    public void securityRuleAdded(SecurityRule securityRule, int n) {
        if (securityRule.isDisabled()) {
            return;
        }
        if (securityRule instanceof IPAccessRule) {
            this.updateSecurityFilteredQueryList((IPAccessRule)securityRule);
        }
    }

    public void securityRuleRemoved(int n) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSecurityFilteredQueryList(IPAccessRule iPAccessRule) {
        ArrayList arrayList = this.allRemoteFiles;
        synchronized (arrayList) {
            ArrayList arrayList2 = this.displayedSearchResults;
            synchronized (arrayList2) {
                RemoteFile[] remoteFileArray;
                ArrayList arrayList3 = new ArrayList(this.allRemoteFiles);
                this.allSearchResultCount = 0;
                this.allRemoteFiles.clear();
                this.allSearchResultSHA1Set.clear();
                this.displayedSearchResultSHA1Map.clear();
                this.displayedSearchResults.clear();
                this.fireAllSearchResultsChanged();
                ListIterator listIterator = arrayList3.listIterator();
                while (listIterator.hasNext()) {
                    remoteFileArray = (RemoteFile[])listIterator.next();
                    DestAddress destAddress = remoteFileArray.getHostAddress();
                    IpAddress ipAddress = destAddress.getIpAddress();
                    if (ipAddress != null && !iPAccessRule.isHostIPAllowed(ipAddress.getHostIP())) {
                        listIterator.remove();
                        continue;
                    }
                    remoteFileArray.clearFilterFlags();
                }
                remoteFileArray = new RemoteFile[arrayList3.size()];
                arrayList3.toArray(remoteFileArray);
                this.addSearchResults(remoteFileArray);
                this.search.fireSearchChanged();
            }
        }
    }

    private void fireAllSearchResultsChanged() {
        if (this.visualizationModel == null) {
            return;
        }
        Object[] objectArray = new Object[]{this.visualizationModel.getRoot()};
        this.visualizationModel.fireTreeStructureChanged(this, objectArray, null, null);
    }

    private void fireNewSearchResultAdded(SearchResultElement searchResultElement, int n) {
        if (this.visualizationModel == null) {
            return;
        }
        Object[] objectArray = new Object[]{this.visualizationModel.getRoot()};
        int[] nArray = new int[]{n};
        Object[] objectArray2 = new Object[]{searchResultElement};
        if (this.displayedSearchResults.size() == 1) {
            this.visualizationModel.fireTreeStructureChanged(this, objectArray, nArray, objectArray2);
        } else {
            this.visualizationModel.fireTreeNodesInserted(this, objectArray, nArray, objectArray2);
        }
    }

    private void fireSearchResultAdded(RemoteFile remoteFile, SearchResultElement searchResultElement) {
        if (this.visualizationModel == null) {
            return;
        }
        Object[] objectArray = new Object[]{this.visualizationModel.getRoot(), searchResultElement};
        Object[] objectArray2 = new Object[]{remoteFile};
        this.visualizationModel.fireTreeNodesInserted(this, objectArray, null, objectArray2);
    }

    public static SearchResultsDataModel registerNewSearch(Search search) {
        SearchResultsDataModel searchResultsDataModel = new SearchResultsDataModel(search);
        searchToDataModelMap.put(search, searchResultsDataModel);
        return searchResultsDataModel;
    }

    public static SearchResultsDataModel lookupResultDataModel(Search search) {
        return (SearchResultsDataModel)searchToDataModelMap.get(search);
    }
}

