/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs.search;

import java.util.Comparator;
import phex.gui.comparator.HostAddressComparator;
import phex.gui.tabs.search.SearchResultElement;

public class SearchResultElementComparator
implements Comparator {
    public static final int UNSORTED = 0;
    public static final int SORT_BY_SIZE = 1;
    public static final int SORT_BY_FILE = 2;
    public static final int SORT_BY_EXTENSION = 3;
    public static final int SORT_BY_SHA1 = 4;
    public static final int SORT_BY_HOST = 5;
    public static final int SORT_BY_META_DATA = 6;
    public static final int SORT_BY_VENDOR = 7;
    public static final int SORT_BY_SPEED = 8;
    public static final int SORT_BY_RATING = 9;
    public static final int SORT_BY_SCORE = 10;
    private int sortField;
    private boolean isSortedAscending;
    private HostAddressComparator hostAddressComparator;

    public void setSortField(int n, boolean bl) {
        this.sortField = n;
        this.isSortedAscending = bl;
        this.hostAddressComparator = new HostAddressComparator();
    }

    public int compare(Object object, Object object2) {
        long l;
        if (object == object2 || object.equals(object2)) {
            return 0;
        }
        SearchResultElement searchResultElement = (SearchResultElement)object;
        SearchResultElement searchResultElement2 = (SearchResultElement)object2;
        switch (this.sortField) {
            case 1: {
                l = searchResultElement.getSingleRemoteFile().getFileSize() - searchResultElement2.getSingleRemoteFile().getFileSize();
                break;
            }
            case 2: {
                l = searchResultElement.getSingleRemoteFile().getFilename().compareTo(searchResultElement2.getSingleRemoteFile().getFilename());
                break;
            }
            case 3: {
                l = searchResultElement.getSingleRemoteFile().getFileExt().compareTo(searchResultElement2.getSingleRemoteFile().getFileExt());
                break;
            }
            case 4: {
                l = searchResultElement.getSingleRemoteFile().getSHA1().compareTo(searchResultElement2.getSingleRemoteFile().getSHA1());
                break;
            }
            case 5: {
                if (searchResultElement.getRemoteFileListCount() == 0 && searchResultElement2.getRemoteFileListCount() == 0) {
                    l = this.hostAddressComparator.compare(searchResultElement.getSingleRemoteFile().getHostAddress(), searchResultElement2.getSingleRemoteFile().getHostAddress());
                    break;
                }
                l = searchResultElement.getRemoteFileListCount() - searchResultElement2.getRemoteFileListCount();
                break;
            }
            case 6: {
                if (searchResultElement.getRemoteFileListCount() == 0 && searchResultElement2.getRemoteFileListCount() == 0) {
                    String string = searchResultElement.getSingleRemoteFile().getMetaData();
                    String string2 = searchResultElement2.getSingleRemoteFile().getMetaData();
                    l = string == null || string2 == null ? -1L : (long)string.compareTo(string2);
                    break;
                }
                l = searchResultElement.getRemoteFileListCount() - searchResultElement2.getRemoteFileListCount();
                break;
            }
            case 7: {
                if (searchResultElement.getRemoteFileListCount() == 0 && searchResultElement2.getRemoteFileListCount() == 0) {
                    String string = searchResultElement.getSingleRemoteFile().getQueryHitHost().getVendor();
                    String string3 = searchResultElement2.getSingleRemoteFile().getQueryHitHost().getVendor();
                    l = string == null || string3 == null ? -1L : (long)string.compareTo(string3);
                    break;
                }
                l = searchResultElement.getRemoteFileListCount() - searchResultElement2.getRemoteFileListCount();
                break;
            }
            case 8: {
                if (searchResultElement.getRemoteFileListCount() == 0 && searchResultElement2.getRemoteFileListCount() == 0) {
                    l = searchResultElement.getSingleRemoteFile().getQueryHitHost().getHostSpeed() - searchResultElement2.getSingleRemoteFile().getQueryHitHost().getHostSpeed();
                    break;
                }
                l = searchResultElement.getRemoteFileListCount() - searchResultElement2.getRemoteFileListCount();
                break;
            }
            case 9: {
                if (searchResultElement.getRemoteFileListCount() == 0 && searchResultElement2.getRemoteFileListCount() == 0) {
                    l = searchResultElement.getSingleRemoteFile().getQueryHitHost().getHostRating() - searchResultElement2.getSingleRemoteFile().getQueryHitHost().getHostRating();
                    break;
                }
                l = searchResultElement.getRemoteFileListCount() - searchResultElement2.getRemoteFileListCount();
                break;
            }
            case 10: {
                if (searchResultElement.getRemoteFileListCount() == 0 && searchResultElement2.getRemoteFileListCount() == 0) {
                    l = searchResultElement.getSingleRemoteFile().getScore() - searchResultElement2.getSingleRemoteFile().getScore();
                    break;
                }
                l = searchResultElement.getRemoteFileListCount() - searchResultElement2.getRemoteFileListCount();
                break;
            }
            default: {
                l = 1L;
            }
        }
        if (l == 0L) {
            l = searchResultElement.hashCode() - searchResultElement2.hashCode();
        }
        long l2 = l = this.isSortedAscending ? l : -l;
        if (l < 0L) {
            return -1;
        }
        if (l > 0L) {
            return 1;
        }
        return 1;
    }
}

