/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs.library;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.TableModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.commons.lang.SystemUtils;
import phex.common.ServiceManager;
import phex.common.ThreadPool;
import phex.common.URN;
import phex.common.format.NumberFormatUtils;
import phex.event.ShareChangeListener;
import phex.gui.actions.FWAction;
import phex.gui.actions.GUIActionPerformer;
import phex.gui.common.BrowserLauncher;
import phex.gui.common.FWElegantPanel;
import phex.gui.common.FWPopupMenu;
import phex.gui.common.FWToolBar;
import phex.gui.common.FileDialogHandler;
import phex.gui.common.GUIRegistry;
import phex.gui.common.GUIUtils;
import phex.gui.common.table.FWSortedTableModel;
import phex.gui.common.table.FWTable;
import phex.gui.common.table.FWTableColumnModel;
import phex.gui.dialogs.ExportDialog;
import phex.gui.dialogs.FilterLibraryDialog;
import phex.gui.tabs.FWTab;
import phex.gui.tabs.library.LibraryNode;
import phex.gui.tabs.library.SharedFilesTableModel;
import phex.gui.tabs.library.SharingTreeModel;
import phex.gui.tabs.library.SharingTreeRenderer;
import phex.share.ShareFile;
import phex.share.ShareManager;
import phex.share.SharedDirectory;
import phex.share.SharedFilesService;
import phex.share.SharedResource;
import phex.utils.DirectoryOnlyFileFilter;
import phex.utils.Localizer;
import phex.utils.NLogger;
import phex.utils.SystemShellExecute;
import phex.utils.URLUtil;
import phex.xml.sax.gui.DGuiSettings;
import phex.xml.sax.gui.DTable;
import phex.xml.sax.gui.DTableColumnList;

public class LibraryTab
extends FWTab {
    private static final String SHARED_FILES_TABLE_IDENTIFIER = "SharedFilesTable";
    private JLabel sharedFilesLabel;
    private FWTable sharedFilesTable;
    private JTree mainTree;
    private SharingTreeModel sharingTreeModel;
    private FWPopupMenu fileTreePopup;
    private FWPopupMenu fileTablePopup;
    private JScrollPane sharedFilesTableScrollPane;
    private SharedFilesTableModel sharedFilesModel;
    private FWTableColumnModel sharedFilesColumnModel;
    private static final String ADD_SHARE_FOLDER_ACTION_KEY = "AddShareFolderAction";
    private static final String REMOVE_SHARE_FOLDER_ACTION_KEY = "RemoveShareFolderAction";
    private static final String RESCAN_ACTION_KEY = "RescanAction";
    private static final String VIEW_BITZI_ACTION_KEY = "ViewBitziTicketAction";
    private static final String EXPORT_ACTION_KEY = "ExportAction";
    private static final String FILTER_ACTION_KEY = "FilterAction";
    private static final String OPEN_FILE_ACTION_KEY = "OpenFileAction";
    private static final String EXPLORE_FOLDER_ACTION_KEY = "ExploreFolderAction";

    public LibraryTab() {
        super(1007, Localizer.getString("Library"), GUIRegistry.getInstance().getIconFactory().getIcon("Library"), Localizer.getString("TTTLibrary"), Localizer.getChar("LibraryMnemonic"), KeyStroke.getKeyStroke(Localizer.getString("LibraryAccelerator")), 4);
    }

    public void initComponent(DGuiSettings dGuiSettings) {
        CellConstraints cellConstraints = new CellConstraints();
        FormLayout formLayout = new FormLayout("2dlu, fill:d:grow, 2dlu", "2dlu, fill:p:grow, 2dlu");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout, this);
        JPanel jPanel = new JPanel();
        FWElegantPanel fWElegantPanel = new FWElegantPanel(Localizer.getString("Library"), jPanel);
        panelBuilder.add((Component)fWElegantPanel, cellConstraints.xy(2, 2));
        FormLayout formLayout2 = new FormLayout("fill:d:grow", "fill:d:grow");
        PanelBuilder panelBuilder2 = new PanelBuilder(formLayout2, jPanel);
        MouseHandler mouseHandler = new MouseHandler();
        JPanel jPanel2 = this.createTreePanel(mouseHandler);
        JPanel jPanel3 = this.createTablePanel(dGuiSettings, mouseHandler);
        JSplitPane jSplitPane = new JSplitPane(1, jPanel2, jPanel3);
        jSplitPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jSplitPane.setDividerSize(4);
        jSplitPane.setOneTouchExpandable(false);
        panelBuilder2.add((Component)jSplitPane, cellConstraints.xy(1, 1));
        this.sharedFilesLabel = new JLabel(" ");
        this.sharedFilesLabel.setHorizontalAlignment(4);
        fWElegantPanel.addHeaderPanelComponent(this.sharedFilesLabel, "East");
        ShareManager.getInstance().getSharedFilesService().addSharedFilesChangeListener(new SharedFilesChangeHandler());
        this.fileTreePopup = new FWPopupMenu();
        this.fileTablePopup = new FWPopupMenu();
        FWAction fWAction = this.getTabAction(ADD_SHARE_FOLDER_ACTION_KEY);
        this.fileTreePopup.addAction(fWAction);
        fWAction = this.getTabAction(REMOVE_SHARE_FOLDER_ACTION_KEY);
        this.fileTreePopup.addAction(fWAction);
        if (SystemUtils.IS_OS_WINDOWS || SystemUtils.IS_OS_MAC_OSX) {
            fWAction = this.getTabAction(EXPLORE_FOLDER_ACTION_KEY);
            this.fileTreePopup.addAction(fWAction);
        }
        fWAction = this.getTabAction(OPEN_FILE_ACTION_KEY);
        this.fileTablePopup.addAction(fWAction);
        fWAction = this.getTabAction(VIEW_BITZI_ACTION_KEY);
        this.fileTablePopup.addAction(fWAction);
        this.fileTablePopup.addSeparator();
        this.fileTreePopup.addSeparator();
        fWAction = this.getTabAction(RESCAN_ACTION_KEY);
        this.fileTablePopup.addAction(fWAction);
        this.fileTreePopup.addAction(fWAction);
        fWAction = this.getTabAction(EXPORT_ACTION_KEY);
        this.fileTablePopup.addAction(fWAction);
        this.fileTreePopup.addAction(fWAction);
        fWAction = this.getTabAction(FILTER_ACTION_KEY);
        this.fileTablePopup.addAction(fWAction);
        this.fileTreePopup.addAction(fWAction);
    }

    private JPanel createTreePanel(MouseHandler mouseHandler) {
        JPanel jPanel = new JPanel();
        CellConstraints cellConstraints = new CellConstraints();
        FormLayout formLayout = new FormLayout("fill:d:grow", "fill:d:grow, 1dlu, p");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout, jPanel);
        this.sharingTreeModel = new SharingTreeModel();
        this.mainTree = new JTree(this.sharingTreeModel);
        this.mainTree.setMinimumSize(new Dimension(0, 0));
        this.mainTree.setRowHeight(0);
        this.mainTree.setCellRenderer(new SharingTreeRenderer());
        this.mainTree.addMouseListener(mouseHandler);
        this.mainTree.getSelectionModel().addTreeSelectionListener(new SelectionHandler());
        ToolTipManager.sharedInstance().registerComponent(this.mainTree);
        TreeNode treeNode = (TreeNode)this.sharingTreeModel.getRoot();
        int n = treeNode.getChildCount();
        for (int i = 0; i < n; ++i) {
            this.mainTree.expandPath(new TreePath(new Object[]{treeNode, treeNode.getChildAt(i)}));
        }
        JScrollPane jScrollPane = new JScrollPane(this.mainTree);
        panelBuilder.add((Component)jScrollPane, cellConstraints.xywh(1, 1, 1, 1));
        FWToolBar fWToolBar = new FWToolBar(0);
        fWToolBar.setBorderPainted(false);
        fWToolBar.setFloatable(false);
        panelBuilder.add((Component)fWToolBar, cellConstraints.xy(1, 3));
        FWAction fWAction = new AddShareFolderAction();
        this.addTabAction(ADD_SHARE_FOLDER_ACTION_KEY, fWAction);
        fWToolBar.addAction(fWAction);
        fWAction = new RemoveShareFolderAction();
        this.addTabAction(REMOVE_SHARE_FOLDER_ACTION_KEY, fWAction);
        fWToolBar.addAction(fWAction);
        if (SystemUtils.IS_OS_WINDOWS || SystemUtils.IS_OS_MAC_OSX) {
            fWAction = new ExploreFolderAction();
            this.addTabAction(EXPLORE_FOLDER_ACTION_KEY, fWAction);
        }
        return jPanel;
    }

    private JPanel createTablePanel(DGuiSettings dGuiSettings, MouseHandler mouseHandler) {
        JPanel jPanel = new JPanel();
        CellConstraints cellConstraints = new CellConstraints();
        FormLayout formLayout = new FormLayout("fill:d:grow", "fill:d:grow, 1dlu, p");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout, jPanel);
        this.sharedFilesModel = new SharedFilesTableModel();
        DTable dTable = GUIUtils.getDGuiTableByIdentifier(dGuiSettings, SHARED_FILES_TABLE_IDENTIFIER);
        this.buildSharedFilesTableColumnModel(dTable);
        this.sharedFilesTable = new FWTable((TableModel)new FWSortedTableModel(this.sharedFilesModel), this.sharedFilesColumnModel);
        this.sharedFilesTable.activateAllHeaderActions();
        this.sharedFilesTable.setAutoResizeMode(0);
        this.sharedFilesTable.addMouseListener(mouseHandler);
        this.sharedFilesTable.getSelectionModel().addListSelectionListener(new SelectionHandler());
        this.sharedFilesTableScrollPane = FWTable.createFWTableScrollPane(this.sharedFilesTable);
        panelBuilder.add((Component)this.sharedFilesTableScrollPane, cellConstraints.xy(1, 1));
        FWToolBar fWToolBar = new FWToolBar(0);
        fWToolBar.setBorderPainted(false);
        fWToolBar.setFloatable(false);
        panelBuilder.add((Component)fWToolBar, cellConstraints.xy(1, 3));
        FWAction fWAction = new OpenFileAction();
        this.addTabAction(OPEN_FILE_ACTION_KEY, fWAction);
        fWToolBar.addAction(fWAction);
        fWAction = new ViewBitziTicketAction();
        this.addTabAction(VIEW_BITZI_ACTION_KEY, fWAction);
        fWToolBar.addAction(fWAction);
        fWToolBar.addSeparator();
        fWAction = new RescanAction();
        this.addTabAction(RESCAN_ACTION_KEY, fWAction);
        fWToolBar.addAction(fWAction);
        fWAction = new ExportAction();
        this.addTabAction(EXPORT_ACTION_KEY, fWAction);
        fWToolBar.addAction(fWAction);
        fWAction = new FilterAction();
        this.addTabAction(FILTER_ACTION_KEY, fWAction);
        fWToolBar.addAction(fWAction);
        return jPanel;
    }

    public void updateUI() {
        super.updateUI();
        if (this.sharedFilesTableScrollPane != null) {
            FWTable.updateFWTableScrollPane(this.sharedFilesTableScrollPane);
        }
    }

    private LibraryNode getSelectedTreeComponent() {
        TreePath treePath = this.mainTree.getSelectionPath();
        if (treePath == null) {
            return null;
        }
        LibraryNode libraryNode = (LibraryNode)treePath.getLastPathComponent();
        return libraryNode;
    }

    private void buildSharedFilesTableColumnModel(DTable dTable) {
        int[] nArray = SharedFilesTableModel.getColumnIdArray();
        DTableColumnList dTableColumnList = null;
        if (dTable != null) {
            dTableColumnList = dTable.getTableColumnList();
        }
        this.sharedFilesColumnModel = new FWTableColumnModel(this.sharedFilesModel, nArray, dTableColumnList);
    }

    public void appendDGuiSettings(DGuiSettings dGuiSettings) {
        super.appendDGuiSettings(dGuiSettings);
        DTableColumnList dTableColumnList = this.sharedFilesColumnModel.createDGuiTableColumnList();
        DTable dTable = new DTable();
        dTable.setTableColumnList(dTableColumnList);
        dTable.setTableIdentifier(SHARED_FILES_TABLE_IDENTIFIER);
        dGuiSettings.getTableList().getTableList().add(dTable);
    }

    private class MouseHandler
    extends MouseAdapter
    implements MouseListener {
        private MouseHandler() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.popupMenu((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.popupMenu((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
            }
        }

        private void popupMenu(Component component, int n, int n2) {
            if (component == LibraryTab.this.mainTree) {
                LibraryTab.this.refreshTabActions();
                LibraryTab.this.fileTreePopup.show(component, n, n2);
            } else if (component == LibraryTab.this.sharedFilesTable) {
                LibraryTab.this.refreshTabActions();
                LibraryTab.this.fileTablePopup.show(component, n, n2);
            }
        }
    }

    private class SharedFilesChangeHandler
    implements ShareChangeListener {
        private SharedFilesChangeHandler() {
        }

        public void sharedDirectoriesChanged() {
            this.updateLabel();
        }

        private void updateLabel() {
            SharedFilesService sharedFilesService = ShareManager.getInstance().getSharedFilesService();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append('(');
            stringBuffer.append(sharedFilesService.getFileCount());
            stringBuffer.append(" / ");
            stringBuffer.append(NumberFormatUtils.formatSignificantByteSize((long)sharedFilesService.getTotalFileSizeInKb() * 1024L)).append(')');
            LibraryTab.this.sharedFilesLabel.setText(stringBuffer.toString());
        }
    }

    private class SelectionHandler
    implements ListSelectionListener,
    TreeSelectionListener {
        private SelectionHandler() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                LibraryTab.this.refreshTabActions();
            }
        }

        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            Object object = LibraryTab.this.sharingTreeModel.getRoot();
            Object object2 = treeSelectionEvent.getPath().getLastPathComponent();
            if (object2 == object) {
                EventQueue.invokeLater(new Runnable(this, object){
                    private final /* synthetic */ Object val$treeRoot;
                    private final /* synthetic */ SelectionHandler this$1;
                    {
                        this.this$1 = selectionHandler;
                        this.val$treeRoot = object;
                    }

                    public void run() {
                        LibraryTab.access$600(SelectionHandler.access$900(this.this$1)).setSelectionPath(new TreePath(new Object[]{this.val$treeRoot, LibraryTab.access$300(SelectionHandler.access$900(this.this$1)).getChild(this.val$treeRoot, 0)}));
                    }
                });
                return;
            }
            ThreadPool.getInstance().addJob(new Runnable(this, object2){
                private final /* synthetic */ Object val$lastPathComponent;
                private final /* synthetic */ SelectionHandler this$1;
                {
                    this.this$1 = selectionHandler;
                    this.val$lastPathComponent = object;
                }

                public void run() {
                    if (this.val$lastPathComponent instanceof LibraryNode) {
                        LibraryTab.access$500(SelectionHandler.access$900(this.this$1)).setDisplayDirectory(((LibraryNode)this.val$lastPathComponent).getSystemFile());
                    } else {
                        LibraryTab.access$500(SelectionHandler.access$900(this.this$1)).setDisplayDirectory(null);
                    }
                }
            }, "LibraryTableUpdate");
            LibraryTab.this.refreshTabActions();
        }

        static /* synthetic */ LibraryTab access$900(SelectionHandler selectionHandler) {
            return selectionHandler.LibraryTab.this;
        }
    }

    private class RemoveShareFolderAction
    extends FWAction {
        RemoveShareFolderAction() {
            super(Localizer.getString("LibraryTab_StopShare"), GUIRegistry.getInstance().getIconFactory().getIcon("ShareFolderClear"), Localizer.getString("LibraryTab_TTTStopShare"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TreePath treePath = LibraryTab.this.mainTree.getSelectionPath();
            if (treePath == null) {
                return;
            }
            Object object = treePath.getLastPathComponent();
            if (!(object instanceof LibraryNode)) {
                return;
            }
            File file = ((LibraryNode)object).getSystemFile();
            if (file == null) {
                return;
            }
            Runnable runnable = new Runnable(this, file){
                private final /* synthetic */ File val$file;
                private final /* synthetic */ RemoveShareFolderAction this$1;
                {
                    this.this$1 = removeShareFolderAction;
                    this.val$file = file;
                }

                public void run() {
                    RemoveShareFolderAction.access$800(this.this$1, this.val$file);
                    GUIActionPerformer.rescanSharedFiles();
                }
            };
            ThreadPool.getInstance().addJob(runnable, LibraryTab.REMOVE_SHARE_FOLDER_ACTION_KEY);
            this.refreshActionState();
        }

        private void stopShareDirRecursive(File file) {
            if (!file.isDirectory()) {
                return;
            }
            ServiceManager.sCfg.sharedDirectoriesSet.remove(file.getAbsolutePath());
            SharedFilesService sharedFilesService = ShareManager.getInstance().getSharedFilesService();
            SharedDirectory sharedDirectory = sharedFilesService.getSharedDirectory(file);
            if (sharedDirectory == null) {
                return;
            }
            File[] fileArray = file.listFiles(new DirectoryOnlyFileFilter());
            for (int i = 0; i < fileArray.length; ++i) {
                this.stopShareDirRecursive(fileArray[i]);
            }
        }

        public void refreshActionState() {
            TreePath treePath = LibraryTab.this.mainTree.getSelectionPath();
            if (treePath == null) {
                this.setEnabled(false);
                return;
            }
            Object object = treePath.getLastPathComponent();
            if (!(object instanceof LibraryNode)) {
                this.setEnabled(false);
                return;
            }
            File file = ((LibraryNode)object).getSystemFile();
            if (file == null) {
                this.setEnabled(false);
                return;
            }
            this.setEnabled(true);
        }

        static /* synthetic */ void access$800(RemoveShareFolderAction removeShareFolderAction, File file) {
            removeShareFolderAction.stopShareDirRecursive(file);
        }
    }

    private class AddShareFolderAction
    extends FWAction {
        AddShareFolderAction() {
            super(Localizer.getString("LibraryTab_Share"), GUIRegistry.getInstance().getIconFactory().getIcon("ShareFolder"), Localizer.getString("LibraryTab_TTTShare"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                File[] fileArray;
                File file = null;
                TreePath treePath = LibraryTab.this.mainTree.getSelectionPath();
                if (treePath != null && (fileArray = treePath.getLastPathComponent()) instanceof LibraryNode) {
                    file = ((LibraryNode)fileArray).getSystemFile();
                }
                if ((fileArray = FileDialogHandler.openMultipleDirectoryChooser(LibraryTab.this, Localizer.getString("LibraryTab_SelectDirectoryToShare"), Localizer.getString("LibraryTab_Select"), Localizer.getChar("LibraryTab_SelectMnemonic"), file, Localizer.getString("LibraryTab_CopyrightWarnTitle"), Localizer.getString("LibraryTab_CopyrightWarnMessage"))) == null) {
                    return;
                }
                Runnable runnable = new Runnable(this, fileArray){
                    private final /* synthetic */ File[] val$files;
                    private final /* synthetic */ AddShareFolderAction this$1;
                    {
                        this.this$1 = addShareFolderAction;
                        this.val$files = fileArray;
                    }

                    public void run() {
                        try {
                            for (int i = 0; i < this.val$files.length; ++i) {
                                if (this.val$files[i] == null) continue;
                                AddShareFolderAction.access$700(this.this$1, this.val$files[i]);
                            }
                            GUIActionPerformer.rescanSharedFiles();
                        }
                        catch (Throwable throwable) {
                            NLogger.error("USER_INTERFACE", (Object)throwable, throwable);
                        }
                    }
                };
                ThreadPool.getInstance().addJob(runnable, LibraryTab.ADD_SHARE_FOLDER_ACTION_KEY);
            }
            catch (Throwable throwable) {
                NLogger.error("USER_INTERFACE", (Object)throwable, throwable);
            }
        }

        public void refreshActionState() {
        }

        private void shareDirRecursive(File file) {
            if (!file.isDirectory()) {
                return;
            }
            ServiceManager.sCfg.sharedDirectoriesSet.add(file.getAbsolutePath());
            File[] fileArray = file.listFiles(new DirectoryOnlyFileFilter());
            for (int i = 0; i < fileArray.length; ++i) {
                this.shareDirRecursive(fileArray[i]);
            }
        }

        static /* synthetic */ void access$700(AddShareFolderAction addShareFolderAction, File file) {
            addShareFolderAction.shareDirRecursive(file);
        }
    }

    private class ExploreFolderAction
    extends FWAction {
        ExploreFolderAction() {
            super(Localizer.getString("LibraryTab_Explore"), GUIRegistry.getInstance().getIconFactory().getIcon("Explore"), Localizer.getString("LibraryTab_TTTExplore"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TreePath treePath = LibraryTab.this.mainTree.getSelectionPath();
            if (treePath == null) {
                return;
            }
            Object object = treePath.getLastPathComponent();
            if (!(object instanceof LibraryNode)) {
                return;
            }
            File file = ((LibraryNode)object).getSystemFile();
            if (file == null) {
                return;
            }
            try {
                SystemShellExecute.exploreFolder(file);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void refreshActionState() {
            TreePath treePath = LibraryTab.this.mainTree.getSelectionPath();
            if (treePath == null) {
                this.setEnabled(false);
                return;
            }
            Object object = treePath.getLastPathComponent();
            if (!(object instanceof LibraryNode)) {
                this.setEnabled(false);
                return;
            }
            File file = ((LibraryNode)object).getSystemFile();
            if (file == null) {
                this.setEnabled(false);
                return;
            }
            this.setEnabled(true);
        }
    }

    private class FilterAction
    extends FWAction {
        public FilterAction() {
            super(Localizer.getString("LibraryTab_Filter"), GUIRegistry.getInstance().getIconFactory().getIcon("Filter"), Localizer.getString("LibraryTab_TTTFilter"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FilterLibraryDialog filterLibraryDialog = new FilterLibraryDialog();
            filterLibraryDialog.setVisible(true);
        }

        public void refreshActionState() {
        }
    }

    private class ViewBitziTicketAction
    extends FWAction {
        public ViewBitziTicketAction() {
            super(Localizer.getString("ViewBitziTicket"), GUIRegistry.getInstance().getIconFactory().getIcon("Bitzi"), Localizer.getString("TTTViewBitziTicket"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            block4: {
                int n = LibraryTab.this.sharedFilesTable.getSelectedRow();
                n = LibraryTab.this.sharedFilesTable.convertRowIndexToModel(n);
                if (n < 0) {
                    return;
                }
                Object object = LibraryTab.this.sharedFilesModel.getValueAt(n, 0);
                if (object == null || !(object instanceof ShareFile)) {
                    return;
                }
                ShareFile shareFile = (ShareFile)object;
                URN uRN = shareFile.getURN();
                String string = URLUtil.buildBitziLookupURL(uRN);
                try {
                    BrowserLauncher.openURL(string);
                }
                catch (IOException iOException) {
                    NLogger.warn("USER_INTERFACE", (Object)iOException);
                    Object[] objectArray = new Object[]{Localizer.getString("Yes"), Localizer.getString("No")};
                    int n2 = JOptionPane.showOptionDialog(LibraryTab.this, Localizer.getString("FailedToLaunchBrowserURLInClipboard"), Localizer.getString("FailedToLaunchBrowser"), 0, 2, null, objectArray, Localizer.getString("Yes"));
                    if (n2 != 0) break block4;
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(string), null);
                }
            }
        }

        public void refreshActionState() {
            int n = LibraryTab.this.sharedFilesTable.getSelectedRow();
            n = LibraryTab.this.sharedFilesTable.convertRowIndexToModel(n);
            if (n < 0) {
                this.setEnabled(false);
                return;
            }
            Object object = LibraryTab.this.sharedFilesModel.getValueAt(n, 0);
            if (object == null || !(object instanceof ShareFile)) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
        }
    }

    private class OpenFileAction
    extends FWAction {
        OpenFileAction() {
            super(Localizer.getString("LibraryTab_OpenFile"), GUIRegistry.getInstance().getIconFactory().getIcon("Open"), Localizer.getString("LibraryTab_TTTOpenFile"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                File file;
                Object object;
                int n = LibraryTab.this.sharedFilesTable.getSelectedRow();
                n = LibraryTab.this.sharedFilesTable.convertRowIndexToModel(n);
                if (n < 0) {
                    return;
                }
                Object object2 = LibraryTab.this.sharedFilesModel.getValueAt(n, 0);
                if (object2 == null) {
                    return;
                }
                if (object2 instanceof ShareFile) {
                    object = (ShareFile)object2;
                    file = ((SharedResource)object).getSystemFile();
                } else if (object2 instanceof File) {
                    file = (File)object2;
                } else {
                    return;
                }
                object = new Runnable(){

                    public void run() {
                        try {
                            SystemShellExecute.launchFile(file);
                        }
                        catch (IOException iOException) {
                        }
                        catch (Throwable throwable) {
                            NLogger.error("USER_INTERFACE", (Object)throwable, throwable);
                        }
                    }
                };
                ThreadPool.getInstance().addJob((Runnable)object, "SystenShellExecute");
            }
            catch (Throwable throwable) {
                NLogger.error("USER_INTERFACE", (Object)throwable, throwable);
            }
        }

        public void refreshActionState() {
            int n = LibraryTab.this.sharedFilesTable.getSelectedRow();
            n = LibraryTab.this.sharedFilesTable.convertRowIndexToModel(n);
            if (n < 0) {
                this.setEnabled(false);
                return;
            }
            Object object = LibraryTab.this.sharedFilesModel.getValueAt(n, 0);
            if (object == null) {
                this.setEnabled(false);
                return;
            }
            if (object instanceof ShareFile || object instanceof File) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }
    }

    private class ExportAction
    extends FWAction {
        ExportAction() {
            super(Localizer.getString("LibraryTab_Export"), GUIRegistry.getInstance().getIconFactory().getIcon("Export"), Localizer.getString("LibraryTab_TTTExport"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ExportDialog exportDialog = new ExportDialog();
            exportDialog.setVisible(true);
        }

        public void refreshActionState() {
        }
    }

    class RescanAction
    extends FWAction {
        RescanAction() {
            super(Localizer.getString("LibraryTab_Rescan"), GUIRegistry.getInstance().getIconFactory().getIcon("Refresh"), Localizer.getString("LibraryTab_TTTRescan"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            LibraryTab.this.sharingTreeModel.updateFileSystem();
            GUIActionPerformer.rescanSharedFiles();
        }

        public void refreshActionState() {
        }
    }
}

