/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs.library;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.filechooser.FileSystemView;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import phex.event.ShareChangeListener;
import phex.share.ShareManager;
import phex.utils.DirectoryOnlyFileFilter;
import sun.awt.shell.ShellFolder;

public class FileSystemTreeModel
implements TreeModel {
    protected EventListenerList listenerList = new EventListenerList();
    private FileFilter dirFilter = new DirectoryOnlyFileFilter();
    private File[] fsRoots;
    private Object root = new String("ROOT");
    private HashMap fsTree = new HashMap();
    FileSystemView fsv;

    public FileSystemTreeModel() {
        this.updateFileSystem();
        FileSystemChangeListener fileSystemChangeListener = new FileSystemChangeListener();
        ShareManager.getInstance().getSharedFilesService().addSharedFilesChangeListener(fileSystemChangeListener);
    }

    public void updateFileSystem() {
        this.fsv = FileSystemView.getFileSystemView();
        this.fsRoots = this.fsv.getRoots();
        this.fsTree.clear();
    }

    public Object getRoot() {
        return this.root;
    }

    public Object getChild(Object object, int n) {
        System.out.println("getChild " + object + " " + n);
        if (object.equals(this.root)) {
            return this.fsRoots[n];
        }
        FolderInfo folderInfo = this.getFolderInfo((File)object);
        return folderInfo.getChilds()[n];
    }

    public int getChildCount(Object object) {
        System.out.println("getChildCount " + object);
        if (object.equals(this.root)) {
            return this.fsRoots.length;
        }
        FolderInfo folderInfo = this.getFolderInfo((File)object);
        return folderInfo.getChilds().length;
    }

    public boolean isLeaf(Object object) {
        return false;
    }

    public void valueForPathChanged(TreePath treePath, Object object) {
        System.out.println("valueForPathChanged");
    }

    public int getIndexOfChild(Object object, Object object2) {
        System.out.println("getIndexOfChild");
        return 0;
    }

    public void addTreeModelListener(TreeModelListener treeModelListener) {
        this.listenerList.add(TreeModelListener.class, treeModelListener);
    }

    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.listenerList.remove(TreeModelListener.class, treeModelListener);
    }

    private void fireTreeStructureChanged() {
        Object[] objectArray = this.listenerList.getListenerList();
        TreeModelEvent treeModelEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$javax$swing$event$TreeModelListener == null ? FileSystemTreeModel.class$("javax.swing.event.TreeModelListener") : class$javax$swing$event$TreeModelListener)) continue;
            if (treeModelEvent == null) {
                treeModelEvent = new TreeModelEvent((Object)this, (TreePath)null);
            }
            ((TreeModelListener)objectArray[i + 1]).treeStructureChanged(treeModelEvent);
        }
    }

    private FolderInfo getFolderInfo(File file) {
        FolderInfo folderInfo = (FolderInfo)this.fsTree.get(file);
        if (folderInfo != null && folderInfo.timestamp < System.currentTimeMillis() - 30000L) {
            return folderInfo;
        }
        folderInfo = new FolderInfo();
        folderInfo.file = file;
        folderInfo.timestamp = System.currentTimeMillis();
        this.fsTree.put(file, folderInfo);
        return folderInfo;
    }

    private class FolderInfo {
        private File file;
        private File[] childs;
        long timestamp;

        private FolderInfo() {
        }

        public File[] getChilds() {
            System.out.println("---");
            System.out.println(((ShellFolder)this.file).getPath());
            System.out.println(((ShellFolder)this.file).isFileSystem());
            System.out.println(ShellFolder.isComputerNode(this.file));
            System.out.println(ShellFolder.isFileSystemRoot(this.file));
            System.out.println("---");
            if (this.childs != null) {
                return this.childs;
            }
            File[] fileArray = FileSystemTreeModel.this.fsv.getFiles(this.file, false);
            ArrayList<File> arrayList = new ArrayList<File>();
            for (int i = 0; i < fileArray.length; ++i) {
                if (!FileSystemTreeModel.this.fsv.isTraversable(fileArray[i]).booleanValue()) continue;
                arrayList.add(fileArray[i]);
            }
            this.childs = arrayList.toArray(new File[arrayList.size()]);
            return this.childs;
        }
    }

    public class FileSystemChangeListener
    implements ShareChangeListener {
        public void sharedDirectoriesChanged() {
            FileSystemTreeModel.this.fireTreeStructureChanged();
        }
    }
}

