/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs.library;

import java.io.File;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.filechooser.FileSystemView;
import org.apache.commons.collections.map.LRUMap;
import phex.gui.common.GUIRegistry;
import phex.gui.common.IconFactory;
import phex.gui.common.ImageFilterUtils;
import phex.gui.renderer.FWTableCellRenderer;
import phex.share.ShareFile;
import phex.utils.NLogger;

public class FileSystemTableCellRenderer
extends FWTableCellRenderer {
    private Icon defaultIcon;
    private Icon defaultGrayIcon;
    private FileSystemView fsv = FileSystemView.getFileSystemView();
    private Map shareFileIconMap = new LRUMap(100);
    private Map grayMap = new LRUMap(100);

    public FileSystemTableCellRenderer() {
        IconFactory iconFactory = GUIRegistry.getInstance().getIconFactory();
        this.defaultIcon = iconFactory.getIcon("File");
        this.defaultGrayIcon = ImageFilterUtils.createGrayIcon(iconFactory.getIcon("File"));
    }

    protected void setValue(Object object) {
        try {
            if (object instanceof ShareFile) {
                ShareFile shareFile = (ShareFile)object;
                File file = shareFile.getSystemFile();
                if (file.exists()) {
                    Icon icon = (Icon)this.shareFileIconMap.get(shareFile);
                    if (icon == null) {
                        icon = this.fsv.getSystemIcon(file);
                        this.shareFileIconMap.put(shareFile, icon);
                    }
                    this.setIcon(icon);
                } else {
                    this.setIcon(this.defaultIcon);
                }
                this.setText(shareFile.getFileName());
                return;
            }
            if (object instanceof File) {
                File file = (File)object;
                this.setText(file.getName());
                if (file.exists()) {
                    Icon icon = this.fsv.getSystemIcon(file);
                    Icon icon2 = this.lookupGrayIcon(icon);
                    if (icon2 == null) {
                        icon2 = ImageFilterUtils.createGrayIcon(icon);
                        this.bufferGrayIcon(icon, icon2);
                    }
                    this.setIcon(icon2);
                } else {
                    this.setIcon(this.defaultGrayIcon);
                }
                return;
            }
            this.setText(object.toString());
            this.setIcon(null);
        }
        catch (Throwable throwable) {
            NLogger.error("USER_INTERFACE", throwable);
        }
    }

    private Icon lookupGrayIcon(Icon icon) {
        if (icon instanceof ImageIcon) {
            return (Icon)this.grayMap.get(((ImageIcon)icon).getImage());
        }
        return (Icon)this.grayMap.get(icon);
    }

    private void bufferGrayIcon(Icon icon, Icon icon2) {
        if (icon instanceof ImageIcon) {
            this.grayMap.put(((ImageIcon)icon).getImage(), icon2);
        } else {
            this.grayMap.put(icon, icon2);
        }
    }
}

