/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.renderer;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import phex.gui.common.table.FWTable;
import phex.host.Host;
import phex.host.HostManager;
import phex.host.NetworkHostsContainer;

public class NetworkRowRenderer
implements TableCellRenderer {
    private static final Color FAILED_COLOR = Color.gray;
    private static final Color CONNECTING_COLOR = new Color(127, 0, 0);
    private static final Color CONNECTED_COLOR = new Color(0, 127, 0);
    private NetworkHostsContainer hostsContainer;

    public NetworkRowRenderer() {
        HostManager hostManager = HostManager.getInstance();
        this.hostsContainer = hostManager.getNetworkHostsContainer();
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        TableCellRenderer tableCellRenderer = jTable.getDefaultRenderer(jTable.getColumnClass(n2));
        Component component = tableCellRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        FWTable fWTable = (FWTable)jTable;
        component.setForeground(jTable.getSelectionForeground());
        if (n < this.hostsContainer.getNetworkHostCount()) {
            int n3 = fWTable.convertRowIndexToModel(n);
            Host host = this.hostsContainer.getNetworkHostAt(n3);
            if (host == null) {
                return component;
            }
            switch (host.getStatus()) {
                case 0: {
                    break;
                }
                case 1: 
                case 5: {
                    component.setForeground(FAILED_COLOR);
                    break;
                }
                case 2: 
                case 3: {
                    component.setForeground(CONNECTING_COLOR);
                    break;
                }
                case 4: {
                    component.setForeground(CONNECTED_COLOR);
                }
            }
        }
        return component;
    }
}

