/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.models;

import java.util.Comparator;
import javax.swing.event.TableModelEvent;
import phex.event.SecurityRulesChangeListener;
import phex.gui.common.GUIRegistry;
import phex.gui.common.LazyEventQueue;
import phex.gui.common.table.FWSortableTableModel;
import phex.gui.comparator.IPComparator;
import phex.gui.renderer.DateCellRenderer;
import phex.security.IPAccessRule;
import phex.security.PhexSecurityManager;
import phex.security.SecurityRule;
import phex.utils.Localizer;

public class SecurityTableModel
extends FWSortableTableModel
implements SecurityRulesChangeListener {
    private static final int ADDRESS_COLUMN_ID = 1001;
    private static final int TYPE_COLUMN_ID = 1002;
    private static final int EXPIRES_COLUMN_ID = 1003;
    private static final int TRIGGER_COUNT_COLUMN_ID = 1004;
    private static final int DESCRIPTION_COLUMN_ID = 1005;
    private static final int ADDRESS_MODEL_INDEX = 0;
    private static final int TYPE_MODEL_INDEX = 1;
    private static final int EXPIRES_MODEL_INDEX = 2;
    private static final int TRIGGER_COUNT_MODEL_INDEX = 3;
    private static final int DESCRIPTION_MODEL_INDEX = 4;
    private static String[] tableColumns = new String[]{Localizer.getString("Address"), Localizer.getString("Type"), Localizer.getString("Expires"), Localizer.getString("TriggerCount"), Localizer.getString("Description")};
    private static Class[] tableClasses = new Class[]{String.class, String.class, DateCellRenderer.class, Integer.class, String.class};
    private PhexSecurityManager securityMgr;
    private LazyEventQueue lazyEventQueue = GUIRegistry.getInstance().getLazyEventQueue();

    public SecurityTableModel() {
        super(tableColumns, tableClasses);
        this.securityMgr = PhexSecurityManager.getInstance();
        this.securityMgr.addSecurityRuleChangeListener(this);
    }

    public int getRowCount() {
        return this.securityMgr.getIPAccessRuleCount();
    }

    public Object getValueAt(int n, int n2) {
        IPAccessRule iPAccessRule = this.securityMgr.getIPAccessRule(n);
        if (iPAccessRule == null) {
            this.fireTableRowsDeleted(n, n);
            return "";
        }
        switch (n2) {
            case 0: {
                return iPAccessRule.getAddressString();
            }
            case 1: {
                if (iPAccessRule.isDenyingRule()) {
                    return Localizer.getString("Deny");
                }
                return Localizer.getString("Accept");
            }
            case 2: {
                return iPAccessRule.getExpiryDate();
            }
            case 3: {
                return iPAccessRule.getTriggerCountObject();
            }
            case 4: {
                return iPAccessRule.getDescription();
            }
        }
        return "";
    }

    public Comparator getColumnComparator(int n) {
        switch (n) {
            case 0: {
                return new IPComparator();
            }
        }
        return null;
    }

    public Object getComparableValueAt(int n, int n2) {
        switch (n2) {
            case 0: {
                IPAccessRule iPAccessRule = this.securityMgr.getIPAccessRule(n);
                if (iPAccessRule == null) {
                    return new Long(Long.MIN_VALUE);
                }
                return iPAccessRule.getHostIP();
            }
        }
        return this.getValueAt(n, n2);
    }

    public int mapColumnIDToModelIndex(int n) {
        switch (n) {
            case 1001: {
                return 0;
            }
            case 1002: {
                return 1;
            }
            case 1003: {
                return 2;
            }
            case 1004: {
                return 3;
            }
            case 1005: {
                return 4;
            }
        }
        return -1;
    }

    public boolean isColumnHideable(int n) {
        return n != 1001;
    }

    public static int[] getColumnIdArray() {
        int[] nArray = new int[]{1001, 1002, 1003, 1004, 1005};
        return nArray;
    }

    public void securityRuleChanged(int n) {
        this.lazyEventQueue.addTableModelEvent(new TableModelEvent(this, n, n, -1, 0));
    }

    public void securityRuleAdded(SecurityRule securityRule, int n) {
        this.fireTableChanged(new TableModelEvent(this, n, n, -1, 1));
    }

    public void securityRuleRemoved(int n) {
        this.fireTableChanged(new TableModelEvent(this, n, n, -1, -1));
    }
}

