/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.macosx;

import java.awt.EventQueue;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import phex.common.URN;
import phex.download.MagnetData;
import phex.download.swarming.SwarmingManager;

public final class GURLHandler {
    private static final GURLHandler INSTANCE = new GURLHandler();
    private boolean isRegistered = false;

    private GURLHandler() throws UnsatisfiedLinkError {
    }

    public static GURLHandler getInstance() {
        return INSTANCE;
    }

    private void callback(final String string) {
        if (!string.startsWith("magnet")) {
            return;
        }
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    URI uRI = new URI(string, true);
                    MagnetData magnetData = MagnetData.parseFromURI(uRI);
                    URN uRN = MagnetData.lookupSHA1URN(magnetData);
                    SwarmingManager swarmingManager = SwarmingManager.getInstance();
                    if (!swarmingManager.isURNDownloaded(uRN)) {
                        swarmingManager.addFileToDownload(uRI);
                    }
                }
                catch (URIException uRIException) {
                    return;
                }
            }
        };
        EventQueue.invokeLater(runnable);
    }

    public void register() {
        if (!this.isRegistered && this.InstallEventHandler() == 0) {
            this.isRegistered = true;
        }
    }

    protected void finalize() throws Throwable {
        if (this.isRegistered) {
            this.RemoveEventHandler();
        }
    }

    private final synchronized native int InstallEventHandler();

    private final synchronized native int RemoveEventHandler();
}

