/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.dialogs.options;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import phex.common.ServiceManager;
import phex.gui.common.GUIUtils;
import phex.gui.common.IntegerTextField;
import phex.gui.dialogs.options.OptionsSettingsPane;
import phex.utils.Localizer;

public class SharingPane
extends OptionsSettingsPane {
    private static final String SIMULTANEOUS_UPLOADS_KEY = "SimultaneousUploads";
    private static final String UPLOADS_PER_HOST_KEY = "UploadsPerHost";
    private static final String RETURNED_SEARCH_LIMIT_KEY = "ReturnedSearchLimit";
    private static final String QUEUE_LIMIT_KEY = "QueueLimit";
    private static final String MIN_POLL_TIME_KEY = "UploadQueueMinPollTime";
    private static final String MAX_POLL_TIME_KEY = "UploadQueueMaxPollTime";
    private static final String SEARCH_HIT_LIMIT_ERROR_KEY = "SearchHitLimitError";
    private IntegerTextField simultaneousUploadsTF;
    private IntegerTextField uploadsPerHostTF;
    private IntegerTextField returnedSearchLimitTF;
    private JCheckBox allowUploadQueuingChkbx;
    private JLabel queueLimitLabel;
    private IntegerTextField queueLimitTF;
    private JLabel minPollTimeLabel;
    private IntegerTextField minPollTimeTF;
    private JLabel maxPollTimeLabel;
    private IntegerTextField maxPollTimeTF;
    private JCheckBox removeCompletedUploadsChkbx;
    private JCheckBox sharePartialFilesChkbx;
    private JCheckBox allowBrowsingChkbx;

    public SharingPane() {
        super("Sharing");
    }

    protected void prepareComponent() {
        FormLayout formLayout = new FormLayout("10dlu, right:d, 2dlu, d, 10dlu, right:d, 2dlu, d, 2dlu:grow", "p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 9dlu, p, 3dlu, p, 3dlu, p, 3dlu, p");
        formLayout.setRowGroups(new int[][]{{3, 5, 7, 9, 13, 15, 17}});
        this.setLayout(formLayout);
        PanelBuilder panelBuilder = new PanelBuilder(formLayout, this);
        CellConstraints cellConstraints = new CellConstraints();
        CellConstraints cellConstraints2 = new CellConstraints();
        panelBuilder.addSeparator(Localizer.getString("GeneralUploadSettings"), cellConstraints.xywh(1, 1, 9, 1));
        this.simultaneousUploadsTF = new IntegerTextField(String.valueOf(ServiceManager.sCfg.mMaxUpload), 6, 3);
        panelBuilder.addLabel(Localizer.getString("MaxParallelUploads") + ": ", cellConstraints.xy(2, 3), this.simultaneousUploadsTF, cellConstraints2.xy(4, 3));
        this.uploadsPerHostTF = new IntegerTextField(String.valueOf(ServiceManager.sCfg.mMaxUploadPerIP), 6, 2);
        panelBuilder.addLabel(Localizer.getString("MaxUploadsPerHost") + ": ", cellConstraints.xy(6, 3), this.uploadsPerHostTF, cellConstraints2.xy(8, 3));
        panelBuilder.addLabel(Localizer.getString("MaxReturnedSearchHits") + ": ", cellConstraints.xy(2, 5));
        this.returnedSearchLimitTF = new IntegerTextField(String.valueOf(ServiceManager.sCfg.mUploadMaxSearch), 6, 3);
        panelBuilder.add((Component)this.returnedSearchLimitTF, cellConstraints.xy(4, 5));
        this.allowBrowsingChkbx = new JCheckBox(Localizer.getString("AllowBrowsingDirectories"), ServiceManager.sCfg.mShareBrowseDir);
        panelBuilder.add((Component)this.allowBrowsingChkbx, cellConstraints.xywh(2, 7, 3, 1));
        this.sharePartialFilesChkbx = new JCheckBox(Localizer.getString("SharePartialFiles"), ServiceManager.sCfg.arePartialFilesShared);
        panelBuilder.add((Component)this.sharePartialFilesChkbx, cellConstraints.xywh(6, 7, 3, 1));
        this.removeCompletedUploadsChkbx = new JCheckBox(Localizer.getString("AutoCleanFinishedUploads"), ServiceManager.sCfg.mUploadAutoRemoveCompleted);
        panelBuilder.add((Component)this.removeCompletedUploadsChkbx, cellConstraints.xywh(2, 9, 3, 1));
        panelBuilder.addSeparator(Localizer.getString("UploadQueuing"), cellConstraints.xywh(1, 11, 9, 1));
        this.allowUploadQueuingChkbx = new JCheckBox(Localizer.getString("AllowUploadQueuing"), ServiceManager.sCfg.allowUploadQueuing);
        this.allowUploadQueuingChkbx.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SharingPane.this.refreshEnableState();
            }
        });
        panelBuilder.add((Component)this.allowUploadQueuingChkbx, cellConstraints.xywh(2, 13, 4, 1));
        this.queueLimitLabel = panelBuilder.addLabel(Localizer.getString("MaxQueueLength") + ": ", cellConstraints.xy(2, 15));
        this.queueLimitTF = new IntegerTextField(String.valueOf(ServiceManager.sCfg.maxUploadQueueSize), 6, 2);
        panelBuilder.add((Component)this.queueLimitTF, cellConstraints.xy(4, 15));
        this.minPollTimeLabel = panelBuilder.addLabel(Localizer.getString("MinPollTime") + ": ", cellConstraints.xy(2, 17));
        this.minPollTimeTF = new IntegerTextField(String.valueOf(ServiceManager.sCfg.minUploadQueuePollTime), 6, 3);
        panelBuilder.add((Component)this.minPollTimeTF, cellConstraints.xy(4, 17));
        this.maxPollTimeLabel = panelBuilder.addLabel(Localizer.getString("MaxPollTime") + ": ", cellConstraints.xy(6, 17));
        this.maxPollTimeTF = new IntegerTextField(String.valueOf(ServiceManager.sCfg.maxUploadQueuePollTime), 6, 3);
        panelBuilder.add((Component)this.maxPollTimeTF, cellConstraints.xy(8, 17));
        this.refreshEnableState();
    }

    public void checkInput(HashMap hashMap) {
        Integer n;
        String string;
        try {
            string = this.simultaneousUploadsTF.getText();
            n = new Integer(string);
            hashMap.put(SIMULTANEOUS_UPLOADS_KEY, n);
        }
        catch (NumberFormatException numberFormatException) {
            hashMap.put("NumberFormatError", this.simultaneousUploadsTF);
            this.setInputValid(hashMap, false);
            return;
        }
        try {
            string = this.uploadsPerHostTF.getText();
            n = new Integer(string);
            hashMap.put(UPLOADS_PER_HOST_KEY, n);
        }
        catch (NumberFormatException numberFormatException) {
            hashMap.put("NumberFormatError", this.uploadsPerHostTF);
            this.setInputValid(hashMap, false);
            return;
        }
        try {
            string = this.returnedSearchLimitTF.getText();
            n = new Integer(string);
            if (n > 255) {
                hashMap.put(SEARCH_HIT_LIMIT_ERROR_KEY, n);
                this.setInputValid(hashMap, false);
                return;
            }
            hashMap.put(RETURNED_SEARCH_LIMIT_KEY, n);
        }
        catch (NumberFormatException numberFormatException) {
            hashMap.put("NumberFormatError", this.returnedSearchLimitTF);
            this.setInputValid(hashMap, false);
            return;
        }
        try {
            string = this.queueLimitTF.getText();
            n = new Integer(string);
            hashMap.put(QUEUE_LIMIT_KEY, n);
        }
        catch (NumberFormatException numberFormatException) {
            hashMap.put("NumberFormatError", this.queueLimitTF);
            this.setInputValid(hashMap, false);
            return;
        }
        try {
            string = this.minPollTimeTF.getText();
            n = new Integer(string);
            hashMap.put(MIN_POLL_TIME_KEY, n);
        }
        catch (NumberFormatException numberFormatException) {
            hashMap.put("NumberFormatError", this.minPollTimeTF);
            this.setInputValid(hashMap, false);
            return;
        }
        try {
            string = this.maxPollTimeTF.getText();
            n = new Integer(string);
            hashMap.put(MAX_POLL_TIME_KEY, n);
        }
        catch (NumberFormatException numberFormatException) {
            hashMap.put("NumberFormatError", this.maxPollTimeTF);
            this.setInputValid(hashMap, false);
            return;
        }
        this.setInputValid(hashMap, true);
    }

    public void displayErrorMessage(HashMap hashMap) {
        if (hashMap.containsKey("NumberFormatError")) {
            this.displayNumberFormatError(hashMap);
        } else if (hashMap.containsKey(SEARCH_HIT_LIMIT_ERROR_KEY)) {
            this.returnedSearchLimitTF.setText("255");
            this.returnedSearchLimitTF.requestFocus();
            this.returnedSearchLimitTF.selectAll();
            GUIUtils.showErrorMessage(Localizer.getString("ExceedSearchHitLimit"), Localizer.getString("Error"));
        }
    }

    public void saveAndApplyChanges(HashMap hashMap) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        Integer n;
        int n2;
        Integer n3;
        int n4;
        Integer n5;
        int n6;
        boolean bl4;
        Integer n7;
        int n8;
        Integer n9;
        int n10;
        Integer n11 = (Integer)hashMap.get(SIMULTANEOUS_UPLOADS_KEY);
        int n12 = Math.max(1, n11);
        if (ServiceManager.sCfg.mMaxUpload != n12) {
            ServiceManager.sCfg.mMaxUpload = n12;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        if (ServiceManager.sCfg.mMaxUploadPerIP != (n10 = Math.max(1, n9 = (Integer)hashMap.get(UPLOADS_PER_HOST_KEY)))) {
            ServiceManager.sCfg.mMaxUploadPerIP = n10;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        if (ServiceManager.sCfg.mUploadMaxSearch != (n8 = (n7 = (Integer)hashMap.get(RETURNED_SEARCH_LIMIT_KEY)).intValue())) {
            ServiceManager.sCfg.mUploadMaxSearch = n8;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        if (ServiceManager.sCfg.allowUploadQueuing != (bl4 = this.allowUploadQueuingChkbx.isSelected())) {
            ServiceManager.sCfg.allowUploadQueuing = bl4;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        if (ServiceManager.sCfg.maxUploadQueueSize != (n6 = (n5 = (Integer)hashMap.get(QUEUE_LIMIT_KEY)).intValue())) {
            ServiceManager.sCfg.maxUploadQueueSize = n6;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        if (ServiceManager.sCfg.minUploadQueuePollTime != (n4 = (n3 = (Integer)hashMap.get(MIN_POLL_TIME_KEY)).intValue())) {
            ServiceManager.sCfg.minUploadQueuePollTime = n4;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        if (ServiceManager.sCfg.maxUploadQueuePollTime != (n2 = (n = (Integer)hashMap.get(MAX_POLL_TIME_KEY)).intValue())) {
            ServiceManager.sCfg.maxUploadQueuePollTime = n2;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        if (ServiceManager.sCfg.arePartialFilesShared != (bl3 = this.sharePartialFilesChkbx.isSelected())) {
            ServiceManager.sCfg.arePartialFilesShared = bl3;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        if (ServiceManager.sCfg.mUploadAutoRemoveCompleted != (bl2 = this.removeCompletedUploadsChkbx.isSelected())) {
            ServiceManager.sCfg.mUploadAutoRemoveCompleted = bl2;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        if (ServiceManager.sCfg.mShareBrowseDir != (bl = this.allowBrowsingChkbx.isSelected())) {
            ServiceManager.sCfg.mShareBrowseDir = bl;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
    }

    private void refreshEnableState() {
        boolean bl = this.allowUploadQueuingChkbx.isSelected();
        this.queueLimitLabel.setEnabled(bl);
        this.queueLimitTF.setEnabled(bl);
        this.minPollTimeLabel.setEnabled(bl);
        this.minPollTimeTF.setEnabled(bl);
        this.maxPollTimeLabel.setEnabled(bl);
        this.maxPollTimeTF.setEnabled(bl);
    }
}

