/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.dialogs.options;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import phex.common.ServiceManager;
import phex.gui.actions.GUIActionPerformer;
import phex.gui.common.GUIRegistry;
import phex.gui.dialogs.options.BandwidthPane;
import phex.gui.dialogs.options.DebugPane;
import phex.gui.dialogs.options.DirectoriesPane;
import phex.gui.dialogs.options.DisconnectPane;
import phex.gui.dialogs.options.DisplayPromptsPane;
import phex.gui.dialogs.options.DownloadPane;
import phex.gui.dialogs.options.GeneralTextPane;
import phex.gui.dialogs.options.GeneralUIPane;
import phex.gui.dialogs.options.LanguagePane;
import phex.gui.dialogs.options.MainTextPane;
import phex.gui.dialogs.options.NetworkPane;
import phex.gui.dialogs.options.OptionsSettingsPane;
import phex.gui.dialogs.options.OptionsTreeCellRenderer;
import phex.gui.dialogs.options.ProxyPane;
import phex.gui.dialogs.options.SharingPane;
import phex.utils.Localizer;
import phex.utils.NLogger;

public class OptionsDialog
extends JDialog {
    private JPanel contentPanel;
    private PanelBuilder optionViewBuilder;
    private JPanel optionViewPane;
    private JTree optionTree;
    private OptionsSettingsPane[] settingsPanes = null;
    private HashMap inputDictionary = new HashMap();

    public OptionsDialog() {
        super(GUIRegistry.getInstance().getMainFrame(), Localizer.getString("PhexOptions"), false);
        this.prepareComponent();
    }

    public void setOptionView(OptionsSettingsPane optionsSettingsPane) {
        optionsSettingsPane.prepareForDisplay();
        this.optionViewPane.removeAll();
        CellConstraints cellConstraints = new CellConstraints();
        this.optionViewBuilder.add((Component)optionsSettingsPane, cellConstraints.xy(1, 1));
        this.getContentPane().validate();
        optionsSettingsPane.doLayout();
        optionsSettingsPane.revalidate();
        Dimension dimension = this.getPreferredSize();
        Dimension dimension2 = this.getSize();
        if (dimension.width > dimension2.width || dimension.height > dimension2.height) {
            dimension2.setSize(Math.max(dimension.width, dimension2.width), Math.max(dimension.height, dimension2.height));
            this.setSize(dimension2);
            this.doLayout();
        }
        this.contentPanel.repaint();
    }

    private void prepareComponent() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                OptionsDialog.this.closeDialog();
            }
        });
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        this.contentPanel = new JPanel();
        container.add((Component)this.contentPanel, "Center");
        FormLayout formLayout = new FormLayout("3dlu, fill:p, 6dlu, fill:d:grow, 3dlu", "6dlu, fill:d:grow, 3dlu, d, 3dlu, d, 6dlu");
        this.contentPanel.setLayout(formLayout);
        PanelBuilder panelBuilder = new PanelBuilder(formLayout, this.contentPanel);
        CellConstraints cellConstraints = new CellConstraints();
        SpecialLAFPanel specialLAFPanel = new SpecialLAFPanel();
        panelBuilder.add((Component)specialLAFPanel, cellConstraints.xy(1, 1));
        this.optionTree = new JTree(this.createOptionTreeModel());
        this.optionTree.setCellRenderer(new OptionsTreeCellRenderer());
        this.optionTree.setRootVisible(false);
        this.optionTree.expandRow(2);
        this.optionTree.expandRow(1);
        this.optionTree.expandRow(0);
        this.optionTree.getSelectionModel().setSelectionMode(1);
        this.optionTree.putClientProperty("JTree.lineStyle", "Angled");
        this.optionTree.addTreeSelectionListener(new OptionSelectionListener());
        panelBuilder.add((Component)this.optionTree, cellConstraints.xy(2, 2));
        this.optionViewPane = new JPanel();
        FormLayout formLayout2 = new FormLayout("fill:d:grow", "fill:d:grow");
        this.optionViewBuilder = new PanelBuilder(formLayout2, this.optionViewPane);
        panelBuilder.add((Component)this.optionViewPane, cellConstraints.xy(4, 2));
        JSeparator jSeparator = new JSeparator();
        panelBuilder.add((Component)jSeparator, cellConstraints.xywh(2, 4, 3, 1));
        JButton jButton = new JButton(Localizer.getString("OK"));
        jButton.setDefaultCapable(true);
        jButton.addActionListener(new OkButtonListener());
        JButton jButton2 = new JButton(Localizer.getString("Apply"));
        jButton2.addActionListener(new ApplyButtonListener());
        JButton jButton3 = new JButton(Localizer.getString("Cancel"));
        jButton3.addActionListener(new CancelButtonListener());
        JPanel jPanel = ButtonBarFactory.buildOKCancelApplyBar(jButton, jButton3, jButton2);
        panelBuilder.add((Component)jPanel, cellConstraints.xywh(2, 6, 3, 1));
        this.getRootPane().setDefaultButton(jButton);
        this.setDefaultCloseOperation(2);
        this.optionTree.setSelectionRow(0);
        this.pack();
        this.setLocationRelativeTo(GUIRegistry.getInstance().getMainFrame());
    }

    private boolean isAllInputValid() {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.optionTree.getModel().getRoot();
        for (int i = 0; i < this.settingsPanes.length; ++i) {
            if (!this.settingsPanes[i].isSettingsPaneDisplayed()) continue;
            this.settingsPanes[i].checkInput(this.inputDictionary);
            if (this.settingsPanes[i].isInputValid(this.inputDictionary)) continue;
            Enumeration<TreeNode> enumeration = defaultMutableTreeNode.depthFirstEnumeration();
            while (enumeration.hasMoreElements()) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
                Object object = defaultMutableTreeNode2.getUserObject();
                if (!(object instanceof OptionsSettingsPane) || object != this.settingsPanes[i]) continue;
                this.optionTree.setSelectionPath(new TreePath(defaultMutableTreeNode2.getPath()));
                break;
            }
            this.setOptionView(this.settingsPanes[i]);
            this.settingsPanes[i].displayErrorMessage(this.inputDictionary);
            return false;
        }
        return true;
    }

    private void saveAndApplyAllChanges() {
        for (int i = 0; i < this.settingsPanes.length; ++i) {
            if (!this.settingsPanes[i].isSettingsPaneDisplayed()) continue;
            this.settingsPanes[i].saveAndApplyChanges(this.inputDictionary);
        }
        if (OptionsSettingsPane.isSaveConfigTriggered(this.inputDictionary)) {
            ServiceManager.sCfg.save();
        }
        if (OptionsSettingsPane.isSharedFilesRescanTriggered(this.inputDictionary)) {
            GUIActionPerformer.rescanSharedFiles();
        }
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    private TreeModel createOptionTreeModel() {
        int n = 0;
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode();
        this.settingsPanes = new OptionsSettingsPane[14];
        this.settingsPanes[n] = new MainTextPane();
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(this.settingsPanes[n]);
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        this.settingsPanes[++n] = new NetworkPane();
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode(this.settingsPanes[n]));
        this.settingsPanes[++n] = new ProxyPane();
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode(this.settingsPanes[n]));
        this.settingsPanes[++n] = new BandwidthPane();
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode(this.settingsPanes[n]));
        this.settingsPanes[++n] = new DisconnectPane();
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode(this.settingsPanes[n]));
        this.settingsPanes[++n] = new GeneralTextPane("DownloadSharingSettings", "DownloadSharingSettingsText", "DownloadSharingSettings");
        defaultMutableTreeNode2 = new DefaultMutableTreeNode(this.settingsPanes[n]);
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        this.settingsPanes[++n] = new DownloadPane();
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode(this.settingsPanes[n]));
        this.settingsPanes[++n] = new SharingPane();
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode(this.settingsPanes[n]));
        this.settingsPanes[++n] = new DirectoriesPane();
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode(this.settingsPanes[n]));
        this.settingsPanes[++n] = new GeneralTextPane("UserInterface", "UserInterfaceText", "UserInterface");
        defaultMutableTreeNode2 = new DefaultMutableTreeNode(this.settingsPanes[n]);
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        this.settingsPanes[++n] = new GeneralUIPane();
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode(this.settingsPanes[n]));
        this.settingsPanes[++n] = new LanguagePane();
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode(this.settingsPanes[n]));
        this.settingsPanes[++n] = new DisplayPromptsPane();
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode(this.settingsPanes[n]));
        this.settingsPanes[++n] = new DebugPane();
        defaultMutableTreeNode2 = new DefaultMutableTreeNode(this.settingsPanes[n]);
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        return new DefaultTreeModel(defaultMutableTreeNode);
    }

    class SpecialLAFPanel
    extends JPanel {
        private boolean inited = true;

        public void updateUI() {
            if (this.inited && OptionsDialog.this.settingsPanes != null) {
                for (int i = 0; i < OptionsDialog.this.settingsPanes.length; ++i) {
                    if (OptionsDialog.this.settingsPanes[i] == null || !OptionsDialog.this.settingsPanes[i].isSettingsPaneDisplayed()) continue;
                    SwingUtilities.updateComponentTreeUI(OptionsDialog.this.settingsPanes[i]);
                }
            }
            super.updateUI();
        }
    }

    class OptionSelectionListener
    implements TreeSelectionListener {
        OptionSelectionListener() {
        }

        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            try {
                TreePath treePath = treeSelectionEvent.getPath();
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                Object object = defaultMutableTreeNode.getUserObject();
                if (object instanceof OptionsSettingsPane) {
                    OptionsDialog.this.setOptionView((OptionsSettingsPane)object);
                }
            }
            catch (Throwable throwable) {
                NLogger.error("USER_INTERFACE", (Object)throwable, throwable);
            }
        }
    }

    private final class OkButtonListener
    implements ActionListener {
        private OkButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                if (OptionsDialog.this.isAllInputValid()) {
                    OptionsDialog.this.saveAndApplyAllChanges();
                    OptionsDialog.this.closeDialog();
                }
            }
            catch (Throwable throwable) {
                NLogger.error("USER_INTERFACE", (Object)throwable, throwable);
            }
        }
    }

    private final class ApplyButtonListener
    implements ActionListener {
        private ApplyButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                if (OptionsDialog.this.isAllInputValid()) {
                    OptionsDialog.this.saveAndApplyAllChanges();
                }
            }
            catch (Throwable throwable) {
                NLogger.error("USER_INTERFACE", (Object)throwable, throwable);
            }
        }
    }

    private final class CancelButtonListener
    implements ActionListener {
        private CancelButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                OptionsDialog.this.closeDialog();
            }
            catch (Throwable throwable) {
                NLogger.error("USER_INTERFACE", (Object)throwable, throwable);
            }
        }
    }
}

