/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.dialogs.options;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import phex.common.ServiceManager;
import phex.gui.common.IntegerTextField;
import phex.gui.dialogs.options.OptionsSettingsPane;
import phex.utils.Localizer;

public class DisconnectPane
extends OptionsSettingsPane {
    private JCheckBox applyPolicyChkbx;
    private IntegerTextField maxSendQueueTF;
    private JSlider dropPacketExceedsSlider;
    private JLabel dropPacketExceedsLabel;
    private IntegerTextField minSharedFilesTF;
    private IntegerTextField minSharedMBTF;
    private JCheckBox emptyVendorStringChkbx;
    private static final String APPLY_POLICY_KEY = "applyPolicy";
    private static final String SEND_QUEUE_KEY = "sendQueue";
    private static final String DROP_PACKET_KEY = "dropPacket";
    private static final String VENDOR_KEY = "vendor";
    private static final String SHARED_FILES_KEY = "sharedFiles";
    private static final String SHARED_MB_KEY = "sharedMb";

    public DisconnectPane() {
        super("DisconnectPolicy");
    }

    protected void prepareComponent() {
        this.setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Localizer.getString("DisconnectPolicy")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 0, 5, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)jPanel, gridBagConstraints);
        this.applyPolicyChkbx = new JCheckBox(Localizer.getString("DisconnectNodesAccordingRules"), ServiceManager.sCfg.mDisconnectApplyPolicy);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.applyPolicyChkbx, gridBagConstraints);
        this.emptyVendorStringChkbx = new JCheckBox(Localizer.getString("DisconnectNoVendorNodes"), ServiceManager.sCfg.isNoVendorNodeDisconnected);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 15, 3, 0);
        gridBagConstraints.gridwidth = 4;
        jPanel.add((Component)this.emptyVendorStringChkbx, gridBagConstraints);
        JLabel jLabel = new JLabel(Localizer.getString("SendQueueExceeds") + Localizer.getString("ColonSign") + " ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 15, 3, 5);
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.maxSendQueueTF = new IntegerTextField(String.valueOf(ServiceManager.sCfg.mNetMaxSendQueue), 3, 3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        jPanel.add((Component)this.maxSendQueueTF, gridBagConstraints);
        jLabel = new JLabel(Localizer.getString("MinSharedFiles") + Localizer.getString("ColonSign") + " ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 15, 3, 5);
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.minSharedFilesTF = new IntegerTextField(String.valueOf(ServiceManager.sCfg.freeloaderFiles), 4, 4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        jPanel.add((Component)this.minSharedFilesTF, gridBagConstraints);
        jLabel = new JLabel(Localizer.getString("MinSharedMB") + Localizer.getString("ColonSign") + " ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 15, 3, 5);
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.minSharedMBTF = new IntegerTextField(String.valueOf(ServiceManager.sCfg.freeloaderShareSize), 4, 4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        jPanel.add((Component)this.minSharedMBTF, gridBagConstraints);
        jLabel = new JLabel(Localizer.getString("DropPacketExceeds") + Localizer.getString("ColonSign") + " ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 15, 3, 5);
        jPanel.add((Component)jLabel, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        this.dropPacketExceedsLabel = new JLabel(String.valueOf(ServiceManager.sCfg.mDisconnectDropRatio) + Localizer.getString("PercentSign"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 3, 5);
        jPanel2.add((Component)this.dropPacketExceedsLabel, gridBagConstraints);
        this.dropPacketExceedsSlider = new JSlider(0, 100, ServiceManager.sCfg.mDisconnectDropRatio);
        this.dropPacketExceedsSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                DisconnectPane.this.dropPacketExceedsLabel.setText(String.valueOf(DisconnectPane.this.dropPacketExceedsSlider.getValue()) + Localizer.getString("PercentSign"));
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        jPanel2.add((Component)this.dropPacketExceedsSlider, gridBagConstraints);
    }

    public void checkInput(HashMap hashMap) {
        try {
            hashMap.put(SEND_QUEUE_KEY, new Integer(this.maxSendQueueTF.getText()));
        }
        catch (NumberFormatException numberFormatException) {
            hashMap.put("NumberFormatError", this.maxSendQueueTF);
            this.setInputValid(hashMap, false);
            return;
        }
        try {
            hashMap.put(SHARED_FILES_KEY, new Integer(this.minSharedFilesTF.getText()));
        }
        catch (NumberFormatException numberFormatException) {
            hashMap.put("NumberFormatError", this.minSharedFilesTF);
            this.setInputValid(hashMap, false);
            return;
        }
        try {
            hashMap.put(SHARED_MB_KEY, new Integer(this.minSharedMBTF.getText()));
        }
        catch (NumberFormatException numberFormatException) {
            hashMap.put("NumberFormatError", this.minSharedMBTF);
            this.setInputValid(hashMap, false);
            return;
        }
        hashMap.put(DROP_PACKET_KEY, new Integer(this.dropPacketExceedsSlider.getValue()));
        hashMap.put(APPLY_POLICY_KEY, this.applyPolicyChkbx.isSelected());
        hashMap.put(VENDOR_KEY, this.emptyVendorStringChkbx.isSelected());
        this.setInputValid(hashMap, true);
    }

    public void saveAndApplyChanges(HashMap hashMap) {
        boolean bl = false;
        Boolean bl2 = (Boolean)hashMap.get(APPLY_POLICY_KEY);
        Integer n = (Integer)hashMap.get(SEND_QUEUE_KEY);
        Integer n2 = (Integer)hashMap.get(DROP_PACKET_KEY);
        Boolean bl3 = (Boolean)hashMap.get(VENDOR_KEY);
        Integer n3 = (Integer)hashMap.get(SHARED_FILES_KEY);
        Integer n4 = (Integer)hashMap.get(SHARED_MB_KEY);
        if (bl2 != null && bl2 != ServiceManager.sCfg.mDisconnectApplyPolicy) {
            ServiceManager.sCfg.mDisconnectApplyPolicy = bl2;
            bl = true;
        }
        if (n != null && n != ServiceManager.sCfg.mNetMaxSendQueue) {
            ServiceManager.sCfg.mNetMaxSendQueue = n;
            bl = true;
        }
        if (n2 != null && n2 != ServiceManager.sCfg.mDisconnectDropRatio) {
            ServiceManager.sCfg.mDisconnectDropRatio = n2;
            bl = true;
        }
        if (bl3 != null && bl3 != ServiceManager.sCfg.isNoVendorNodeDisconnected) {
            ServiceManager.sCfg.isNoVendorNodeDisconnected = bl3;
            bl = true;
        }
        if (n3 != null && n3 != ServiceManager.sCfg.freeloaderFiles) {
            ServiceManager.sCfg.freeloaderFiles = n3;
            bl = true;
        }
        if (n4 != null && n4 != ServiceManager.sCfg.freeloaderShareSize) {
            ServiceManager.sCfg.freeloaderShareSize = n4;
            bl = true;
        }
        if (bl) {
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
    }
}

