/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.dialogs.options;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import phex.common.ServiceManager;
import phex.common.bandwidth.BandwidthManager;
import phex.common.format.NumberFormatUtils;
import phex.gui.common.GUIRegistry;
import phex.gui.dialogs.options.OptionsSettingsPane;
import phex.utils.Localizer;

public class BandwidthPane
extends OptionsSettingsPane {
    private int UNLIMITED_VALUE = 101;
    private SpeedDefinition[] speedDefinitions = new SpeedDefinition[]{new SpeedDefinition("Modem", 56), new SpeedDefinition("ISDN", 64), new SpeedDefinition("DualISDN", 128), new SpeedDefinition("DSLCable1", 256), new SpeedDefinition("DSLCable2", 512), new SpeedDefinition("DSLCable3", 768), new SpeedDefinition("T1", 1544), new SpeedDefinition("10LAN", 10000), new SpeedDefinition("T3", 44736), new SpeedDefinition("100LAN", 100000), new SpeedDefinition("1000LAN", 1000000)};
    private Dictionary linearSliderLabels = new Hashtable(5);
    private JComboBox connectionSpeedCbx;
    private JLabel totalBandwidthLabel;
    private JSlider totalBandwidthSldr;
    private JLabel netBandwidthLabel;
    private JSlider netBandwidthSldr;
    private JLabel downloadBandwidthLabel;
    private JSlider downloadBandwidthSldr;
    private JLabel uploadBandwidthLabel;
    private JSlider uploadBandwidthSldr;
    private JCheckBox useLogSlider;
    private double maxConnectionBandwidth;
    private double currentTotalBandwidth;
    private double currentNetBandwidth;
    private double currentDownloadBandwidth;
    private double currentUploadBandwidth;
    private boolean updateSliderLabels = true;

    public BandwidthPane() {
        super("Bandwidth");
        this.linearSliderLabels.put(new Integer(0), new JLabel("0%", 0));
        this.linearSliderLabels.put(new Integer(25), new JLabel("25%", 0));
        this.linearSliderLabels.put(new Integer(50), new JLabel("50%", 0));
        this.linearSliderLabels.put(new Integer(75), new JLabel("75%", 0));
        this.linearSliderLabels.put(new Integer(100), new JLabel("100%", 0));
    }

    protected void prepareComponent() {
        boolean bl = !GUIRegistry.getInstance().useLogBandwidthSlider();
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        this.add((Component)jPanel, "Center");
        FormLayout formLayout = new FormLayout("10dlu, d, 2dlu, d, right:d:grow", "p, 3dlu, p, 3dlu, p, 3dlu, p, 9dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 9dlu, p, 3dlu, p");
        jPanel.setLayout(formLayout);
        PanelBuilder panelBuilder = new PanelBuilder(formLayout, jPanel);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.addSeparator(Localizer.getString("NetworkSpeedSettings"), cellConstraints.xywh(1, 1, 5, 1));
        panelBuilder.addLabel(Localizer.getString("ConnectionTypeSpeed") + ": ", cellConstraints.xy(2, 3));
        this.connectionSpeedCbx = new JComboBox<SpeedDefinition>(this.speedDefinitions);
        this.connectionSpeedCbx.addItemListener(new SpeedItemListener());
        panelBuilder.add((Component)this.connectionSpeedCbx, cellConstraints.xy(4, 3));
        panelBuilder.addLabel(Localizer.getString("TotalBandwidth") + ": ", cellConstraints.xywh(2, 5, 3, 1));
        this.totalBandwidthLabel = new JLabel();
        panelBuilder.add((Component)this.totalBandwidthLabel, cellConstraints.xy(5, 5));
        this.totalBandwidthSldr = new JSlider(0, 0, 101, 0);
        this.totalBandwidthSldr.addChangeListener(new SliderChangeListener());
        this.totalBandwidthSldr.setPaintLabels(true);
        panelBuilder.add((Component)this.totalBandwidthSldr, cellConstraints.xywh(2, 7, 4, 1));
        panelBuilder.addSeparator(Localizer.getString("PhexBandwidthSettings"), cellConstraints.xywh(1, 9, 5, 1));
        panelBuilder.addLabel(Localizer.getString("MaxNetworkBandwidth") + ": ", cellConstraints.xywh(2, 11, 3, 1));
        this.netBandwidthLabel = new JLabel();
        panelBuilder.add((Component)this.netBandwidthLabel, cellConstraints.xy(5, 11));
        this.netBandwidthSldr = new JSlider(0, 0, 101, 0);
        this.netBandwidthSldr.addChangeListener(new SliderChangeListener());
        panelBuilder.add((Component)this.netBandwidthSldr, cellConstraints.xywh(2, 13, 4, 1));
        panelBuilder.addLabel(Localizer.getString("MaxDownloadBandwidth") + ": ", cellConstraints.xywh(2, 15, 3, 1));
        this.downloadBandwidthLabel = new JLabel();
        panelBuilder.add((Component)this.downloadBandwidthLabel, cellConstraints.xy(5, 15));
        this.downloadBandwidthSldr = new JSlider(0, 0, 101, 0);
        this.downloadBandwidthSldr.addChangeListener(new SliderChangeListener());
        panelBuilder.add((Component)this.downloadBandwidthSldr, cellConstraints.xywh(2, 17, 4, 1));
        panelBuilder.addLabel(Localizer.getString("MaxUploadBandwidth") + ": ", cellConstraints.xywh(2, 19, 3, 1));
        this.uploadBandwidthLabel = new JLabel();
        panelBuilder.add((Component)this.uploadBandwidthLabel, cellConstraints.xy(5, 19));
        this.uploadBandwidthSldr = new JSlider(0, 0, 101, 0);
        this.uploadBandwidthSldr.addChangeListener(new SliderChangeListener());
        panelBuilder.add((Component)this.uploadBandwidthSldr, cellConstraints.xywh(2, 21, 4, 1));
        this.useLogSlider = new JCheckBox(Localizer.getString("BandwidthSettings_UseLogarithmicSliders"), !bl);
        this.useLogSlider.setToolTipText(Localizer.getString("BandwidthSettings_TTTUseLogarithmicSliders"));
        this.useLogSlider.addActionListener(new LogSliderActionListener());
        panelBuilder.add((Component)this.useLogSlider, cellConstraints.xywh(2, 23, 4, 1, "right, center"));
        this.initConfigValues();
    }

    public void checkInput(HashMap hashMap) {
    }

    public void displayErrorMessage(HashMap hashMap) {
    }

    public void saveAndApplyChanges(HashMap hashMap) {
        SpeedDefinition speedDefinition = (SpeedDefinition)this.connectionSpeedCbx.getSelectedItem();
        int n = speedDefinition.getSpeedInKbps();
        if (ServiceManager.sCfg.networkSpeedKbps != n) {
            ServiceManager.sCfg.networkSpeedKbps = n;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        if (ServiceManager.sCfg.maxTotalBandwidth != (n = this.totalBandwidthSldr.getValue() == this.UNLIMITED_VALUE ? Integer.MAX_VALUE : (int)Math.round(this.currentTotalBandwidth))) {
            BandwidthManager.getInstance().setPhexTotalBandwidth(n);
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        if (ServiceManager.sCfg.mNetMaxRate != (n = this.netBandwidthSldr.getValue() == this.UNLIMITED_VALUE ? Integer.MAX_VALUE : (int)Math.round(this.currentNetBandwidth))) {
            BandwidthManager.getInstance().setNetworkBandwidth(n);
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        if (ServiceManager.sCfg.mDownloadMaxBandwidth != (n = this.downloadBandwidthSldr.getValue() == this.UNLIMITED_VALUE ? Integer.MAX_VALUE : (int)Math.round(this.currentDownloadBandwidth))) {
            BandwidthManager.getInstance().setDownloadBandwidth(n);
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        if (ServiceManager.sCfg.mUploadMaxBandwidth != (n = this.uploadBandwidthSldr.getValue() == this.UNLIMITED_VALUE ? Integer.MAX_VALUE : (int)Math.round(this.currentUploadBandwidth))) {
            BandwidthManager.getInstance().setUploadBandwidth(n);
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
    }

    private void initConfigValues() {
        int n = ServiceManager.sCfg.networkSpeedKbps;
        for (int i = 0; i < this.speedDefinitions.length; ++i) {
            SpeedDefinition speedDefinition = this.speedDefinitions[i];
            int n2 = speedDefinition.getSpeedInKbps() - n;
            if (n2 < 0) continue;
            this.connectionSpeedCbx.setSelectedIndex(i);
            if (i != 0) break;
            this.updateMaxConnectionBandwidth(speedDefinition);
            break;
        }
        double d = ServiceManager.sCfg.maxTotalBandwidth;
        this.totalBandwidthSldr.setValue(this.bw2raw(d, this.maxConnectionBandwidth));
        d = ServiceManager.sCfg.mNetMaxRate;
        this.netBandwidthSldr.setValue(this.bw2raw(d, this.currentTotalBandwidth));
        d = ServiceManager.sCfg.mDownloadMaxBandwidth;
        this.downloadBandwidthSldr.setValue(this.bw2raw(d, this.currentTotalBandwidth));
        d = ServiceManager.sCfg.mUploadMaxBandwidth;
        this.uploadBandwidthSldr.setValue(this.bw2raw(d, this.currentTotalBandwidth));
    }

    private void calculateBandwidth() {
        String string;
        int n = this.totalBandwidthSldr.getValue();
        if (n == this.UNLIMITED_VALUE) {
            string = Localizer.getString("Unlimited");
            this.currentTotalBandwidth = this.maxConnectionBandwidth;
        } else {
            this.currentTotalBandwidth = this.raw2bw(n, this.maxConnectionBandwidth);
            string = NumberFormatUtils.formatSignificantByteSize(this.currentTotalBandwidth) + Localizer.getString("PerSec");
        }
        this.totalBandwidthLabel.setText(string);
        n = this.netBandwidthSldr.getValue();
        if (n == this.UNLIMITED_VALUE) {
            string = Localizer.getString("Unlimited");
            this.currentNetBandwidth = this.maxConnectionBandwidth;
        } else {
            this.currentNetBandwidth = this.raw2bw(n, this.currentTotalBandwidth);
            string = NumberFormatUtils.formatSignificantByteSize(this.currentNetBandwidth) + Localizer.getString("PerSec");
        }
        this.netBandwidthLabel.setText(string);
        n = this.downloadBandwidthSldr.getValue();
        if (n == this.UNLIMITED_VALUE) {
            string = Localizer.getString("Unlimited");
            this.currentDownloadBandwidth = this.maxConnectionBandwidth;
        } else {
            this.currentDownloadBandwidth = this.raw2bw(n, this.currentTotalBandwidth);
            string = NumberFormatUtils.formatSignificantByteSize(this.currentDownloadBandwidth) + Localizer.getString("PerSec");
        }
        this.downloadBandwidthLabel.setText(string);
        n = this.uploadBandwidthSldr.getValue();
        if (n == this.UNLIMITED_VALUE) {
            string = Localizer.getString("Unlimited");
            this.currentUploadBandwidth = this.maxConnectionBandwidth;
        } else {
            this.currentUploadBandwidth = this.raw2bw(n, this.currentTotalBandwidth);
            string = NumberFormatUtils.formatSignificantByteSize(this.currentUploadBandwidth) + Localizer.getString("PerSec");
        }
        this.uploadBandwidthLabel.setText(string);
        if (this.updateSliderLabels) {
            if (GUIRegistry.getInstance().useLogBandwidthSlider()) {
                Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
                hashtable.put(new Integer(0), new JLabel("0%", 0));
                double d = this.maxConnectionBandwidth / 200.0;
                int n2 = this.bw2raw(d, this.maxConnectionBandwidth);
                hashtable.put(new Integer(n2), new JLabel("0.5%", 0));
                d = this.maxConnectionBandwidth / 20.0;
                n2 = this.bw2raw(d, this.maxConnectionBandwidth);
                hashtable.put(new Integer(n2), new JLabel("5%", 0));
                hashtable.put(new Integer(100), new JLabel("100%", 0));
                this.totalBandwidthSldr.setLabelTable(hashtable);
            } else {
                this.totalBandwidthSldr.setLabelTable(this.linearSliderLabels);
            }
            this.updateSliderLabels = false;
        }
    }

    private double raw2bw(int n, double d) {
        if (n == 0) {
            return 0.0;
        }
        if (GUIRegistry.getInstance().useLogBandwidthSlider()) {
            double d2 = (double)n / 100.0;
            double d3 = 0.0;
            double d4 = Math.pow(d - d3, d2);
            double d5 = d4 + d3 * d2;
            return d5;
        }
        return (double)n * d / 100.0;
    }

    private int bw2raw(double d, double d2) {
        if (d == 0.0) {
            return 0;
        }
        if (d > d2) {
            return this.UNLIMITED_VALUE;
        }
        if (GUIRegistry.getInstance().useLogBandwidthSlider()) {
            double d3 = Math.log(d) / Math.log(d2);
            int n = (int)Math.round(d3 * 100.0);
            return n;
        }
        return (int)(d * 100.0 / d2);
    }

    private void updateMaxConnectionBandwidth(SpeedDefinition speedDefinition) {
        this.maxConnectionBandwidth = speedDefinition.getSpeedInKB() * 1024.0;
        this.updateSliderLabels = true;
        this.calculateBandwidth();
    }

    private void updateLogSliderUsage() {
        this.updateSliderLabels = true;
        GUIRegistry.getInstance().setLogBandwidthSliderUsed(this.useLogSlider.isSelected());
        this.calculateBandwidth();
    }

    private static class SpeedDefinition {
        private String representation;
        private int speedInKbps;

        public SpeedDefinition(String string, int n) {
            this.representation = Localizer.getString(string);
            this.speedInKbps = n;
        }

        public double getSpeedInKB() {
            return this.speedInKbps / 8;
        }

        public int getSpeedInKbps() {
            return this.speedInKbps;
        }

        public String toString() {
            return this.representation;
        }
    }

    private class SpeedItemListener
    implements ItemListener {
        private SpeedItemListener() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                SpeedDefinition speedDefinition = (SpeedDefinition)itemEvent.getItem();
                BandwidthPane.this.updateMaxConnectionBandwidth(speedDefinition);
            }
        }
    }

    private class LogSliderActionListener
    implements ActionListener {
        private LogSliderActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            BandwidthPane.this.updateLogSliderUsage();
        }
    }

    private class SliderChangeListener
    implements ChangeListener {
        private SliderChangeListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            BandwidthPane.this.calculateBandwidth();
        }
    }
}

