/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.dialogs.filter.wizard.condition;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.util.Iterator;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import phex.gui.common.table.FWTable;
import phex.gui.dialogs.filter.wizard.FilterWizardDialog;
import phex.gui.dialogs.filter.wizard.condition.ConditionCellRenderer;
import phex.gui.dialogs.filter.wizard.condition.ConditionTableModel;
import phex.rules.Rule;
import phex.rules.condition.Condition;
import phex.rules.condition.NotCondition;
import phex.utils.Localizer;
import phex.utils.NLogger;

public class ConditionPanel
extends JPanel {
    private FilterWizardDialog parent;
    private ConditionTableModel conditionTableModel;
    private FWTable conditionsTable;
    private JLabel selectConditionLabel;

    public ConditionPanel(FilterWizardDialog filterWizardDialog) {
        this.parent = filterWizardDialog;
        this.prepareComponent();
    }

    private void prepareComponent() {
        CellConstraints cellConstraints = new CellConstraints();
        FormLayout formLayout = new FormLayout("fill:d:grow", "p, 2dlu, fill:75dlu:grow");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout, this);
        this.selectConditionLabel = new JLabel(Localizer.getString("RuleWizard_SelectRuleCondition"));
        panelBuilder.add((Component)this.selectConditionLabel, cellConstraints.xywh(1, 1, 1, 1));
        this.conditionTableModel = new ConditionTableModel(this);
        this.conditionsTable = new FWTable(this.conditionTableModel);
        this.conditionsTable.setShowVerticalLines(false);
        JTableHeader jTableHeader = this.conditionsTable.getTableHeader();
        jTableHeader.setResizingAllowed(false);
        jTableHeader.setReorderingAllowed(false);
        JCheckBox jCheckBox = (JCheckBox)((Object)this.conditionsTable.getDefaultRenderer(Boolean.class));
        TableColumn tableColumn = this.conditionsTable.getColumnModel().getColumn(0);
        tableColumn.setMaxWidth(jCheckBox.getPreferredSize().width + 2);
        tableColumn.setMinWidth(jCheckBox.getPreferredSize().width + 2);
        this.conditionsTable.getColumnModel().getColumn(1).setCellRenderer(new ConditionCellRenderer());
        panelBuilder.add((Component)FWTable.createFWTableScrollPane(this.conditionsTable), cellConstraints.xywh(1, 3, 1, 1));
    }

    public void updateRuleData() {
        Rule rule = this.parent.getEditRule();
        int n = this.conditionTableModel.getRowCount();
        for (int i = 0; i < n; ++i) {
            this.conditionTableModel.conditions[i][0] = Boolean.FALSE;
        }
        List list = rule.getConditions();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Condition condition = (Condition)iterator.next();
            if (condition instanceof NotCondition) continue;
            int n2 = this.conditionTableModel.getRowOf(condition);
            this.conditionTableModel.conditions[n2][0] = Boolean.TRUE;
        }
        this.conditionsTable.setEnabled(!rule.isDefaultRule());
        this.selectConditionLabel.setEnabled(!rule.isDefaultRule());
        this.conditionTableModel.fireTableDataChanged();
    }

    public void ruleStatusChanged(Class clazz, boolean bl) {
        Rule rule = this.parent.getEditRule();
        if (bl) {
            try {
                Condition condition = (Condition)clazz.newInstance();
                rule.addCondition(condition);
                this.parent.updateRuleData();
            }
            catch (InstantiationException instantiationException) {
                NLogger.error(ConditionPanel.class, (Object)instantiationException, (Throwable)instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                NLogger.error(ConditionPanel.class, (Object)illegalAccessException, (Throwable)illegalAccessException);
            }
        } else {
            List list = rule.getConditions();
            for (int i = list.size() - 1; i >= 0; --i) {
                Condition condition = (Condition)list.get(i);
                if (condition.getClass() != clazz) continue;
                rule.removeCondition(condition);
            }
            this.parent.updateRuleData();
        }
    }
}

