/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.dialogs.filter.wizard;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import phex.gui.dialogs.filter.RuleDescOwnerDialog;
import phex.gui.dialogs.filter.RuleDescriptionPanel;
import phex.gui.dialogs.filter.wizard.RulePropertiesPanel;
import phex.gui.dialogs.filter.wizard.condition.ConditionPanel;
import phex.gui.dialogs.filter.wizard.consequence.ConsequencePanel;
import phex.gui.dialogs.filter.wizard.exception.ExceptionPanel;
import phex.rules.Rule;
import phex.rules.condition.Condition;
import phex.rules.condition.NotCondition;
import phex.utils.Localizer;
import phex.utils.NLogger;
import phex.utils.StringUtils;

public class FilterWizardDialog
extends JDialog
implements RuleDescOwnerDialog {
    private static final int CONDITION_PAGE = 1;
    private static final int CONSEQUENCE_PAGE = 2;
    private static final int EXCEPTION_PAGE = 3;
    private static final int RULE_PROPERTIES_PAGE = 4;
    private Rule editRule;
    private JPanel ruleEditPanel;
    private ConditionPanel conditionPanel;
    private ConsequencePanel consequencePanel;
    private ExceptionPanel exceptionPanel;
    private RulePropertiesPanel rulePropertiesPanel;
    private RuleDescriptionPanel ruleDescPanel;
    private int currentPage = 1;
    private JButton finishBtn;
    private JButton backBtn;
    private JButton nextBtn;

    public FilterWizardDialog(JDialog jDialog) {
        this(new Rule(), jDialog);
    }

    public FilterWizardDialog(Rule rule, JDialog jDialog) {
        super(jDialog, Localizer.getString("RuleWizard_DialogTitle"), true);
        this.editRule = rule;
        if (this.editRule.isDefaultRule()) {
            this.currentPage = 4;
        }
        this.prepareComponent();
        this.updateRuleData();
    }

    public Rule getEditRule() {
        return this.editRule;
    }

    public void updateRuleData() {
        if (this.conditionPanel != null) {
            this.conditionPanel.updateRuleData();
        }
        if (this.consequencePanel != null) {
            this.consequencePanel.updateRuleData();
        }
        if (this.exceptionPanel != null) {
            this.exceptionPanel.updateRuleData();
        }
        if (this.rulePropertiesPanel != null) {
            this.rulePropertiesPanel.updateRuleData();
        }
        this.ruleDescPanel.updateRuleData();
        this.setFinishBtnEnabled(!StringUtils.isEmpty(this.editRule.getName()));
    }

    private void prepareComponent() {
        CloseEventHandler closeEventHandler = new CloseEventHandler();
        this.addWindowListener(closeEventHandler);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        container.add((Component)jPanel, "Center");
        CellConstraints cellConstraints = new CellConstraints();
        FormLayout formLayout = new FormLayout("4dlu, fill:d:grow, 4dlu", "4dlu, fill:p:grow, 12dlu, fill:p:grow, 8dlu,p, 2dlu, p 4dlu");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout, jPanel);
        int n = formLayout.getColumnCount();
        int n2 = formLayout.getRowCount();
        this.ruleEditPanel = new JPanel();
        this.ruleEditPanel.setLayout(new BorderLayout());
        panelBuilder.add((Component)this.ruleEditPanel, cellConstraints.xywh(2, 2, 1, 1));
        this.ruleDescPanel = new RuleDescriptionPanel(this);
        panelBuilder.add((Component)this.ruleDescPanel, cellConstraints.xywh(2, 4, 1, 1));
        panelBuilder.add((Component)new JSeparator(), cellConstraints.xywh(1, n2 - 3, n, 1));
        this.backBtn = new JButton(Localizer.getString("WizardDialog_Back"));
        this.backBtn.addActionListener(new BackBtnListener());
        this.nextBtn = new JButton(Localizer.getString("WizardDialog_Next"));
        this.nextBtn.setDefaultCapable(true);
        this.nextBtn.setRequestFocusEnabled(true);
        this.nextBtn.addActionListener(new NextBtnListener());
        this.finishBtn = new JButton(Localizer.getString("WizardDialog_Finish"));
        this.finishBtn.addActionListener(new FinishBtnListener());
        JButton jButton = new JButton(Localizer.getString("WizardDialog_Cancel"));
        jButton.addActionListener(closeEventHandler);
        JPanel jPanel2 = ButtonBarFactory.buildWizardBar(this.backBtn, this.nextBtn, this.finishBtn, jButton);
        panelBuilder.add((Component)jPanel2, cellConstraints.xywh(2, n2 - 1, n - 2, 1));
        this.setDefaultCloseOperation(2);
        this.getRootPane().setDefaultButton(this.nextBtn);
        this.updatePage();
        this.pack();
        int n3 = this.getHeight();
        this.setSize(n3 * 5 / 4, n3);
        this.setLocationRelativeTo(this.getParent());
    }

    public void setFinishBtnEnabled(boolean bl) {
        this.finishBtn.setEnabled(bl);
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    private boolean isRuleInputComplete() {
        List list = this.editRule.getConditions();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Condition condition = (Condition)iterator.next();
            if (condition instanceof NotCondition) {
                condition = ((NotCondition)condition).getContainedCondition();
            }
            if (condition.isComplete()) continue;
            return false;
        }
        return true;
    }

    private void updatePage() {
        this.ruleEditPanel.removeAll();
        JPanel jPanel = null;
        switch (this.currentPage) {
            case 1: {
                if (this.conditionPanel == null) {
                    this.conditionPanel = new ConditionPanel(this);
                }
                jPanel = this.conditionPanel;
                this.backBtn.setEnabled(false);
                this.nextBtn.setEnabled(true);
                break;
            }
            case 2: {
                if (this.consequencePanel == null) {
                    this.consequencePanel = new ConsequencePanel(this);
                }
                jPanel = this.consequencePanel;
                this.backBtn.setEnabled(true);
                this.nextBtn.setEnabled(true);
                break;
            }
            case 3: {
                if (this.exceptionPanel == null) {
                    this.exceptionPanel = new ExceptionPanel(this);
                }
                jPanel = this.exceptionPanel;
                this.backBtn.setEnabled(true);
                this.nextBtn.setEnabled(true);
                break;
            }
            case 4: {
                if (this.rulePropertiesPanel == null) {
                    this.rulePropertiesPanel = new RulePropertiesPanel(this);
                }
                jPanel = this.rulePropertiesPanel;
                this.nextBtn.setEnabled(false);
                if (this.editRule != null && this.editRule.isDefaultRule()) {
                    this.backBtn.setEnabled(false);
                    break;
                }
                this.backBtn.setEnabled(true);
            }
        }
        this.ruleEditPanel.add(jPanel, "Center");
        this.updateRuleData();
        this.ruleEditPanel.doLayout();
        this.ruleEditPanel.revalidate();
        this.ruleEditPanel.repaint();
        Dimension dimension = this.getPreferredSize();
        Dimension dimension2 = this.getSize();
        if (dimension.height > dimension2.height) {
            int n = Math.max(dimension.height, dimension2.height);
            this.setSize(n * 5 / 4, n);
            this.doLayout();
        }
    }

    private final class CloseEventHandler
    extends WindowAdapter
    implements ActionListener {
        private CloseEventHandler() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            FilterWizardDialog.this.editRule = null;
            FilterWizardDialog.this.closeDialog();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FilterWizardDialog.this.editRule = null;
            FilterWizardDialog.this.closeDialog();
        }
    }

    private final class FinishBtnListener
    implements ActionListener {
        private FinishBtnListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                FilterWizardDialog.this.closeDialog();
            }
            catch (Throwable throwable) {
                NLogger.error("USER_INTERFACE", (Object)throwable, throwable);
            }
        }
    }

    private final class BackBtnListener
    implements ActionListener {
        private BackBtnListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                switch (FilterWizardDialog.this.currentPage) {
                    case 2: {
                        FilterWizardDialog.this.currentPage = 1;
                        break;
                    }
                    case 3: {
                        FilterWizardDialog.this.currentPage = 2;
                        break;
                    }
                    case 4: {
                        FilterWizardDialog.this.currentPage = 3;
                    }
                }
                FilterWizardDialog.this.updatePage();
            }
            catch (Throwable throwable) {
                NLogger.error("USER_INTERFACE", (Object)throwable, throwable);
            }
        }
    }

    private final class NextBtnListener
    implements ActionListener {
        private NextBtnListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                if (!FilterWizardDialog.this.isRuleInputComplete()) {
                    this.displayRuleInputMissingError();
                    return;
                }
                switch (FilterWizardDialog.this.currentPage) {
                    case 1: {
                        FilterWizardDialog.this.currentPage = 2;
                        break;
                    }
                    case 2: {
                        FilterWizardDialog.this.currentPage = 3;
                        break;
                    }
                    case 3: {
                        FilterWizardDialog.this.currentPage = 4;
                    }
                }
                FilterWizardDialog.this.updatePage();
            }
            catch (Throwable throwable) {
                NLogger.error("USER_INTERFACE", (Object)throwable, throwable);
            }
        }

        private void displayRuleInputMissingError() {
            JOptionPane.showMessageDialog(FilterWizardDialog.this, Localizer.getString("RuleWizard_MissingRuleInputText"), Localizer.getString("RuleWizard_MissingRuleInputTitle"), 0);
        }
    }
}

