/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.dialogs.filter.editors;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import phex.gui.common.FWSizeDefComboBox;
import phex.gui.common.IntegerTextField;
import phex.gui.dialogs.filter.ConditionVisualizer;
import phex.gui.dialogs.filter.RuleDescriptionPanel;
import phex.rules.condition.FileSizeCondition;
import phex.utils.Localizer;
import phex.utils.NLogger;

public class FileSizeCondEditor
extends JDialog {
    private RuleDescriptionPanel ruleDescPanel;
    private FileSizeCondition orgCondition;
    private FileSizeCondition condition;
    private JTextField minFileSizeTF;
    private FWSizeDefComboBox minFileSizeUnitComboBox;
    private JTextField maxFileSizeTF;
    private FWSizeDefComboBox maxFileSizeUnitComboBox;
    private JList rangeList;
    private FileSizeRangeModel fileSizeRangeModel;

    public FileSizeCondEditor(FileSizeCondition fileSizeCondition, RuleDescriptionPanel ruleDescriptionPanel, JDialog jDialog) {
        super(jDialog, Localizer.getString("FileSizeCondEditor_DialogTitle"), true);
        this.ruleDescPanel = ruleDescriptionPanel;
        this.orgCondition = fileSizeCondition;
        this.condition = new FileSizeCondition(fileSizeCondition);
        this.prepareComponent();
    }

    private void prepareComponent() {
        CloseEventHandler closeEventHandler = new CloseEventHandler();
        this.addWindowListener(closeEventHandler);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        container.add((Component)jPanel, "Center");
        CellConstraints cellConstraints = new CellConstraints();
        FormLayout formLayout = new FormLayout("4dlu, d, 2dlu, d, 2dlu, d, d:grow, 4dlu, d, 4dlu", "4dlu, p, 2dlu, p, 2dlu, p, 10dlu, p, 2dlu, p, fill:p:grow, 4dlu, p, 2dlu, p 4dlu");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout, jPanel);
        int n = formLayout.getColumnCount();
        int n2 = formLayout.getRowCount();
        JLabel jLabel = new JLabel(Localizer.getString("FileSizeCondEditor_ConditionToAdd"));
        panelBuilder.add((Component)jLabel, cellConstraints.xywh(2, 2, 5, 1));
        jLabel = new JLabel(Localizer.getString("FileSizeCondEditor_Minimum"));
        jLabel.setToolTipText(Localizer.getString("FileSizeCondEditor_TTTMinimum"));
        panelBuilder.add((Component)jLabel, cellConstraints.xywh(2, 4, 1, 1));
        this.minFileSizeTF = new IntegerTextField(9);
        this.minFileSizeTF.setToolTipText(Localizer.getString("FileSizeCondEditor_TTTMinimum"));
        panelBuilder.add((Component)this.minFileSizeTF, cellConstraints.xywh(4, 4, 1, 1));
        this.minFileSizeUnitComboBox = new FWSizeDefComboBox();
        this.minFileSizeUnitComboBox.setToolTipText(Localizer.getString("FileSizeCondEditor_TTTMinimum"));
        panelBuilder.add((Component)this.minFileSizeUnitComboBox, cellConstraints.xywh(6, 4, 1, 1));
        jLabel = new JLabel(Localizer.getString("FileSizeCondEditor_Maximum"));
        panelBuilder.add((Component)jLabel, cellConstraints.xywh(2, 6, 1, 1));
        this.maxFileSizeTF = new IntegerTextField(9);
        this.maxFileSizeTF.setToolTipText(Localizer.getString("FileSizeCondEditor_TTTMaximum"));
        panelBuilder.add((Component)this.maxFileSizeTF, cellConstraints.xywh(4, 6, 1, 1));
        this.maxFileSizeUnitComboBox = new FWSizeDefComboBox();
        this.maxFileSizeUnitComboBox.setToolTipText(Localizer.getString("FileSizeCondEditor_TTTMaximum"));
        panelBuilder.add((Component)this.maxFileSizeUnitComboBox, cellConstraints.xywh(6, 6, 1, 1));
        JButton jButton = new JButton(Localizer.getString("FileSizeCondEditor_Add"));
        jButton.addActionListener(new AddActionListener());
        jButton.setToolTipText(Localizer.getString("FileSizeCondEditor_TTTAdd"));
        panelBuilder.add((Component)jButton, cellConstraints.xywh(9, 6, 1, 1));
        jLabel = new JLabel(Localizer.getString("FileSizeCondEditor_FileSizeConditions"));
        panelBuilder.add((Component)jLabel, cellConstraints.xywh(2, 8, 5, 1));
        this.fileSizeRangeModel = new FileSizeRangeModel();
        this.rangeList = new JList(this.fileSizeRangeModel);
        this.rangeList.setCellRenderer(new FileSizeRangeRenderer());
        panelBuilder.add((Component)new JScrollPane(this.rangeList), cellConstraints.xywh(2, 10, 6, 2));
        JButton jButton2 = new JButton(Localizer.getString("FileSizeCondEditor_Remove"));
        jButton2.addActionListener(new RemoveActionListener());
        jButton2.setToolTipText(Localizer.getString("FileSizeCondEditor_TTTRemove"));
        panelBuilder.add((Component)jButton2, cellConstraints.xywh(9, 10, 1, 1));
        panelBuilder.add((Component)new JSeparator(), cellConstraints.xywh(1, n2 - 3, n, 1));
        JButton jButton3 = new JButton(Localizer.getString("OK"));
        jButton3.addActionListener(new OkBtnListener());
        jButton3.setDefaultCapable(true);
        jButton3.setRequestFocusEnabled(true);
        JButton jButton4 = new JButton(Localizer.getString("Cancel"));
        jButton4.addActionListener(closeEventHandler);
        JPanel jPanel2 = ButtonBarFactory.buildOKCancelBar(jButton3, jButton4);
        panelBuilder.add((Component)jPanel2, cellConstraints.xywh(2, n2 - 1, n - 2, 1));
        this.setDefaultCloseOperation(2);
        this.getRootPane().setDefaultButton(jButton3);
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    public final class FileSizeRangeRenderer
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (object == null) {
                this.setText("");
            } else {
                StringBuffer stringBuffer = new StringBuffer();
                ConditionVisualizer.visualizeFileSizeRange(stringBuffer, (FileSizeCondition.Range)object);
                this.setText(stringBuffer.toString());
            }
            return this;
        }
    }

    public final class FileSizeRangeModel
    extends AbstractListModel {
        public int getSize() {
            return FileSizeCondEditor.this.condition.getRangesCount();
        }

        public Object getElementAt(int n) {
            return FileSizeCondEditor.this.condition.getRangesList().get(n);
        }

        public void fireChange() {
            this.fireContentsChanged(this, 0, Integer.MAX_VALUE);
        }
    }

    private final class CloseEventHandler
    extends WindowAdapter
    implements ActionListener {
        private CloseEventHandler() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            FileSizeCondEditor.this.closeDialog();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FileSizeCondEditor.this.closeDialog();
        }
    }

    private final class OkBtnListener
    implements ActionListener {
        private OkBtnListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                FileSizeCondEditor.this.orgCondition.update(FileSizeCondEditor.this.condition);
                FileSizeCondEditor.this.closeDialog();
            }
            catch (Throwable throwable) {
                NLogger.error("USER_INTERFACE", (Object)throwable, throwable);
            }
        }
    }

    private final class RemoveActionListener
    implements ActionListener {
        private RemoveActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            int n2 = FileSizeCondEditor.this.rangeList.getSelectedIndex();
            Object[] objectArray = FileSizeCondEditor.this.rangeList.getSelectedValues();
            for (n = 0; n < objectArray.length; ++n) {
                FileSizeCondEditor.this.condition.removeRange((FileSizeCondition.Range)objectArray[n]);
            }
            FileSizeCondEditor.this.fileSizeRangeModel.fireChange();
            n = FileSizeCondEditor.this.fileSizeRangeModel.getSize();
            if (n == 0) {
                FileSizeCondEditor.this.minFileSizeTF.requestFocusInWindow();
            } else {
                FileSizeCondEditor.this.rangeList.setSelectedIndex(Math.max(0, Math.min(n2, n - 1)));
            }
        }
    }

    private final class AddActionListener
    implements ActionListener {
        private AddActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            long l;
            long l2;
            String string = FileSizeCondEditor.this.minFileSizeTF.getText().trim();
            String string2 = FileSizeCondEditor.this.maxFileSizeTF.getText().trim();
            long l3 = -1L;
            try {
                if (string.length() > 0) {
                    l2 = Integer.parseInt(string);
                    l = FileSizeCondEditor.this.minFileSizeUnitComboBox.getDefMultiplier();
                    l3 = l * l2;
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.displayWrongNumberFormatError(FileSizeCondEditor.this.minFileSizeTF);
                return;
            }
            l2 = -1L;
            try {
                if (string2.length() > 0) {
                    l = Integer.parseInt(string2);
                    long l4 = FileSizeCondEditor.this.maxFileSizeUnitComboBox.getDefMultiplier();
                    l2 = l4 * l;
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.displayWrongNumberFormatError(FileSizeCondEditor.this.maxFileSizeTF);
                return;
            }
            if (l3 == -1L && l2 == -1L) {
                return;
            }
            FileSizeCondEditor.this.condition.addRange(l3, l2);
            FileSizeCondEditor.this.minFileSizeTF.setText("");
            FileSizeCondEditor.this.maxFileSizeTF.setText("");
            FileSizeCondEditor.this.fileSizeRangeModel.fireChange();
            FileSizeCondEditor.this.minFileSizeTF.requestFocusInWindow();
        }

        private void displayWrongNumberFormatError(JTextField jTextField) {
            jTextField.requestFocus();
            jTextField.selectAll();
            JOptionPane.showMessageDialog(FileSizeCondEditor.this, Localizer.getString("WrongNumberFormat"), Localizer.getString("FormatError"), 0);
        }
    }
}

