/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.dialogs.filter;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ListModel;
import javax.swing.event.EventListenerList;
import phex.gui.dialogs.filter.RuleEditWrapper;
import phex.query.QueryManager;
import phex.rules.Rule;
import phex.rules.SearchFilterRules;

public class SearchFilterRulesEditModel
extends AbstractListModel
implements ListModel {
    protected EventListenerList listenerList = new EventListenerList();
    private List allRules;

    public SearchFilterRulesEditModel() {
        SearchFilterRules searchFilterRules = QueryManager.getInstance().getSearchFilterRules();
        this.allRules = new ArrayList();
        this.allRules.addAll(searchFilterRules.getAsList());
    }

    public void applyChangesToQueryManager() {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.allRules.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof Rule) {
                arrayList.add(e);
                continue;
            }
            RuleEditWrapper ruleEditWrapper = (RuleEditWrapper)e;
            Rule rule = ruleEditWrapper.getModifiedRule();
            if (rule == null) continue;
            arrayList.add(rule);
        }
        QueryManager.getInstance().getSearchFilterRules().setRuleList(arrayList);
    }

    public void addNewRule(Rule rule) {
        RuleEditWrapper ruleEditWrapper = new RuleEditWrapper(rule);
        int n = this.allRules.size();
        this.allRules.add(n, ruleEditWrapper);
        this.fireIntervalAdded(this, n, n);
    }

    public int moveRule(int n, boolean bl) {
        Object e = this.allRules.remove(n);
        int n2 = bl ? Math.max(0, n - 1) : Math.min(n + 1, this.allRules.size());
        this.allRules.add(n2, e);
        int n3 = Math.min(n, n2);
        int n4 = Math.max(n, n2);
        this.fireContentsChanged(this, n3, n4);
        return n2;
    }

    public void removeRule(int n) {
        RuleEditWrapper ruleEditWrapper = this.getRuleEditWrapperAt(n);
        ruleEditWrapper.setModifiedRule(null);
        this.allRules.remove(n);
        this.fireIntervalRemoved(this, n, n);
    }

    public void updateRule(int n, Rule rule) {
        RuleEditWrapper ruleEditWrapper = (RuleEditWrapper)this.allRules.get(n);
        ruleEditWrapper.setModifiedRule(rule);
        this.fireContentsChanged(this, n, n);
    }

    public Rule getDisplayRuleAt(int n) {
        RuleEditWrapper ruleEditWrapper;
        Object e = this.allRules.get(n);
        if (e instanceof Rule) {
            ruleEditWrapper = this.createRuleEditWrapper((Rule)e);
            this.allRules.remove(n);
            this.allRules.add(n, ruleEditWrapper);
        } else {
            ruleEditWrapper = (RuleEditWrapper)e;
        }
        return ruleEditWrapper.getModifiedRule();
    }

    private RuleEditWrapper getRuleEditWrapperAt(int n) {
        RuleEditWrapper ruleEditWrapper;
        Object e = this.allRules.get(n);
        if (e instanceof Rule) {
            ruleEditWrapper = this.createRuleEditWrapper((Rule)e);
            this.allRules.remove(n);
            this.allRules.add(n, ruleEditWrapper);
        } else {
            ruleEditWrapper = (RuleEditWrapper)e;
        }
        return ruleEditWrapper;
    }

    private RuleEditWrapper createRuleEditWrapper(Rule rule) {
        Rule rule2 = (Rule)rule.clone();
        RuleEditWrapper ruleEditWrapper = new RuleEditWrapper(rule2);
        return ruleEditWrapper;
    }

    public int getSize() {
        return this.allRules.size();
    }

    public Object getElementAt(int n) {
        return this.allRules.get(n);
    }
}

