/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.dialogs.filter;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import phex.utils.JDKUtils;
import phex.utils.Localizer;

public class RuleDescriptionVisualizer {
    protected static final Pattern REPL_PATTERN = Pattern.compile("--__.*__--");

    public static String cleanDisplayString(String string) {
        int n = string.indexOf("--__");
        int n2 = string.indexOf("__--");
        if (n == -1 || n2 == -1) {
            return string;
        }
        return string.substring(0, n) + string.substring(n + 4, n2) + string.substring(n2 + 4, string.length());
    }

    public static void insertDisplayString(String string, Object object, Document document) throws BadLocationException {
        int n = string.indexOf("--__");
        int n2 = string.indexOf("__--");
        if (n == -1 || n2 == -1) {
            RuleDescriptionVisualizer.insertStandardPart(string, object, document);
        } else {
            RuleDescriptionVisualizer.insertStandardPart(string.substring(0, n), object, document);
            RuleDescriptionVisualizer.insertLinkPart(string.substring(n + 4, n2), object, document);
            RuleDescriptionVisualizer.insertStandardPart(string.substring(n2 + 4, string.length()), object, document);
        }
    }

    protected static void insertLinkPart(String string, Object object, Document document) throws BadLocationException {
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        simpleAttributeSet.addAttribute("Link", object);
        simpleAttributeSet.addAttribute("RuleObjReference", object);
        StyleConstants.setUnderline(simpleAttributeSet, true);
        document.insertString(document.getLength(), string, simpleAttributeSet);
    }

    protected static void insertStandardPart(String string, Object object, Document document) throws BadLocationException {
        if (string.length() == 0) {
            return;
        }
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        simpleAttributeSet.addAttribute("RuleObjReference", object);
        document.insertString(document.getLength(), string, simpleAttributeSet);
    }

    public static void visualizeNext(boolean bl, Object object, Document document) throws BadLocationException {
        RuleDescriptionVisualizer.insertStandardPart("\n", object, document);
        if (bl) {
            RuleDescriptionVisualizer.insertStandardPart(Localizer.getString("RuleVisualization_And") + " ", object, document);
        }
    }

    public static String replacePlaceholderPattern(String string, String string2) {
        Matcher matcher = REPL_PATTERN.matcher(string);
        string2 = JDKUtils.Matcher_quoteReplacement(string2);
        return matcher.replaceAll("--__" + string2 + "__--");
    }
}

