/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.dialogs.filter;

import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import phex.gui.dialogs.filter.RuleDescriptionVisualizer;
import phex.rules.consequence.Consequence;
import phex.rules.consequence.FilterFromSearchConsequence;
import phex.rules.consequence.RemoveFromSearchConsequence;
import phex.utils.Localizer;

public class ConsequenceVisualizer {
    public static String buildDisplayString(Consequence consequence) {
        if (consequence instanceof FilterFromSearchConsequence) {
            String string = Localizer.getString("RuleVisualization_HideFromSearchConseq");
            return string;
        }
        if (consequence instanceof RemoveFromSearchConsequence) {
            String string = Localizer.getString("RuleVisualization_RemoveFromSearchConseq");
            return string;
        }
        throw new IllegalArgumentException("Unknown consequence to visualize: " + consequence);
    }

    public static String buildCleanDisplayString(Consequence consequence) {
        String string = ConsequenceVisualizer.buildDisplayString(consequence);
        return RuleDescriptionVisualizer.cleanDisplayString(string);
    }

    public static void visualize(Consequence consequence, boolean bl, Document document) throws BadLocationException {
        RuleDescriptionVisualizer.visualizeNext(bl, consequence, document);
        String string = ConsequenceVisualizer.buildDisplayString(consequence);
        RuleDescriptionVisualizer.insertDisplayString(string, consequence, document);
    }
}

