/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.dialogs.filter;

import java.util.Iterator;
import java.util.Set;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import phex.common.MediaType;
import phex.common.format.NumberFormatUtils;
import phex.gui.dialogs.filter.RuleDescriptionVisualizer;
import phex.rules.condition.Condition;
import phex.rules.condition.FileSizeCondition;
import phex.rules.condition.FilenameCondition;
import phex.rules.condition.MediaTypeCondition;
import phex.rules.condition.NotCondition;
import phex.utils.Localizer;

public class ConditionVisualizer {
    public static String buildDisplayString(Condition condition) {
        String string = "";
        if (condition instanceof NotCondition) {
            string = "_Not";
            condition = ((NotCondition)condition).getContainedCondition();
        }
        if (condition instanceof FilenameCondition) {
            FilenameCondition filenameCondition = (FilenameCondition)condition;
            String string2 = Localizer.getString("RuleVisualization_FilenameCond" + string);
            Set set = filenameCondition.getTerms();
            if (set.size() > 0) {
                String string3;
                Iterator iterator = set.iterator();
                StringBuffer stringBuffer = new StringBuffer();
                while (iterator.hasNext()) {
                    string3 = (String)iterator.next();
                    stringBuffer.append("'").append(string3).append("'");
                    if (!iterator.hasNext()) continue;
                    stringBuffer.append(" ").append(Localizer.getString("RuleVisualization_Or")).append(" ");
                }
                string3 = stringBuffer.toString();
                string2 = RuleDescriptionVisualizer.replacePlaceholderPattern(string2, string3);
            }
            return string2;
        }
        if (condition instanceof MediaTypeCondition) {
            MediaTypeCondition mediaTypeCondition = (MediaTypeCondition)condition;
            String string4 = Localizer.getString("RuleVisualization_MediaTypeCond" + string);
            Set set = mediaTypeCondition.getTypes();
            if (set.size() > 0) {
                Object object;
                Iterator iterator = set.iterator();
                StringBuffer stringBuffer = new StringBuffer();
                while (iterator.hasNext()) {
                    object = (MediaType)iterator.next();
                    stringBuffer.append("'").append(Localizer.getString(((MediaType)object).getName())).append("'");
                    if (!iterator.hasNext()) continue;
                    stringBuffer.append(" ").append(Localizer.getString("RuleVisualization_Or")).append(" ");
                }
                object = stringBuffer.toString();
                string4 = RuleDescriptionVisualizer.replacePlaceholderPattern(string4, (String)object);
            }
            return string4;
        }
        if (condition instanceof FileSizeCondition) {
            FileSizeCondition fileSizeCondition = (FileSizeCondition)condition;
            String string5 = Localizer.getString("RuleVisualization_FileSizeCond" + string);
            Set set = fileSizeCondition.getRanges();
            if (set.size() > 0) {
                Object object;
                Iterator iterator = set.iterator();
                StringBuffer stringBuffer = new StringBuffer();
                while (iterator.hasNext()) {
                    object = (FileSizeCondition.Range)iterator.next();
                    ConditionVisualizer.visualizeFileSizeRange(stringBuffer, (FileSizeCondition.Range)object);
                    if (!iterator.hasNext()) continue;
                    stringBuffer.append(" ").append(Localizer.getString("RuleVisualization_Or")).append(" ");
                }
                object = stringBuffer.toString();
                string5 = RuleDescriptionVisualizer.replacePlaceholderPattern(string5, (String)object);
            }
            return string5;
        }
        throw new IllegalArgumentException("Unknown condition to visualize: " + condition);
    }

    public static String buildCleanDisplayString(Condition condition) {
        String string = ConditionVisualizer.buildDisplayString(condition);
        return RuleDescriptionVisualizer.cleanDisplayString(string);
    }

    public static void visualize(Condition condition, boolean bl, Document document) throws BadLocationException {
        RuleDescriptionVisualizer.visualizeNext(bl, condition, document);
        String string = ConditionVisualizer.buildDisplayString(condition);
        RuleDescriptionVisualizer.insertDisplayString(string, condition, document);
    }

    public static void visualizeFileSizeRange(StringBuffer stringBuffer, FileSizeCondition.Range range) {
        if (range.min > 0L) {
            stringBuffer.append(Localizer.getString("RuleVisualization_FileSizeCond_Min")).append(" ").append(NumberFormatUtils.formatSignificantByteSize(range.min));
        }
        if (range.min > 0L && range.max > 0L) {
            stringBuffer.append(" ").append(Localizer.getString("RuleVisualization_And")).append(" ");
        }
        if (range.max > 0L) {
            stringBuffer.append(Localizer.getString("RuleVisualization_FileSizeCond_Max")).append(" ").append(NumberFormatUtils.formatSignificantByteSize(range.max));
        }
    }
}

