/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.dialogs;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import phex.common.ExpiryDate;
import phex.common.address.AddressUtils;
import phex.gui.common.GUIRegistry;
import phex.gui.common.GUIUtils;
import phex.gui.common.IPTextField;
import phex.gui.common.IntegerTextField;
import phex.security.IPAccessRule;
import phex.security.PhexSecurityManager;
import phex.utils.Localizer;

public class SecurityRuleConfigDialog
extends JDialog {
    private static final long MINUTE = 60000L;
    private static final long HOUR = 3600000L;
    private static final long DAY = 86400000L;
    private IPAccessRule securityRule;
    private JTextField descriptionTF;
    private JCheckBox disableRuleCkBx;
    private JComboBox addressTypeCBox;
    private JLabel firstIPLabel;
    private IPTextField firstIPField;
    private JLabel secondIPLabel;
    private IPTextField secondIPField;
    private JComboBox expiresCBox;
    private JComboBox ruleTypeCBox;
    private IntegerTextField daysTF;
    private JLabel daysLabel;
    private IntegerTextField hoursTF;
    private JLabel hoursLabel;
    private IntegerTextField minutesTF;
    private JLabel minutesLabel;
    private JCheckBox isDeletedOnExpiryCkbx;

    public SecurityRuleConfigDialog() {
        this((IPAccessRule)null);
    }

    public SecurityRuleConfigDialog(IPAccessRule iPAccessRule) {
        super(GUIRegistry.getInstance().getMainFrame(), Localizer.getString("NewSecurityRule"), true);
        this.securityRule = iPAccessRule;
        this.prepareComponent();
    }

    private void prepareComponent() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                SecurityRuleConfigDialog.this.closeDialog();
            }
        });
        Container container = this.getContentPane();
        container.setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        container.add((Component)jPanel, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Localizer.getString("SecurityRule")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        JLabel jLabel = new JLabel(Localizer.getString("Description") + Localizer.getString("ColonSign"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 2, 2, 4);
        gridBagConstraints.anchor = 13;
        jPanel2.add((Component)jLabel, gridBagConstraints);
        this.descriptionTF = new JTextField(20);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 2, 2);
        gridBagConstraints.anchor = 17;
        jPanel2.add((Component)this.descriptionTF, gridBagConstraints);
        this.disableRuleCkBx = new JCheckBox(Localizer.getString("DisableSecurityRule"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(0, 0, 2, 4);
        gridBagConstraints.anchor = 17;
        jPanel2.add((Component)this.disableRuleCkBx, gridBagConstraints);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Localizer.getString("NetworkAddress")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 2, 2, 2);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)jPanel3, gridBagConstraints);
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        jPanel3.add((Component)jPanel4, gridBagConstraints);
        JLabel jLabel2 = new JLabel(Localizer.getString("AddressType") + Localizer.getString("ColonSign"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 2, 0, 4);
        gridBagConstraints.anchor = 13;
        jPanel4.add((Component)jLabel2, gridBagConstraints);
        String[] stringArray = new String[]{Localizer.getString("SingleAddress"), Localizer.getString("Network/Range"), Localizer.getString("Network/Mask")};
        this.addressTypeCBox = new JComboBox<String>(stringArray);
        this.addressTypeCBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SecurityRuleConfigDialog.this.refreshAddressDisplayState();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.anchor = 17;
        jPanel4.add((Component)this.addressTypeCBox, gridBagConstraints);
        JPanel jPanel5 = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(8, 1, 0, 0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        jPanel3.add((Component)jPanel5, gridBagConstraints);
        this.firstIPLabel = new JLabel(Localizer.getString("HostAddress") + Localizer.getString("ColonSign"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 2, 2, 4);
        gridBagConstraints.anchor = 13;
        jPanel5.add((Component)this.firstIPLabel, gridBagConstraints);
        this.secondIPLabel = new JLabel(Localizer.getString("NetworkMask") + Localizer.getString("ColonSign"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 2, 0, 4);
        gridBagConstraints.anchor = 13;
        jPanel5.add((Component)this.secondIPLabel, gridBagConstraints);
        this.firstIPField = new IPTextField();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 2, 2);
        gridBagConstraints.anchor = 17;
        jPanel5.add((Component)this.firstIPField, gridBagConstraints);
        this.secondIPField = new IPTextField();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 2);
        gridBagConstraints.anchor = 17;
        jPanel5.add((Component)this.secondIPField, gridBagConstraints);
        JPanel jPanel6 = new JPanel(new GridBagLayout());
        jPanel6.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Localizer.getString("Options")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 2, 2, 2);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)jPanel6, gridBagConstraints);
        JLabel jLabel3 = new JLabel(Localizer.getString("ActionType") + Localizer.getString("ColonSign"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 2, 6, 4);
        gridBagConstraints.anchor = 13;
        jPanel6.add((Component)jLabel3, gridBagConstraints);
        String[] stringArray2 = new String[]{Localizer.getString("Deny"), Localizer.getString("Accept")};
        this.ruleTypeCBox = new JComboBox<String>(stringArray2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        gridBagConstraints.anchor = 17;
        jPanel6.add((Component)this.ruleTypeCBox, gridBagConstraints);
        JLabel jLabel4 = new JLabel(Localizer.getString("Expires") + Localizer.getString("ColonSign"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 2, 2, 4);
        gridBagConstraints.anchor = 13;
        jPanel6.add((Component)jLabel4, gridBagConstraints);
        String[] stringArray3 = new String[]{Localizer.getString("Never"), Localizer.getString("EndOfSession"), Localizer.getString("After") + Localizer.getString("ColonSign")};
        this.expiresCBox = new JComboBox<String>(stringArray3);
        this.expiresCBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SecurityRuleConfigDialog.this.refreshExpiryDisplayState();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 2);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        jPanel6.add((Component)this.expiresCBox, gridBagConstraints);
        JPanel jPanel7 = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        jPanel6.add((Component)jPanel7, gridBagConstraints);
        this.daysTF = new IntegerTextField(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.anchor = 17;
        jPanel7.add((Component)this.daysTF, gridBagConstraints);
        this.daysLabel = new JLabel(Localizer.getString("Days"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        gridBagConstraints.anchor = 17;
        jPanel7.add((Component)this.daysLabel, gridBagConstraints);
        this.hoursTF = new IntegerTextField(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        gridBagConstraints.anchor = 17;
        jPanel7.add((Component)this.hoursTF, gridBagConstraints);
        this.hoursLabel = new JLabel(Localizer.getString("Hours"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        gridBagConstraints.anchor = 17;
        jPanel7.add((Component)this.hoursLabel, gridBagConstraints);
        this.minutesTF = new IntegerTextField(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        gridBagConstraints.anchor = 17;
        jPanel7.add((Component)this.minutesTF, gridBagConstraints);
        this.minutesLabel = new JLabel(Localizer.getString("Minutes"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        gridBagConstraints.anchor = 17;
        jPanel7.add((Component)this.minutesLabel, gridBagConstraints);
        this.isDeletedOnExpiryCkbx = new JCheckBox(Localizer.getString("DeleteRuleAfterExpiry"));
        this.isDeletedOnExpiryCkbx.setToolTipText(Localizer.getString("TTTDeleteRuleAfterExpiry"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 2);
        gridBagConstraints.anchor = 18;
        jPanel6.add((Component)this.isDeletedOnExpiryCkbx, gridBagConstraints);
        JPanel jPanel8 = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        gridBagConstraints.anchor = 16;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)jPanel8, gridBagConstraints);
        JSeparator jSeparator = new JSeparator();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 6, 0);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        jPanel8.add((Component)jSeparator, gridBagConstraints);
        ButtonActionHandler buttonActionHandler = new ButtonActionHandler();
        JButton jButton = new JButton(Localizer.getString("OK"));
        jButton.setDefaultCapable(true);
        jButton.setRequestFocusEnabled(true);
        jButton.addActionListener(buttonActionHandler);
        jButton.setActionCommand("OK");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.fill = 0;
        jPanel8.add((Component)jButton, gridBagConstraints);
        JButton jButton2 = new JButton(Localizer.getString("Cancel"));
        jButton2.setRequestFocusEnabled(true);
        jButton2.addActionListener(buttonActionHandler);
        jButton2.setActionCommand("CANCEL");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.weighty = 1.0;
        jPanel8.add((Component)jButton2, gridBagConstraints);
        GUIUtils.adjustComboBoxHeight(this.expiresCBox);
        GUIUtils.adjustComboBoxHeight(this.ruleTypeCBox);
        GUIUtils.adjustComboBoxHeight(this.addressTypeCBox);
        this.initContent();
        this.refreshAddressDisplayState();
        this.refreshExpiryDisplayState();
        this.setDefaultCloseOperation(2);
        this.getRootPane().setDefaultButton(jButton);
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    private void initContent() {
        if (this.securityRule == null) {
            return;
        }
        this.descriptionTF.setText(this.securityRule.getDescription());
        byte by = this.securityRule.getAddressType();
        switch (by) {
            case 1: {
                this.addressTypeCBox.setSelectedIndex(0);
                this.firstIPField.setIPString(AddressUtils.ip2string(this.securityRule.getHostIP()));
                break;
            }
            case 3: {
                this.addressTypeCBox.setSelectedIndex(1);
                this.firstIPField.setIPString(AddressUtils.ip2string(this.securityRule.getHostIP()));
                this.secondIPField.setIPString(AddressUtils.ip2string(this.securityRule.getCompareIP()));
                break;
            }
            case 2: {
                this.addressTypeCBox.setSelectedIndex(2);
                this.firstIPField.setIPString(AddressUtils.ip2string(this.securityRule.getHostIP()));
                this.secondIPField.setIPString(AddressUtils.ip2string(this.securityRule.getCompareIP()));
            }
        }
        boolean bl = this.securityRule.isDenyingRule();
        if (bl) {
            this.ruleTypeCBox.setSelectedIndex(0);
        } else {
            this.ruleTypeCBox.setSelectedIndex(1);
        }
        this.disableRuleCkBx.setSelected(this.securityRule.isDisabled());
        ExpiryDate expiryDate = this.securityRule.getExpiryDate();
        if (expiryDate.isExpiringNever()) {
            this.expiresCBox.setSelectedIndex(0);
        } else if (expiryDate.isExpiringEndOfSession()) {
            this.expiresCBox.setSelectedIndex(1);
        } else {
            this.expiresCBox.setSelectedIndex(2);
            this.initAfterExpiryDateContent(expiryDate);
        }
        this.isDeletedOnExpiryCkbx.setSelected(this.securityRule.isDeletedOnExpiry());
    }

    public void customPrefillBanSingleIp(String string, byte[] byArray) {
        this.descriptionTF.setText(string);
        this.addressTypeCBox.setSelectedIndex(0);
        this.firstIPField.setIPString(AddressUtils.ip2string(byArray));
        this.ruleTypeCBox.setSelectedIndex(0);
        this.disableRuleCkBx.setSelected(false);
        this.expiresCBox.setSelectedIndex(1);
        this.isDeletedOnExpiryCkbx.setSelected(false);
    }

    private void refreshAddressDisplayState() {
        if (Localizer.getString("SingleAddress").equals(this.addressTypeCBox.getSelectedItem())) {
            this.firstIPLabel.setText(Localizer.getString("HostAddress") + Localizer.getString("ColonSign"));
            this.secondIPLabel.setText(Localizer.getString("NetworkMask") + Localizer.getString("ColonSign"));
            this.secondIPLabel.setEnabled(false);
            this.secondIPField.setEnabled(false);
            this.secondIPField.setIPString("255.255.255.255");
        } else if (Localizer.getString("Network/Range").equals(this.addressTypeCBox.getSelectedItem())) {
            this.firstIPLabel.setText(Localizer.getString("FirstAddress") + Localizer.getString("ColonSign"));
            this.secondIPLabel.setText(Localizer.getString("LastAddress") + Localizer.getString("ColonSign"));
            this.secondIPLabel.setEnabled(true);
            this.secondIPField.setEnabled(true);
        } else if (Localizer.getString("Network/Mask").equals(this.addressTypeCBox.getSelectedItem())) {
            this.firstIPLabel.setText(Localizer.getString("NetworkAddress") + Localizer.getString("ColonSign"));
            this.secondIPLabel.setText(Localizer.getString("NetworkMask") + Localizer.getString("ColonSign"));
            this.secondIPLabel.setEnabled(true);
            this.secondIPField.setEnabled(true);
        }
    }

    private void refreshExpiryDisplayState() {
        if (Localizer.getString("Never").equals(this.expiresCBox.getSelectedItem())) {
            this.isDeletedOnExpiryCkbx.setEnabled(false);
            this.daysTF.setEnabled(false);
            this.daysLabel.setEnabled(false);
            this.hoursTF.setEnabled(false);
            this.hoursLabel.setEnabled(false);
            this.minutesTF.setEnabled(false);
            this.minutesLabel.setEnabled(false);
        } else if (Localizer.getString("EndOfSession").equals(this.expiresCBox.getSelectedItem())) {
            this.isDeletedOnExpiryCkbx.setEnabled(true);
            this.daysTF.setEnabled(false);
            this.daysLabel.setEnabled(false);
            this.hoursTF.setEnabled(false);
            this.hoursLabel.setEnabled(false);
            this.minutesTF.setEnabled(false);
            this.minutesLabel.setEnabled(false);
        } else if ((Localizer.getString("After") + Localizer.getString("ColonSign")).equals(this.expiresCBox.getSelectedItem())) {
            this.isDeletedOnExpiryCkbx.setEnabled(true);
            this.daysTF.setEnabled(true);
            this.daysLabel.setEnabled(true);
            this.hoursTF.setEnabled(true);
            this.hoursLabel.setEnabled(true);
            this.minutesTF.setEnabled(true);
            this.minutesLabel.setEnabled(true);
        }
    }

    private void validateAndSaveSecurityRule() {
        ExpiryDate expiryDate;
        byte[] byArray;
        byte[] byArray2;
        byte by;
        String string = this.descriptionTF.getText();
        boolean bl = this.ruleTypeCBox.getSelectedIndex() == 0;
        switch (this.addressTypeCBox.getSelectedIndex()) {
            case 0: {
                by = 1;
                byArray2 = this.firstIPField.getIP();
                byArray = null;
                break;
            }
            case 1: {
                by = 3;
                byArray2 = this.firstIPField.getIP();
                byArray = this.secondIPField.getIP();
                break;
            }
            case 2: {
                by = 2;
                byArray2 = this.firstIPField.getIP();
                byArray = this.secondIPField.getIP();
                break;
            }
            default: {
                throw new RuntimeException("Unknown address type: " + this.addressTypeCBox.getSelectedIndex());
            }
        }
        boolean bl2 = this.disableRuleCkBx.isSelected();
        switch (this.expiresCBox.getSelectedIndex()) {
            case 0: {
                expiryDate = ExpiryDate.NEVER_EXPIRY_DATE;
                break;
            }
            case 1: {
                expiryDate = ExpiryDate.SESSION_EXPIRY_DATE;
                break;
            }
            case 2: {
                expiryDate = this.createAfterExpiryDate();
                break;
            }
            default: {
                throw new RuntimeException("Unknown expiry type: " + this.expiresCBox.getSelectedIndex());
            }
        }
        boolean bl3 = this.isDeletedOnExpiryCkbx.isSelected();
        if (this.securityRule == null) {
            PhexSecurityManager.getInstance().createIPAccessRule(string, bl, by, byArray2, byArray, bl2, expiryDate, bl3);
        } else {
            this.securityRule.setHostIP(byArray2);
            this.securityRule.setCompareIP(byArray);
            this.securityRule.setDescription(string);
            this.securityRule.setDenyingRule(bl);
            this.securityRule.setAddressType(by);
            this.securityRule.setDisabled(bl2);
            this.securityRule.setExpiryDate(expiryDate);
            this.securityRule.setDeleteOnExpiry(bl3);
        }
    }

    private void initAfterExpiryDateContent(ExpiryDate expiryDate) {
        int n;
        int n2;
        int n3;
        long l;
        long l2 = expiryDate.getTime();
        long l3 = l2 - (l = System.currentTimeMillis());
        if (l3 <= 0L) {
            n3 = 0;
            n2 = 0;
            n = 0;
        } else {
            n3 = (int)Math.floor(l3 / 86400000L);
            n2 = (int)Math.floor((l3 -= (long)n3 * 86400000L) / 3600000L);
            n = (int)Math.ceil((l3 -= (long)n2 * 3600000L) / 60000L);
        }
        this.daysTF.setText(String.valueOf(n3));
        this.hoursTF.setText(String.valueOf(n2));
        this.minutesTF.setText(String.valueOf(n));
    }

    private ExpiryDate createAfterExpiryDate() {
        Integer n;
        Integer n2;
        Integer n3 = this.daysTF.getIntegerValue();
        if (n3 == null) {
            n3 = new Integer(0);
        }
        if ((n2 = this.hoursTF.getIntegerValue()) == null) {
            n2 = new Integer(0);
        }
        if ((n = this.minutesTF.getIntegerValue()) == null) {
            n = new Integer(0);
        }
        long l = System.currentTimeMillis();
        return ExpiryDate.getExpiryDate(l += (long)n3.intValue() * 86400000L + (long)n2.intValue() * 3600000L + (long)n.intValue() * 60000L);
    }

    private class ButtonActionHandler
    implements ActionListener {
        private ButtonActionHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getActionCommand().equals("OK")) {
                SecurityRuleConfigDialog.this.validateAndSaveSecurityRule();
            }
            SecurityRuleConfigDialog.this.closeDialog();
        }
    }
}

