/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.dialogs;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import org.apache.commons.lang.SystemUtils;
import phex.Res;
import phex.gui.common.DialogBanner;
import phex.gui.common.GUIRegistry;
import phex.gui.common.HTMLMultiLinePanel;
import phex.utils.Localizer;
import phex.utils.VersionUtils;

public class AboutDialog
extends JDialog {
    private JTextArea environmentInfo;

    public AboutDialog() {
        super(GUIRegistry.getInstance().getMainFrame(), Localizer.getString("AboutPhex_DialogTitle"), false);
        this.prepareComponent();
    }

    private void prepareComponent() {
        Object object;
        CloseEventHandler closeEventHandler = new CloseEventHandler();
        this.addWindowListener(closeEventHandler);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        container.add((Component)jPanel, "Center");
        CellConstraints cellConstraints = new CellConstraints();
        FormLayout formLayout = new FormLayout("4dlu, fill:d:grow, 4dlu", "p, p, 2dlu, p, 4dlu, p, 4dlu");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout, jPanel);
        Object[] objectArray = new Object[]{"" + VersionUtils.getProgramVersion(), VersionUtils.getBuild()};
        DialogBanner dialogBanner = new DialogBanner("Phex", Localizer.getFormatedString("AboutPhex_VersionInfo", objectArray));
        panelBuilder.add((Component)dialogBanner, cellConstraints.xywh(1, 1, 3, 1));
        panelBuilder.add((Component)new JSeparator(), cellConstraints.xywh(1, 2, 3, 1));
        JTabbedPane jTabbedPane = new JTabbedPane();
        panelBuilder.add((Component)jTabbedPane, cellConstraints.xy(2, 4));
        JButton jButton = new JButton(Localizer.getString("Close"));
        jButton.addActionListener(closeEventHandler);
        panelBuilder.add((Component)ButtonBarFactory.buildCloseBar(jButton), cellConstraints.xy(2, 6));
        JPanel jPanel2 = new JPanel();
        formLayout = new FormLayout("4dlu, fill:d:grow, 4dlu", "4dlu, p, 4dlu");
        PanelBuilder panelBuilder2 = new PanelBuilder(formLayout, jPanel2);
        jTabbedPane.addTab(Localizer.getString("AboutPhex_About"), jPanel2);
        Object[] objectArray2 = new Object[]{Res.getStr("Program.Url")};
        HTMLMultiLinePanel hTMLMultiLinePanel = new HTMLMultiLinePanel(Localizer.getFormatedString("AboutPhex_AboutText", objectArray2));
        panelBuilder2.add((Component)hTMLMultiLinePanel, cellConstraints.xy(2, 2));
        JPanel jPanel3 = new JPanel();
        formLayout = new FormLayout("2dlu, fill:d:grow, 2dlu", "2dlu, p, 2dlu, p, 2dlu");
        PanelBuilder panelBuilder3 = new PanelBuilder(formLayout, jPanel3);
        jTabbedPane.addTab(Localizer.getString("AboutPhex_Environment"), jPanel3);
        this.environmentInfo = new JTextArea(12, 55);
        this.environmentInfo.setEditable(false);
        panelBuilder3.add((Component)new JScrollPane(this.environmentInfo), cellConstraints.xy(2, 2));
        StringBuffer stringBuffer = new StringBuffer();
        Properties properties = System.getProperties();
        ArrayList<Object> arrayList = new ArrayList<Object>(properties.keySet());
        Collections.sort(arrayList);
        Iterator<Object> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            String string = (String)properties.get(object);
            stringBuffer.append((String)object).append(" = ").append(string).append(SystemUtils.LINE_SEPARATOR);
        }
        this.environmentInfo.setText(stringBuffer.toString());
        this.environmentInfo.setCaretPosition(0);
        object = new JButton(Localizer.getString("Copy"));
        ((AbstractButton)object).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(AboutDialog.this.environmentInfo.getText()), null);
            }
        });
        panelBuilder3.add((Component)ButtonBarFactory.buildLeftAlignedBar((JButton)object), cellConstraints.xy(2, 4));
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    private final class CloseEventHandler
    extends WindowAdapter
    implements ActionListener {
        private CloseEventHandler() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            AboutDialog.this.closeDialog();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AboutDialog.this.closeDialog();
        }
    }
}

