/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.common.treetable;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.plaf.UIResource;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import org.jdesktop.swingx.JXTree;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.treetable.TreeTableCellEditor;
import phex.gui.common.table.FWTable;
import phex.gui.common.treetable.AbstractTreeTableModel;
import phex.gui.common.treetable.TreeTableModel;
import phex.gui.common.treetable.TreeTableModelAdapter;

public class JTreeTable
extends FWTable {
    public static final String DRAG_HACK_FLAG_KEY = "treeTable.dragHackFlag";
    protected TreeTableCellRenderer renderer;
    private TableColumn treeTableColumn;
    protected ComponentAdapter dataAdapter;
    private static final Dimension spacing = new Dimension(0, 2);
    static /* synthetic */ Class class$phex$gui$common$treetable$TreeTableModel;
    static /* synthetic */ Class class$phex$gui$common$treetable$JTreeTable;

    public JTreeTable(TreeTableModel treeTableModel) {
        this(treeTableModel, new TreeTableCellRenderer(treeTableModel));
    }

    public JTreeTable(TreeTableModel treeTableModel, TreeTableCellRenderer treeTableCellRenderer) {
        super(new TreeTableModelAdapter(treeTableModel, treeTableCellRenderer));
        if (treeTableModel != treeTableCellRenderer.getModel()) {
            throw new IllegalArgumentException("Mismatched TreeTableModel");
        }
        this.init(treeTableCellRenderer);
        treeTableCellRenderer.setRowHeight(this.getRowHeight());
        this.refreshTreeTableColumn();
        this.setDefaultEditor(AbstractTreeTableModel.hierarchicalColumnClass, new TreeTableCellEditor(treeTableCellRenderer));
        this.setShowGrid(false);
        this.setColumnSelectionAllowed(false);
        this.setIntercellSpacing(spacing);
    }

    public boolean editCellAt(int n, int n2, EventObject eventObject) {
        this.expandOrCollapseNode(n2, eventObject);
        boolean bl = super.editCellAt(n, n2, eventObject);
        if (bl && this.isHierarchical(n2)) {
            this.repaint(this.getCellRect(n, n2, false));
        }
        return bl;
    }

    private void expandOrCollapseNode(int n, EventObject eventObject) {
        if (!(eventObject instanceof MouseEvent)) {
            return;
        }
        if (!this.isHierarchical(n)) {
            return;
        }
        MouseEvent mouseEvent = (MouseEvent)eventObject;
        if (this.hackAroundDragEnabled(mouseEvent)) {
            mouseEvent = new MouseEvent((Component)mouseEvent.getSource(), 501, mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
        }
        if (mouseEvent.getModifiers() == 0 || mouseEvent.getModifiers() == 16) {
            int n2 = this.renderer.getRowHeight();
            this.renderer.setRowHeight(this.getRowHeight());
            MouseEvent mouseEvent2 = new MouseEvent(this.renderer, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX() - this.getCellRect((int)0, (int)n, (boolean)false).x, mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
            this.renderer.dispatchEvent(mouseEvent2);
            MouseEvent mouseEvent3 = new MouseEvent(this.renderer, 502, mouseEvent2.getWhen(), mouseEvent2.getModifiers(), mouseEvent2.getX(), mouseEvent2.getY(), mouseEvent2.getClickCount(), mouseEvent2.isPopupTrigger());
            this.renderer.dispatchEvent(mouseEvent3);
            this.renderer.setRowHeight(n2);
        }
    }

    protected boolean hackAroundDragEnabled(MouseEvent mouseEvent) {
        Boolean bl = (Boolean)this.getClientProperty(DRAG_HACK_FLAG_KEY);
        if (bl == null) {
            String string = null;
            try {
                string = System.getProperty("sun.swing.enableImprovedDragGesture");
            }
            catch (Exception exception) {
                // empty catch block
            }
            bl = string == null;
            this.putClientProperty(DRAG_HACK_FLAG_KEY, bl);
        }
        return this.getDragEnabled() && bl != false;
    }

    public int getEditingRow() {
        return this.isHierarchical(this.editingColumn) ? -1 : this.editingRow;
    }

    private int realEditingRow() {
        return this.editingRow;
    }

    public void setColumnModel(TableColumnModel tableColumnModel) {
        super.setColumnModel(tableColumnModel);
        this.refreshTreeTableColumn();
    }

    public Object getNodeOfRow(int n) {
        TreePath treePath = this.renderer.getPathForRow(n);
        if (treePath == null) {
            return null;
        }
        return treePath.getLastPathComponent();
    }

    public void refreshTreeTableColumn() {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            if (this.getColumnClass(i) != (class$phex$gui$common$treetable$TreeTableModel == null ? JTreeTable.class$("phex.gui.common.treetable.TreeTableModel") : class$phex$gui$common$treetable$TreeTableModel)) continue;
            this.treeTableColumn = this.getColumnModel().getColumn(i);
            break;
        }
    }

    public final void setRowHeight(int n, int n2) {
        throw new UnsupportedOperationException("variable height rows not supported");
    }

    public void setRowHeight(int n) {
        super.setRowHeight(n);
        this.adjustTreeRowHeight();
    }

    public void setRowMargin(int n) {
        super.setRowMargin(n);
        this.adjustTreeRowHeight();
    }

    private void adjustTreeRowHeight() {
        int n = this.rowHeight + (this.rowMargin << 1);
        if (this.renderer != null && this.renderer.getRowHeight() != n) {
            this.renderer.setRowHeight(n);
        }
    }

    public void setSelectionMode(int n) {
        if (this.renderer != null) {
            switch (n) {
                case 1: {
                    this.renderer.getSelectionModel().setSelectionMode(2);
                    break;
                }
                case 2: {
                    this.renderer.getSelectionModel().setSelectionMode(4);
                    break;
                }
                default: {
                    this.renderer.getSelectionModel().setSelectionMode(1);
                }
            }
        }
        super.setSelectionMode(n);
    }

    public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
        Component component = super.prepareRenderer(tableCellRenderer, n, n2);
        ComponentAdapter componentAdapter = this.getComponentAdapter();
        componentAdapter.row = n;
        componentAdapter.column = n2;
        return this.applyRenderer(component, componentAdapter);
    }

    protected Component applyRenderer(Component component, ComponentAdapter componentAdapter) {
        if (component == null) {
            throw new IllegalArgumentException("null component");
        }
        if (componentAdapter == null) {
            throw new IllegalArgumentException("null component data adapter");
        }
        if (this.isHierarchical(componentAdapter.column)) {
            TreeCellRenderer treeCellRenderer = this.renderer.getCellRenderer();
            if (treeCellRenderer instanceof JXTree.DelegatingRenderer) {
                treeCellRenderer = ((JXTree.DelegatingRenderer)treeCellRenderer).getDelegateRenderer();
            }
            if (treeCellRenderer instanceof DefaultTreeCellRenderer) {
                DefaultTreeCellRenderer defaultTreeCellRenderer = (DefaultTreeCellRenderer)treeCellRenderer;
                if (componentAdapter.isSelected()) {
                    defaultTreeCellRenderer.setTextSelectionColor(component.getForeground());
                    defaultTreeCellRenderer.setBackgroundSelectionColor(component.getBackground());
                } else {
                    defaultTreeCellRenderer.setTextNonSelectionColor(component.getForeground());
                    defaultTreeCellRenderer.setBackgroundNonSelectionColor(component.getBackground());
                }
            }
        }
        return component;
    }

    public void setTreeCellRenderer(TreeCellRenderer treeCellRenderer) {
        if (this.renderer != null) {
            this.renderer.setCellRenderer(treeCellRenderer);
        }
    }

    public TreeCellRenderer getTreeCellRenderer() {
        return this.renderer.getCellRenderer();
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        int n = this.columnAtPoint(mouseEvent.getPoint());
        if (this.isHierarchical(n)) {
            return this.renderer.getToolTipText(mouseEvent);
        }
        return super.getToolTipText(mouseEvent);
    }

    public void setCollapsedIcon(Icon icon) {
        this.renderer.setCollapsedIcon(icon);
    }

    public void setExpandedIcon(Icon icon) {
        this.renderer.setExpandedIcon(icon);
    }

    public void setOpenIcon(Icon icon) {
        this.renderer.setOpenIcon(icon);
    }

    public void setClosedIcon(Icon icon) {
        this.renderer.setClosedIcon(icon);
    }

    public void setLeafIcon(Icon icon) {
        this.renderer.setLeafIcon(icon);
    }

    public void clearSelection() {
        if (this.renderer != null) {
            this.renderer.clearSelection();
        }
        super.clearSelection();
    }

    public void collapseAll() {
        this.renderer.collapseAll();
    }

    public void expandAll() {
        this.renderer.expandAll();
    }

    public void collapsePath(TreePath treePath) {
        this.renderer.collapsePath(treePath);
    }

    public void expandPath(TreePath treePath) {
        this.renderer.expandPath(treePath);
    }

    public void scrollPathToVisible(TreePath treePath) {
        if (treePath == null) {
            return;
        }
        this.renderer.makeVisible(treePath);
        int n = this.getRowForPath(treePath);
        this.scrollRowToVisible(n);
    }

    public void collapseRow(int n) {
        this.renderer.collapseRow(n);
    }

    public void expandRow(int n) {
        this.renderer.expandRow(n);
    }

    public void setRootVisible(boolean bl) {
        this.renderer.setRootVisible(bl);
        this.revalidate();
        this.repaint();
    }

    public boolean isRootVisible() {
        return this.renderer.isRootVisible();
    }

    public boolean isVisible(TreePath treePath) {
        return this.renderer.isVisible(treePath);
    }

    public boolean isExpanded(TreePath treePath) {
        return this.renderer.isExpanded(treePath);
    }

    public boolean isExpanded(int n) {
        return this.renderer.isExpanded(n);
    }

    public boolean isCollapsed(TreePath treePath) {
        return this.renderer.isCollapsed(treePath);
    }

    public boolean isCollapsed(int n) {
        return this.renderer.isCollapsed(n);
    }

    public Enumeration getExpandedDescendants(TreePath treePath) {
        return this.renderer.getExpandedDescendants(treePath);
    }

    public void setExpandsSelectedPaths(boolean bl) {
        this.renderer.setExpandsSelectedPaths(bl);
    }

    public boolean getExpandsSelectedPaths() {
        return this.renderer.getExpandsSelectedPaths();
    }

    public TreePath getPathForLocation(int n, int n2) {
        int n3 = this.rowAtPoint(new Point(n, n2));
        if (n3 == -1) {
            return null;
        }
        return this.renderer.getPathForRow(n3);
    }

    public TreePath getPathForRow(int n) {
        return this.renderer.getPathForRow(n);
    }

    public int getRowForPath(TreePath treePath) {
        return this.renderer.getRowForPath(treePath);
    }

    public void setScrollsOnExpand(boolean bl) {
        this.renderer.setScrollsOnExpand(bl);
    }

    public boolean getScrollsOnExpand() {
        return this.renderer.getScrollsOnExpand();
    }

    public void setShowsRootHandles(boolean bl) {
        this.renderer.setShowsRootHandles(bl);
        this.repaint();
    }

    public boolean getShowsRootHandles() {
        return this.renderer.getShowsRootHandles();
    }

    public void addTreeExpansionListener(TreeExpansionListener treeExpansionListener) {
        this.renderer.addTreeExpansionListener(treeExpansionListener);
    }

    public void removeTreeExpansionListener(TreeExpansionListener treeExpansionListener) {
        this.renderer.removeTreeExpansionListener(treeExpansionListener);
    }

    public void addTreeSelectionListener(TreeSelectionListener treeSelectionListener) {
        this.renderer.addTreeSelectionListener(treeSelectionListener);
    }

    public void removeTreeSelectionListener(TreeSelectionListener treeSelectionListener) {
        this.renderer.removeTreeSelectionListener(treeSelectionListener);
    }

    public void addTreeWillExpandListener(TreeWillExpandListener treeWillExpandListener) {
        this.renderer.addTreeWillExpandListener(treeWillExpandListener);
    }

    public void removeTreeWillExpandListener(TreeWillExpandListener treeWillExpandListener) {
        this.renderer.removeTreeWillExpandListener(treeWillExpandListener);
    }

    public TreeSelectionModel getTreeSelectionModel() {
        return this.renderer.getSelectionModel();
    }

    public void sizeColumnsToFit(int n) {
        super.sizeColumnsToFit(n);
        if (this.getEditingColumn() != -1 && this.isHierarchical(this.editingColumn)) {
            Rectangle rectangle = this.getCellRect(this.realEditingRow(), this.getEditingColumn(), false);
            Component component = this.getEditorComponent();
            component.setBounds(rectangle);
            component.validate();
        }
    }

    public void updateUI() {
        super.updateUI();
        if (this.renderer != null) {
            this.renderer.updateUI();
            this.setDefaultEditor(AbstractTreeTableModel.hierarchicalColumnClass, new TreeTableCellEditor(this.renderer));
            if (this.getBackground() == null || this.getBackground() instanceof UIResource) {
                this.setBackground(this.renderer.getBackground());
            }
        }
    }

    public boolean isHierarchical(int n) {
        return AbstractTreeTableModel.hierarchicalColumnClass.isAssignableFrom(this.getColumnClass(n));
    }

    private final void init(TreeTableCellRenderer treeTableCellRenderer) {
        this.renderer = treeTableCellRenderer;
        ListToTreeSelectionModelWrapper listToTreeSelectionModelWrapper = new ListToTreeSelectionModelWrapper();
        if (treeTableCellRenderer != null) {
            treeTableCellRenderer.bind(this);
            treeTableCellRenderer.setSelectionModel(listToTreeSelectionModelWrapper);
        }
        this.setSelectionModel(listToTreeSelectionModelWrapper.getListSelectionModel());
        this.setDefaultRenderer(AbstractTreeTableModel.hierarchicalColumnClass, treeTableCellRenderer);
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                JTreeTable.this.renderer.putClientProperty(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getNewValue());
            }
        };
        this.addPropertyChangeListener("JTree.lineStyle", propertyChangeListener);
    }

    protected ComponentAdapter getComponentAdapter() {
        if (this.dataAdapter == null) {
            this.dataAdapter = new TreeTableDataAdapter(this);
        }
        return this.dataAdapter;
    }

    protected static class TreeTableDataAdapter
    extends TableAdapter {
        private final JTreeTable treetable;

        public TreeTableDataAdapter(JTreeTable jTreeTable) {
            super(jTreeTable);
            this.treetable = jTreeTable;
        }

        public JTreeTable getTreeTable() {
            return this.treetable;
        }

        public boolean isExpanded() {
            return super.isExpanded();
        }

        public boolean hasFocus() {
            boolean bl = super.hasFocus();
            return bl;
        }

        public boolean isLeaf() {
            return super.isLeaf();
        }

        public boolean isHierarchical() {
            return this.treetable.isHierarchical(this.column);
        }
    }

    protected static class TableAdapter
    extends ComponentAdapter {
        private final FWTable table;

        public TableAdapter(FWTable fWTable) {
            super(fWTable);
            this.table = fWTable;
        }

        public FWTable getTable() {
            return this.table;
        }

        public String getColumnName(int n) {
            TableColumn tableColumn = this.getColumnByModelIndex(n);
            return tableColumn == null ? "" : tableColumn.getHeaderValue().toString();
        }

        protected TableColumn getColumnByModelIndex(int n) {
            List list = this.table.getColumns(true);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                TableColumn tableColumn = (TableColumn)iterator.next();
                if (tableColumn.getModelIndex() != n) continue;
                return tableColumn;
            }
            return null;
        }

        public String getColumnIdentifier(int n) {
            TableColumn tableColumn = this.getColumnByModelIndex(n);
            Object object = tableColumn != null ? tableColumn.getIdentifier() : null;
            return object != null ? object.toString() : null;
        }

        public int getColumnCount() {
            return this.table.getModel().getColumnCount();
        }

        public int getRowCount() {
            return this.table.getModel().getRowCount();
        }

        public Object getValueAt(int n, int n2) {
            return this.table.getModel().getValueAt(n, n2);
        }

        public void setValueAt(Object object, int n, int n2) {
            this.table.getModel().setValueAt(object, n, n2);
        }

        public boolean isCellEditable(int n, int n2) {
            return this.table.getModel().isCellEditable(n, n2);
        }

        public boolean isTestable(int n) {
            return this.getColumnByModelIndex(n) != null;
        }

        public Object getFilteredValueAt(int n, int n2) {
            return this.getValueAt(this.table.convertRowIndexToModel(n), n2);
        }

        public boolean isSelected() {
            return this.table.isCellSelected(this.row, this.column);
        }

        public boolean hasFocus() {
            boolean bl = this.table.getSelectionModel().getLeadSelectionIndex() == this.row;
            boolean bl2 = this.table.getColumnModel().getSelectionModel().getLeadSelectionIndex() == this.column;
            return this.table.isFocusOwner() && bl && bl2;
        }

        public int modelToView(int n) {
            return this.table.convertColumnIndexToView(n);
        }

        public int viewToModel(int n) {
            return this.table.convertColumnIndexToModel(n);
        }
    }

    static class TreeTableCellRenderer
    extends JXTree
    implements TableCellRenderer {
        protected Border highlightBorder = null;
        protected JTreeTable treeTable = null;
        protected int visibleRow = 0;
        private int hierarchicalColumnWidth = 0;
        static final /* synthetic */ boolean $assertionsDisabled;

        public TreeTableCellRenderer(TreeTableModel treeTableModel) {
            super(treeTableModel);
            this.putClientProperty("JTree.lineStyle", "None");
            this.setRootVisible(false);
            this.setShowsRootHandles(true);
            this.setOverwriteRendererIcons(true);
            this.setCellRenderer(new ClippedTreeCellRenderer());
        }

        public final void bind(JTreeTable jTreeTable) {
            if (jTreeTable == null) {
                throw new IllegalArgumentException("null treeTable");
            }
            if (this.treeTable != null) {
                throw new IllegalArgumentException("renderer already bound");
            }
            this.treeTable = jTreeTable;
        }

        public void updateUI() {
            super.updateUI();
            TreeCellRenderer treeCellRenderer = this.getCellRenderer();
            if (treeCellRenderer instanceof DefaultTreeCellRenderer) {
                DefaultTreeCellRenderer defaultTreeCellRenderer = (DefaultTreeCellRenderer)treeCellRenderer;
                defaultTreeCellRenderer.setBorderSelectionColor(null);
                defaultTreeCellRenderer.setTextSelectionColor(UIManager.getColor("Table.selectionForeground"));
                defaultTreeCellRenderer.setBackgroundSelectionColor(UIManager.getColor("Table.selectionBackground"));
            }
        }

        public void setRowHeight(int n) {
            super.setRowHeight(n);
            if (n > 0 && this.treeTable != null) {
                int n2 = this.treeTable.getRowMargin();
                if (!$assertionsDisabled && n2 < 0) {
                    throw new AssertionError();
                }
                int n3 = n - (n2 << 1);
                if (this.treeTable.getRowHeight() != n3) {
                    this.treeTable.setRowHeight(n3);
                }
            }
        }

        public void setBounds(int n, int n2, int n3, int n4) {
            if (this.treeTable != null) {
                n2 = 0;
                n4 = this.treeTable.getRowCount() * this.getRowHeight();
            }
            super.setBounds(n, n2, n3, n4);
        }

        public void paint(Graphics graphics) {
            int n = this.treeTable.getRowMargin();
            int n2 = n + (n >> 1) + n % 2;
            int n3 = n2 + this.visibleRow * this.getRowHeight();
            graphics.translate(0, -n3);
            this.hierarchicalColumnWidth = this.getWidth();
            super.paint(graphics);
            if (this.highlightBorder != null) {
                this.highlightBorder.paintBorder(this, graphics, 0, n3, this.getWidth(), this.getRowHeight() - (n << 1) - n);
            }
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (!$assertionsDisabled && jTable != this.treeTable) {
                throw new AssertionError();
            }
            if (bl) {
                this.setBackground(jTable.getSelectionBackground());
                this.setForeground(jTable.getSelectionForeground());
            } else {
                this.setBackground(jTable.getBackground());
                this.setForeground(jTable.getForeground());
            }
            this.highlightBorder = null;
            if (this.treeTable != null && (this.treeTable.realEditingRow() != n || this.treeTable.getEditingColumn() != n2) && bl2) {
                this.highlightBorder = UIManager.getBorder("Table.focusCellHighlightBorder");
            }
            this.visibleRow = n;
            return this;
        }

        static {
            $assertionsDisabled = !(class$phex$gui$common$treetable$JTreeTable == null ? (class$phex$gui$common$treetable$JTreeTable = JTreeTable.class$("phex.gui.common.treetable.JTreeTable")) : class$phex$gui$common$treetable$JTreeTable).desiredAssertionStatus();
        }

        private class ClippedTreeCellRenderer
        extends DefaultTreeCellRenderer {
            private final Rectangle iconRect = new Rectangle();
            private final Rectangle textRect = new Rectangle();
            private final Rectangle itemRect = new Rectangle();

            private ClippedTreeCellRenderer() {
            }

            public void paint(Graphics graphics) {
                String string = super.getText();
                String string2 = SwingUtilities.layoutCompoundLabel(this, graphics.getFontMetrics(), string, this.getIcon(), this.getVerticalAlignment(), this.getHorizontalAlignment(), this.getVerticalTextPosition(), this.getHorizontalTextPosition(), this.getItemRect(this.itemRect), this.iconRect, this.textRect, this.getIconTextGap());
                this.setText(string2);
                super.paint(graphics);
                this.setText(string);
            }

            private Rectangle getItemRect(Rectangle rectangle) {
                this.getBounds(rectangle);
                rectangle.width = TreeTableCellRenderer.this.hierarchicalColumnWidth - rectangle.x;
                return rectangle;
            }
        }
    }

    class ListToTreeSelectionModelWrapper
    extends DefaultTreeSelectionModel {
        protected boolean updatingListSelectionModel;

        public ListToTreeSelectionModelWrapper() {
            this.getListSelectionModel().addListSelectionListener(this.createListSelectionListener());
        }

        ListSelectionModel getListSelectionModel() {
            return this.listSelectionModel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resetRowSelection() {
            if (!this.updatingListSelectionModel) {
                this.updatingListSelectionModel = true;
                try {
                    super.resetRowSelection();
                }
                finally {
                    this.updatingListSelectionModel = false;
                }
            }
        }

        protected ListSelectionListener createListSelectionListener() {
            return new ListSelectionHandler();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void updateSelectedPathsFromSelectedRows() {
            if (!this.updatingListSelectionModel) {
                this.updatingListSelectionModel = true;
                try {
                    int n = this.listSelectionModel.getMinSelectionIndex();
                    int n2 = this.listSelectionModel.getMaxSelectionIndex();
                    this.clearSelection();
                    if (n != -1 && n2 != -1) {
                        for (int i = n; i <= n2; ++i) {
                            TreePath treePath;
                            if (!this.listSelectionModel.isSelectedIndex(i) || (treePath = JTreeTable.this.renderer.getPathForRow(i)) == null) continue;
                            this.addSelectionPath(treePath);
                        }
                    }
                }
                finally {
                    this.updatingListSelectionModel = false;
                }
            }
        }

        class ListSelectionHandler
        implements ListSelectionListener {
            ListSelectionHandler() {
            }

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ListToTreeSelectionModelWrapper.this.updateSelectedPathsFromSelectedRows();
            }
        }
    }
}

