/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.common.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import phex.gui.common.table.FWTable;
import phex.gui.models.ISortableModel;

public class SortedTableHeaderRenderer
extends DefaultTableCellRenderer {
    private FWTable table;

    public SortedTableHeaderRenderer(FWTable fWTable) {
        this.setHorizontalAlignment(0);
        this.table = fWTable;
        this.setHorizontalTextPosition(10);
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        JTableHeader jTableHeader;
        if (jTable != null && (jTableHeader = jTable.getTableHeader()) != null) {
            this.setForeground(jTableHeader.getForeground());
            this.setBackground(jTableHeader.getBackground());
            this.setFont(jTableHeader.getFont());
            ISortableModel iSortableModel = (ISortableModel)((Object)jTable.getModel());
            int n3 = jTable.convertColumnIndexToView(iSortableModel.getSortByColumn());
            if (n3 == n2) {
                if (iSortableModel.isSortedAscending()) {
                    this.setIcon(new DirectionIcon(false, this.getFont().getSize(), 0));
                } else {
                    this.setIcon(new DirectionIcon(true, this.getFont().getSize(), 0));
                }
            } else {
                this.setIcon(null);
            }
        }
        this.setText(object == null ? "" : object.toString());
        this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
        return this;
    }

    private class DirectionIcon
    implements Icon {
        private boolean descending;
        private int size;
        private int priority;

        public DirectionIcon(boolean bl, int n, int n2) {
            this.descending = bl;
            this.size = n;
            this.priority = n2;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Color color = component == null ? Color.gray : component.getBackground();
            int n3 = (int)((double)(this.size / 2) * Math.pow(0.8, this.priority));
            int n4 = this.descending ? n3 : -n3;
            n2 = n2 + 5 * this.size / 7 + (this.descending ? -n4 : 0);
            int n5 = this.descending ? 1 : -1;
            graphics.translate(n, n2);
            graphics.setColor(color.darker());
            graphics.drawLine(n3 / 2, n4, 0, 0);
            graphics.drawLine(n3 / 2, n4 + n5, 0, n5);
            graphics.setColor(color.brighter());
            graphics.drawLine(n3 / 2, n4, n3, 0);
            graphics.drawLine(n3 / 2, n4 + n5, n3, n5);
            if (this.descending) {
                graphics.setColor(color.darker().darker());
            } else {
                graphics.setColor(color.brighter().brighter());
            }
            graphics.drawLine(n3, 0, 0, 0);
            graphics.setColor(color);
            graphics.translate(-n, -n2);
        }

        public int getIconWidth() {
            return this.size;
        }

        public int getIconHeight() {
            return this.size;
        }
    }
}

