/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.common.statusbar;

import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import phex.common.bandwidth.BandwidthController;
import phex.common.bandwidth.BandwidthManager;
import phex.common.format.NumberFormatUtils;
import phex.gui.common.GUIRegistry;
import phex.statistic.StatisticProvider;
import phex.statistic.StatisticsManager;
import phex.upload.UploadManager;
import phex.utils.Localizer;

public class UploadZone
extends JPanel {
    private UploadManager uploadMgr;
    private StatisticsManager statsMgr;
    private BandwidthManager bwMgr;
    private JLabel uploadLabel;
    private JLabel bwLabel;

    public UploadZone() {
        SpringLayout springLayout = new SpringLayout();
        this.setLayout(springLayout);
        this.uploadMgr = UploadManager.getInstance();
        this.statsMgr = StatisticsManager.getInstance();
        this.bwMgr = BandwidthManager.getInstance();
        this.uploadLabel = new JLabel();
        this.uploadLabel.setIcon(GUIRegistry.getInstance().getIconFactory().getIcon("UploadSmall"));
        this.add(this.uploadLabel);
        this.bwLabel = new JLabel();
        this.add(this.bwLabel);
        this.updateZone();
        springLayout.putConstraint("North", (Component)this.uploadLabel, 3, "North", (Component)this);
        springLayout.putConstraint("West", (Component)this.uploadLabel, 5, "West", (Component)this);
        springLayout.putConstraint("West", (Component)this.bwLabel, 5, "East", (Component)this.uploadLabel);
        springLayout.putConstraint("North", (Component)this.bwLabel, 3, "North", (Component)this);
        springLayout.putConstraint("East", (Component)this, 5, "East", (Component)this.bwLabel);
    }

    public void updateZone() {
        StatisticProvider statisticProvider = this.statsMgr.getStatisticProvider("SessionUploadCountProvider");
        Object[] objectArray = new Object[]{new Integer(this.uploadMgr.getUploadingCount()), new Integer(this.uploadMgr.getUploadQueueSize()), statisticProvider.getValue()};
        String string = Localizer.getFormatedString("StatusBar_Uploads", objectArray);
        this.uploadLabel.setText(string);
        this.uploadLabel.setToolTipText(Localizer.getString("StatusBar_TTTUploads"));
        BandwidthController bandwidthController = this.bwMgr.getUploadBandwidthController();
        long l = bandwidthController.getShortTransferAvg().getAverage();
        long l2 = bandwidthController.getThrottlingRate();
        String string2 = NumberFormatUtils.formatSignificantByteSize(l);
        String string3 = l2 == Integer.MAX_VALUE ? Localizer.getDecimalFormatSymbols().getInfinity() : NumberFormatUtils.formatSignificantByteSize(l2);
        this.bwLabel.setText(string2 + Localizer.getString("PerSec") + " (" + string3 + ")");
        this.validate();
    }
}

