/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.common.statusbar;

import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import phex.common.bandwidth.BandwidthController;
import phex.common.bandwidth.BandwidthManager;
import phex.common.format.NumberFormatUtils;
import phex.download.swarming.SwarmingManager;
import phex.gui.common.GUIRegistry;
import phex.statistic.StatisticsManager;
import phex.utils.Localizer;

public class DownloadZone
extends JPanel {
    private SwarmingManager swarmingMgr;
    private StatisticsManager statsMgr;
    private BandwidthManager bwMgr;
    private JLabel downloadLabel;
    private JLabel bwLabel;

    public DownloadZone() {
        SpringLayout springLayout = new SpringLayout();
        this.setLayout(springLayout);
        this.swarmingMgr = SwarmingManager.getInstance();
        this.statsMgr = StatisticsManager.getInstance();
        this.bwMgr = BandwidthManager.getInstance();
        this.downloadLabel = new JLabel();
        this.downloadLabel.setIcon(GUIRegistry.getInstance().getIconFactory().getIcon("DownloadSmall"));
        this.add(this.downloadLabel);
        this.bwLabel = new JLabel();
        this.add(this.bwLabel);
        this.updateZone();
        springLayout.putConstraint("West", (Component)this.downloadLabel, 5, "West", (Component)this);
        springLayout.putConstraint("North", (Component)this.downloadLabel, 3, "North", (Component)this);
        springLayout.putConstraint("West", (Component)this.bwLabel, 5, "East", (Component)this.downloadLabel);
        springLayout.putConstraint("North", (Component)this.bwLabel, 3, "North", (Component)this);
        springLayout.putConstraint("East", (Component)this, 5, "East", (Component)this.bwLabel);
    }

    public void updateZone() {
        Object[] objectArray = new Object[]{new Integer(this.swarmingMgr.getDownloadFileCount(2)), new Integer(this.swarmingMgr.getDownloadFileCount()), new Integer(this.swarmingMgr.getDownloadFileCount(6))};
        String string = Localizer.getFormatedString("StatusBar_Downloads", objectArray);
        this.downloadLabel.setText(string);
        this.downloadLabel.setToolTipText(Localizer.getString("StatusBar_TTTDownloads"));
        BandwidthController bandwidthController = this.bwMgr.getDownloadBandwidthController();
        long l = bandwidthController.getShortTransferAvg().getAverage();
        long l2 = bandwidthController.getThrottlingRate();
        String string2 = NumberFormatUtils.formatSignificantByteSize(l);
        String string3 = l2 >= Integer.MAX_VALUE ? Localizer.getDecimalFormatSymbols().getInfinity() : NumberFormatUtils.formatSignificantByteSize(l2);
        this.bwLabel.setText(string2 + Localizer.getString("PerSec") + " (" + string3 + ")");
        this.validate();
    }
}

