/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.common.statusbar;

import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import phex.connection.NetworkManager;
import phex.gui.common.GUIRegistry;
import phex.gui.common.IconFactory;
import phex.host.HostManager;
import phex.host.NetworkHostsContainer;
import phex.utils.Localizer;

public class ConnectionsZone
extends JPanel {
    private NetworkHostsContainer hostsContainer;
    private NetworkManager networkMgr;
    private JLabel connectionLabel;
    private Icon connectedIcon;
    private Icon firewalledIcon;
    private Icon disconnectedIcon;

    public ConnectionsZone() {
        SpringLayout springLayout = new SpringLayout();
        this.setLayout(springLayout);
        this.networkMgr = NetworkManager.getInstance();
        HostManager hostManager = HostManager.getInstance();
        this.hostsContainer = hostManager.getNetworkHostsContainer();
        IconFactory iconFactory = GUIRegistry.getInstance().getIconFactory();
        this.connectedIcon = iconFactory.getIcon("Network");
        this.firewalledIcon = iconFactory.getIcon("Firewalled");
        this.disconnectedIcon = iconFactory.getIcon("Disconnect");
        this.connectionLabel = new JLabel();
        this.connectionLabel.setIcon(GUIRegistry.getInstance().getIconFactory().getIcon("UploadSmall"));
        this.add(this.connectionLabel);
        this.updateZone();
        springLayout.putConstraint("North", (Component)this.connectionLabel, 2, "North", (Component)this);
        springLayout.putConstraint("West", (Component)this.connectionLabel, 5, "West", (Component)this);
        springLayout.putConstraint("East", (Component)this, 5, "East", (Component)this.connectionLabel);
        springLayout.putConstraint("South", (Component)this, 2, "South", (Component)this.connectionLabel);
    }

    public void updateZone() {
        int n = this.hostsContainer.getTotalConnectionCount();
        if (n > 0) {
            if (this.networkMgr.hasConnectedIncoming()) {
                this.connectionLabel.setIcon(this.connectedIcon);
            } else {
                this.connectionLabel.setIcon(this.firewalledIcon);
            }
        } else {
            this.connectionLabel.setIcon(this.disconnectedIcon);
        }
        Object[] objectArray = new Object[]{new Integer(n)};
        String string = Localizer.getFormatedString("StatusBar_Connections", objectArray);
        this.connectionLabel.setText(string);
        this.connectionLabel.setToolTipText(Localizer.getString("StatusBar_TTTConnections"));
        this.validate();
    }
}

