/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.common;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JWindow;
import phex.common.ThreadPool;
import phex.common.ThreadTracking;
import phex.gui.common.DialogBanner;
import phex.gui.common.GUIRegistry;
import phex.gui.common.GradientPanel;
import phex.gui.common.PhexColors;
import phex.utils.Localizer;

public class SlideInWindow
extends JWindow {
    private boolean closeAfterAnimation = false;
    private long autoCloseDelay;
    private String title;
    private boolean isHTML;
    private String shortMessage;
    private boolean isHideBtnShown;
    private JButton hideBtn;

    public SlideInWindow(String string, long l) {
        super(GUIRegistry.getInstance().getMainFrame());
        this.title = string;
        this.autoCloseDelay = l;
        this.isHideBtnShown = true;
    }

    public void setShortMessage(String string, boolean bl) {
        this.shortMessage = string;
        this.isHTML = bl;
    }

    public void setHideBtnShown(boolean bl) {
        this.isHideBtnShown = bl;
    }

    public void initializeComponent() {
        this.getContentPane().setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setDoubleBuffered(true);
        jPanel.setBorder(BorderFactory.createLineBorder(PhexColors.getBoxPanelBorderColor(), 2));
        jPanel.setLayout(new BorderLayout());
        this.getContentPane().add((Component)jPanel, "Center");
        DialogBanner dialogBanner = new DialogBanner(this.title, null);
        dialogBanner.setImageIcon(null);
        jPanel.add((Component)dialogBanner, "North");
        GradientPanel gradientPanel = new GradientPanel(Color.WHITE, PhexColors.getBoxHeaderGradientTo());
        CellConstraints cellConstraints = new CellConstraints();
        FormLayout formLayout = new FormLayout("4px, fill:d:grow, 4px", "4px, fill:d:grow, 10px, p, 4px");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout, gradientPanel);
        JEditorPane jEditorPane = new JEditorPane();
        if (this.isHTML) {
            jEditorPane.setContentType("text/html");
        }
        Font font = jEditorPane.getFont();
        font = font.deriveFont(0, font.getSize() + 1);
        jEditorPane.setFont(font);
        jEditorPane.setOpaque(false);
        jEditorPane.setText(this.shortMessage);
        jEditorPane.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setBorder(BorderFactory.createEmptyBorder());
        jScrollPane.setOpaque(false);
        jScrollPane.getViewport().setOpaque(false);
        jScrollPane.setViewportView(jEditorPane);
        gradientPanel.add((Component)jScrollPane, cellConstraints.xy(2, 2));
        if (this.isHideBtnShown) {
            this.hideBtn = new JButton(Localizer.getString("SlideInWindow_Hide"));
            this.hideBtn.setMargin(new Insets(1, 1, 1, 3));
            this.hideBtn.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ThreadPool.getInstance().addJob(new Runnable(this){
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            1.access$000(this.this$1).slideOut();
                        }
                    }, "SlideOutJob");
                }

                static /* synthetic */ SlideInWindow access$000(1 var0) {
                    return var0.SlideInWindow.this;
                }
            });
            JPanel jPanel2 = ButtonBarFactory.buildRightAlignedBar(this.hideBtn);
            jPanel2.setOpaque(false);
            gradientPanel.add((Component)jPanel2, cellConstraints.xy(2, 4));
        }
        jPanel.add((Component)gradientPanel, "Center");
        this.validate();
        this.pack();
        this.setSize(250, 200);
    }

    public void slideIn() {
        Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(this.getGraphicsConfiguration());
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Point point = new Point(dimension.width - 5 - insets.left, dimension.height - this.getHeight() - 5 - insets.bottom);
        Point point2 = new Point(dimension.width - this.getWidth() - 5 - insets.left, dimension.height - this.getHeight() - 5 - insets.bottom);
        this.setLocation(point.x, point.y);
        this.setVisible(true);
        this.repaint();
        this.closeAfterAnimation = false;
        AnimatorThread animatorThread = new AnimatorThread(this, point, point2, 50, 30L);
        animatorThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void slideOut() {
        Serializable serializable = this;
        synchronized (serializable) {
            if (this.closeAfterAnimation) {
                return;
            }
            this.closeAfterAnimation = true;
        }
        serializable = Toolkit.getDefaultToolkit().getScreenInsets(this.getGraphicsConfiguration());
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Point point = new Point(dimension.width - this.getWidth() - 5 - ((Insets)serializable).left, dimension.height - this.getHeight() - 5 - ((Insets)serializable).bottom);
        Point point2 = new Point(dimension.width - this.getWidth() - 5 - ((Insets)serializable).left, dimension.height - ((Insets)serializable).bottom);
        AnimatorThread animatorThread = new AnimatorThread(this, point, point2, 50, 30L);
        animatorThread.start();
    }

    private void animationFinished() {
        if (this.closeAfterAnimation) {
            this.setVisible(false);
            this.dispose();
        } else if (this.autoCloseDelay > 0L) {
            ThreadPool.getInstance().addJob(new Runnable(){

                public void run() {
                    long l = System.currentTimeMillis();
                    long l2 = l + SlideInWindow.this.autoCloseDelay;
                    while (l < l2) {
                        int n = (int)Math.round((double)(l2 - l) / 1000.0);
                        SlideInWindow.this.hideBtn.setText(Localizer.getFormatedString("SlideInWindow_HideSec", new Object[]{new Integer(n)}));
                        try {
                            Thread.sleep(250L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        l = System.currentTimeMillis();
                    }
                    SlideInWindow.this.slideOut();
                }
            }, "SlideInWindowHideBtnAnimator");
        }
    }

    private class AnimatorThread
    extends Thread {
        private Component comp;
        private long stepDelay;
        private int animationSteps;
        private Point startPoint;
        private Point stopPoint;

        public AnimatorThread(Component component, Point point, Point point2, int n, long l) {
            super(ThreadTracking.rootThreadGroup, "AnimatorThread");
            this.comp = component;
            this.stepDelay = l;
            this.animationSteps = n;
            this.startPoint = point;
            this.stopPoint = point2;
        }

        public void run() {
            for (int i = 0; i <= this.animationSteps; ++i) {
                this.updateComponentAtStep(i);
                try {
                    Thread.sleep(this.stepDelay);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
            SlideInWindow.this.animationFinished();
        }

        private void updateComponentAtStep(int n) {
            int n2 = this.startPoint.x + (this.stopPoint.x - this.startPoint.x) * n / this.animationSteps;
            int n3 = this.startPoint.y + (this.stopPoint.y - this.startPoint.y) * n / this.animationSteps;
            EventQueue.invokeLater(new Runnable(this, n2, n3){
                private final /* synthetic */ int val$x;
                private final /* synthetic */ int val$y;
                private final /* synthetic */ AnimatorThread this$1;
                {
                    this.this$1 = animatorThread;
                    this.val$x = n;
                    this.val$y = n2;
                }

                public void run() {
                    AnimatorThread.access$400(this.this$1).setLocation(this.val$x, this.val$y);
                    AnimatorThread.access$400(this.this$1).validate();
                }
            });
        }

        static /* synthetic */ Component access$400(AnimatorThread animatorThread) {
            return animatorThread.comp;
        }
    }
}

