/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.common;

import java.util.Iterator;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import phex.gui.actions.FWAction;
import phex.gui.actions.FilteredPortsAction;
import phex.gui.actions.OpenURLAction;
import phex.gui.actions.RescanSharedFilesAction;
import phex.gui.actions.ToggleStatusbarAction;
import phex.gui.actions.ToggleToolbarAction;
import phex.gui.actions.ViewAboutAction;
import phex.gui.actions.ViewOptionsAction;
import phex.gui.common.FWMenu;
import phex.gui.common.GUIRegistry;
import phex.gui.common.MainFrame;
import phex.gui.tabs.FWTab;
import phex.utils.Localizer;
import phex.xml.sax.gui.DGuiSettings;

public class MainMenuBar
extends JMenuBar {
    private FWMenu viewMenu;
    private ToggleToolbarAction toggleToolbarAction;
    private ToggleStatusbarAction toggleStatusbarAction;

    public MainMenuBar(MainFrame mainFrame, DGuiSettings dGuiSettings) {
        JMenu jMenu = new JMenu(Localizer.getString("Network"));
        jMenu.setMnemonic(Localizer.getChar("NetworkMnemonic"));
        GUIRegistry gUIRegistry = GUIRegistry.getInstance();
        FWMenu fWMenu = new FWMenu(Localizer.getString("New"));
        FWAction fWAction = gUIRegistry.getGlobalAction("NewDownloadAction");
        fWMenu.addAction(fWAction);
        jMenu.add(fWMenu);
        fWAction = gUIRegistry.getGlobalAction("ConnectNetworkAction");
        jMenu.add(fWAction);
        fWAction = gUIRegistry.getGlobalAction("DisconnectNetworkAction");
        jMenu.add(fWAction);
        jMenu.addSeparator();
        fWAction = gUIRegistry.getGlobalAction("SwitchNetworkAction");
        jMenu.add(fWAction);
        jMenu.addSeparator();
        fWAction = gUIRegistry.getGlobalAction("ExitPhexAction");
        jMenu.add(fWAction);
        this.add(jMenu);
        this.viewMenu = new FWMenu(Localizer.getString("View"));
        this.viewMenu.addMenuListener(new ViewMenuListener());
        this.viewMenu.setMnemonic(Localizer.getChar("ViewMnemonic"));
        this.add(this.viewMenu);
        boolean bl = true;
        if (dGuiSettings != null && dGuiSettings.isSetToolbarVisible()) {
            bl = dGuiSettings.isToolbarVisible();
        }
        this.toggleToolbarAction = new ToggleToolbarAction(bl);
        boolean bl2 = true;
        if (dGuiSettings != null && dGuiSettings.isSetStatusbarVisible()) {
            bl2 = dGuiSettings.isStatusbarVisible();
        }
        this.toggleStatusbarAction = new ToggleStatusbarAction(bl2);
        FWMenu fWMenu2 = new FWMenu(Localizer.getString("Settings"));
        fWMenu2.setMnemonic(Localizer.getChar("SettingsMnemonic"));
        fWAction = new ViewOptionsAction();
        fWMenu2.addAction(fWAction);
        fWMenu2.addSeparator();
        fWAction = new FilteredPortsAction();
        fWMenu2.addAction(fWAction);
        fWMenu2.addSeparator();
        fWAction = new RescanSharedFilesAction();
        fWMenu2.addAction(fWAction);
        this.add(fWMenu2);
        FWMenu fWMenu3 = new FWMenu(Localizer.getString("Help"));
        fWMenu3.setMnemonic(Localizer.getChar("HelpMnemonic"));
        fWMenu3.addAction(new OpenURLAction(Localizer.getString("PhexHomepage"), "http://phex.kouk.de", gUIRegistry.getIconFactory().getIcon("Network"), Localizer.getString("TTTPhexHomepage"), new Integer(Localizer.getChar("PhexHomepageMnemonic")), null));
        fWMenu3.addAction(new OpenURLAction(Localizer.getString("PhexForum"), "http://www.gnutellaforums.com/forumdisplay.php?s=&forumid=16", gUIRegistry.getIconFactory().getIcon("Network"), Localizer.getString("TTTPhexForum"), new Integer(Localizer.getChar("PhexForumMnemonic")), null));
        fWMenu3.addSeparator();
        fWMenu3.addAction(new ViewAboutAction());
        this.add(fWMenu3);
    }

    private final class ViewMenuListener
    implements MenuListener {
        private ViewMenuListener() {
        }

        public void menuCanceled(MenuEvent menuEvent) {
            MainMenuBar.this.viewMenu.removeAll();
        }

        public void menuDeselected(MenuEvent menuEvent) {
            MainMenuBar.this.viewMenu.removeAll();
        }

        public void menuSelected(MenuEvent menuEvent) {
            List list;
            MainFrame mainFrame = GUIRegistry.getInstance().getMainFrame();
            FWTab fWTab = mainFrame.getSelectedTab();
            if (fWTab != null && (list = fWTab.getViewMenuActions()) != null && list.size() > 0) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    FWAction fWAction = (FWAction)iterator.next();
                    MainMenuBar.this.viewMenu.addAction(fWAction);
                }
                MainMenuBar.this.viewMenu.addSeparator();
            }
            MainMenuBar.this.viewMenu.addAction(MainMenuBar.this.toggleToolbarAction);
            MainMenuBar.this.viewMenu.addAction(MainMenuBar.this.toggleStatusbarAction);
            MainMenuBar.this.viewMenu.addSeparator();
            fWTab = mainFrame.getTab(1000);
            MainMenuBar.this.viewMenu.addAction(fWTab.getToggleTabViewAction());
            fWTab = mainFrame.getTab(1101);
            MainMenuBar.this.viewMenu.addAction(fWTab.getToggleTabViewAction());
            fWTab = mainFrame.getTab(1003);
            MainMenuBar.this.viewMenu.addAction(fWTab.getToggleTabViewAction());
            fWTab = mainFrame.getTab(1004);
            MainMenuBar.this.viewMenu.addAction(fWTab.getToggleTabViewAction());
            fWTab = mainFrame.getTab(1007);
            MainMenuBar.this.viewMenu.addAction(fWTab.getToggleTabViewAction());
            fWTab = mainFrame.getTab(1005);
            MainMenuBar.this.viewMenu.addAction(fWTab.getToggleTabViewAction());
            fWTab = mainFrame.getTab(1006);
            MainMenuBar.this.viewMenu.addAction(fWTab.getToggleTabViewAction());
            fWTab = mainFrame.getTab(1008);
            MainMenuBar.this.viewMenu.addAction(fWTab.getToggleTabViewAction());
            fWTab = mainFrame.getTab(1009);
            MainMenuBar.this.viewMenu.addAction(fWTab.getToggleTabViewAction());
        }
    }
}

