/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.common;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.UIManager;
import phex.gui.actions.FWAction;
import phex.gui.common.PhexColors;

public class LinkLabel
extends JLabel
implements MouseListener {
    private boolean isFontBold;
    private boolean isRollover;
    private Action action;

    public LinkLabel(FWAction fWAction) {
        super((String)fWAction.getValue("Name"));
        this.action = fWAction;
        this.registerActionChangeListener(this.action);
        this.setToolTipText((String)this.action.getValue("ToolTipText"));
        this.setEnabled(this.action.isEnabled());
        this.isRollover = false;
        this.isFontBold = false;
        this.addMouseListener(this);
        this.setCursor(Cursor.getPredefinedCursor(12));
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.isEnabled()) {
            graphics.drawLine(0, this.getHeight() - 2, this.getWidth(), this.getHeight() - 2);
        }
    }

    public void setFontBold(boolean bl) {
        this.isFontBold = bl;
        Font font = this.getFont();
        if (font.isBold() != this.isFontBold) {
            if (this.isFontBold) {
                this.setFont(UIManager.getFont("Label.font").deriveFont(1));
            } else {
                this.setFont(UIManager.getFont("Label.font"));
            }
        }
    }

    public void initialize() {
        this.setFontBold(this.isFontBold);
    }

    public void updateUI() {
        super.updateUI();
        this.initialize();
    }

    public Color getForeground() {
        if (this.isRollover) {
            return PhexColors.getLinkLabelRolloverForeground();
        }
        return super.getForeground();
    }

    private void registerActionChangeListener(Action action) {
        ActionChangedListener actionChangedListener = new ActionChangedListener();
        action.addPropertyChangeListener(actionChangedListener);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.isRollover = true;
        this.repaint();
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.isRollover = false;
        this.repaint();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.action != null) {
            this.action.actionPerformed(new ActionEvent(this, 0, ""));
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    private class ActionChangedListener
    implements PropertyChangeListener {
        ActionChangedListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("Name")) {
                String string2 = (String)propertyChangeEvent.getNewValue();
                LinkLabel.this.setText(string2);
                LinkLabel.this.repaint();
            } else if (string.equals("enabled")) {
                Boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                LinkLabel.this.setEnabled(bl);
                LinkLabel.this.repaint();
            } else if (string.equals("ToolTipText")) {
                String string3 = (String)propertyChangeEvent.getNewValue();
                LinkLabel.this.setToolTipText(string3);
                LinkLabel.this.repaint();
            }
        }
    }
}

