/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.common;

import java.awt.HeadlessException;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import javax.swing.JOptionPane;
import javax.swing.LookAndFeel;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import org.apache.commons.lang.SystemUtils;
import phex.common.Environment;
import phex.common.ServiceManager;
import phex.common.file.FileManager;
import phex.common.file.ManagedFile;
import phex.common.file.ManagedFileException;
import phex.gui.actions.ConnectNetworkAction;
import phex.gui.actions.DisconnectNetworkAction;
import phex.gui.actions.ExitPhexAction;
import phex.gui.actions.FWAction;
import phex.gui.actions.NewDownloadAction;
import phex.gui.actions.SwitchNetworkAction;
import phex.gui.chat.ChatFrameManager;
import phex.gui.common.DesktopIndicator;
import phex.gui.common.GUIRegistryConstants;
import phex.gui.common.GUIUpdateNotificationListener;
import phex.gui.common.GUIUserMessageListener;
import phex.gui.common.GUIUtils;
import phex.gui.common.IconFactory;
import phex.gui.common.LazyEventQueue;
import phex.gui.common.LookAndFeelFailedException;
import phex.gui.common.LookAndFeelUtils;
import phex.gui.common.MainFrame;
import phex.gui.common.TableUpdateService;
import phex.gui.macosx.MacOsxHandler;
import phex.update.UpdateManager;
import phex.utils.Localizer;
import phex.utils.NLogger;
import phex.utils.StringUtils;
import phex.utils.VersionUtils;
import phex.xml.sax.DPhex;
import phex.xml.sax.XMLBuilder;
import phex.xml.sax.gui.DGuiSettings;
import phex.xml.sax.gui.DTableList;

public class GUIRegistry
implements GUIRegistryConstants {
    private static GUIRegistry instance;
    private HashMap globalActionMap;
    private LazyEventQueue lazyEventQueue;
    private TableUpdateService tableUpdateService;
    private DesktopIndicator desktopIndicator;
    private IconFactory iconFactory;
    private ChatFrameManager chatFrameManager;
    private MainFrame mainFrame;
    private boolean showTableHorizontalLines;
    private boolean showTableVerticalLines;
    private boolean useLogBandwidthSlider;
    private boolean showRespectCopyrightNotice;
    static final /* synthetic */ boolean $assertionsDisabled;

    private GUIRegistry() {
    }

    public static GUIRegistry getInstance() {
        return instance;
    }

    public void initialize() {
        DGuiSettings dGuiSettings = this.loadGUISettings();
        this.initializeGUISettings(dGuiSettings);
        this.iconFactory = new IconFactory("phex.gui.resources.Icons");
        if (SystemUtils.IS_OS_WINDOWS) {
            try {
                this.desktopIndicator = new DesktopIndicator();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                this.desktopIndicator = null;
            }
        }
        if (SystemUtils.IS_OS_MAC_OSX) {
            new MacOsxHandler();
        }
        this.initializeGlobalActions();
        this.chatFrameManager = new ChatFrameManager();
        try {
            this.mainFrame = new MainFrame(null, dGuiSettings);
            NLogger.debug("USER_INTERFACE", (Object)"GUIRegistry initialized.");
        }
        catch (HeadlessException headlessException) {
            // empty catch block
        }
        GUIUpdateNotificationListener gUIUpdateNotificationListener = new GUIUpdateNotificationListener();
        UpdateManager.getInstance().triggerAutoBackgroundCheck(gUIUpdateNotificationListener);
        Environment.getInstance().setUserMessageListener(new GUIUserMessageListener());
    }

    public DesktopIndicator getDesktopIndicator() {
        return this.desktopIndicator;
    }

    public MainFrame getMainFrame() {
        return this.mainFrame;
    }

    public IconFactory getIconFactory() {
        return this.iconFactory;
    }

    public LazyEventQueue getLazyEventQueue() {
        if (this.lazyEventQueue == null) {
            this.lazyEventQueue = new LazyEventQueue();
        }
        return this.lazyEventQueue;
    }

    public TableUpdateService getTableUpdateService() {
        if (this.tableUpdateService == null) {
            this.tableUpdateService = new TableUpdateService();
        }
        return this.tableUpdateService;
    }

    public FWAction getGlobalAction(String string) {
        return (FWAction)this.globalActionMap.get(string);
    }

    public String getUsedLAFClass() {
        return UIManager.getLookAndFeel().getClass().getName();
    }

    public boolean getShowTableHorizontalLines() {
        return this.showTableHorizontalLines;
    }

    public void setShowTableHorizontalLines(boolean bl) {
        this.showTableHorizontalLines = bl;
    }

    public boolean getShowTableVerticalLines() {
        return this.showTableVerticalLines;
    }

    public void setShowTableVerticalLines(boolean bl) {
        this.showTableVerticalLines = bl;
    }

    public boolean useLogBandwidthSlider() {
        return this.useLogBandwidthSlider;
    }

    public void setLogBandwidthSliderUsed(boolean bl) {
        this.useLogBandwidthSlider = bl;
    }

    public boolean isRespectCopyrightNoticeShown() {
        return this.showRespectCopyrightNotice;
    }

    public void setRespectCopyrightNoticeShown(boolean bl) {
        this.showRespectCopyrightNotice = bl;
    }

    private synchronized DGuiSettings loadGUISettings() {
        NLogger.debug(GUIRegistry.class, (Object)"Loading gui settings file");
        File file = Environment.getInstance().getPhexConfigFile("phexgui.xml");
        try {
            if (!file.exists()) {
                NLogger.debug(GUIRegistry.class, (Object)"No gui settings configuration file found.");
                return null;
            }
            FileManager fileManager = FileManager.getInstance();
            ManagedFile managedFile = fileManager.getReadWriteManagedFile(file);
            DPhex dPhex = XMLBuilder.loadDPhexFromFile(managedFile);
            if (dPhex == null) {
                NLogger.debug(GUIRegistry.class, (Object)"No DPhex found.");
                return null;
            }
            this.updateGUISettings(dPhex);
            return dPhex.getGuiSettings();
        }
        catch (IOException iOException) {
            NLogger.error(GUIRegistry.class, (Object)iOException, (Throwable)iOException);
            Environment.getInstance().fireDisplayUserMessage("GuiSettingsLoadFailed", new String[]{iOException.toString()});
            return null;
        }
        catch (ManagedFileException managedFileException) {
            NLogger.error(GUIRegistry.class, (Object)managedFileException, (Throwable)managedFileException);
            Environment.getInstance().fireDisplayUserMessage("GuiSettingsLoadFailed", new String[]{managedFileException.toString()});
            return null;
        }
    }

    public synchronized void saveGUISettings() {
        NLogger.debug(GUIRegistry.class, (Object)"Saving gui settings.");
        try {
            DPhex dPhex = new DPhex();
            dPhex.setPhexVersion(VersionUtils.getFullProgramVersion());
            DGuiSettings dGuiSettings = new DGuiSettings();
            dGuiSettings.setLogBandwidthSliderUsed(this.useLogBandwidthSlider);
            dGuiSettings.setShowRespectCopyrightNotice(this.showRespectCopyrightNotice);
            dPhex.setGuiSettings(dGuiSettings);
            DTableList dTableList = new DTableList();
            dTableList.setShowHorizontalLines(this.showTableHorizontalLines);
            dTableList.setShowVerticalLines(this.showTableVerticalLines);
            dGuiSettings.setTableList(dTableList);
            dGuiSettings.setLookAndFeelClass(this.getUsedLAFClass());
            this.mainFrame.saveGUISettings(dGuiSettings);
            File file = Environment.getInstance().getPhexConfigFile("phexgui.xml");
            ManagedFile managedFile = FileManager.getInstance().getReadWriteManagedFile(file);
            XMLBuilder.saveToFile(managedFile, dPhex);
        }
        catch (IOException iOException) {
            NLogger.error(GUIRegistry.class, (Object)iOException, (Throwable)iOException);
            Environment.getInstance().fireDisplayUserMessage("GuiSettingsSaveFailed", new String[]{iOException.toString()});
        }
        catch (ManagedFileException managedFileException) {
            NLogger.error(GUIRegistry.class, (Object)managedFileException, (Throwable)managedFileException);
            Environment.getInstance().fireDisplayUserMessage("GuiSettingsSaveFailed", new String[]{managedFileException.toString()});
        }
    }

    private void initializeGlobalActions() {
        this.globalActionMap = new HashMap(2);
        FWAction fWAction = new ExitPhexAction();
        this.globalActionMap.put("ExitPhexAction", fWAction);
        fWAction = new NewDownloadAction();
        this.globalActionMap.put("NewDownloadAction", fWAction);
        fWAction = new ConnectNetworkAction();
        this.globalActionMap.put("ConnectNetworkAction", fWAction);
        fWAction = new DisconnectNetworkAction();
        this.globalActionMap.put("DisconnectNetworkAction", fWAction);
        fWAction = new SwitchNetworkAction();
        this.globalActionMap.put("SwitchNetworkAction", fWAction);
    }

    private void initializeGUISettings(DGuiSettings dGuiSettings) {
        block14: {
            String string;
            Object object;
            if (SystemUtils.IS_OS_MAC_OSX || SystemUtils.IS_OS_WINDOWS) {
                this.showTableHorizontalLines = false;
                this.showTableVerticalLines = false;
            } else {
                this.showTableHorizontalLines = true;
                this.showTableVerticalLines = true;
            }
            this.useLogBandwidthSlider = false;
            this.showRespectCopyrightNotice = true;
            ToolTipManager.sharedInstance().setEnabled(ServiceManager.sCfg.mUIDisplayTooltip);
            if (dGuiSettings != null) {
                if (dGuiSettings.isSetLogBandwidthSliderUsed()) {
                    this.useLogBandwidthSlider = dGuiSettings.isLogBandwidthSliderUsed();
                }
                if (dGuiSettings.isSetShowRespectCopyrightNotice()) {
                    this.showRespectCopyrightNotice = dGuiSettings.isShowRespectCopyrightNotice();
                }
                if ((object = dGuiSettings.getTableList()) != null && ((DTableList)object).isSetShowHorizontalLines()) {
                    this.showTableHorizontalLines = ((DTableList)object).isShowHorizontalLines();
                }
                if (object != null && ((DTableList)object).isSetShowVerticalLines()) {
                    this.showTableVerticalLines = ((DTableList)object).isShowVerticalLines();
                }
                string = dGuiSettings.getLookAndFeelClass();
            } else {
                string = null;
            }
            object = LookAndFeelUtils.determineLAF(string);
            String string2 = object.getClass().getName();
            if (string != null && !string2.equals(string)) {
                JOptionPane.showMessageDialog(GUIRegistry.getInstance().getMainFrame(), Localizer.getString("LAF_ErrorLoadingSwitchToDefault"), Localizer.getString("Error"), 0);
            }
            if (string2.equals(UIManager.getLookAndFeel().getClass().getName())) {
                GUIUtils.updateComponentsUI();
            } else {
                try {
                    LookAndFeelUtils.setLookAndFeel((LookAndFeel)object);
                }
                catch (ExceptionInInitializerError exceptionInInitializerError) {
                }
                catch (LookAndFeelFailedException lookAndFeelFailedException) {
                    if ($assertionsDisabled) break block14;
                    throw new AssertionError();
                }
            }
        }
    }

    private void updateGUISettings(DPhex dPhex) {
        if (dPhex == null) {
            return;
        }
        String string = dPhex.getPhexVersion();
        if (VersionUtils.compare(VersionUtils.getFullProgramVersion(), string) != 0) {
            this.reactivateRespectCopyright(dPhex);
        }
        if (VersionUtils.compare("2.1.6.82", string) > 0) {
            this.updatesForBuild82(dPhex);
        }
    }

    private void updatesForBuild82(DPhex dPhex) {
        DGuiSettings dGuiSettings = dPhex.getGuiSettings();
        if (dGuiSettings == null) {
            return;
        }
        String string = dGuiSettings.getLookAndFeelClass();
        if (string == null) {
            return;
        }
        if (string.startsWith("com.jgoodies.plaf")) {
            string = StringUtils.replace(string, "com.jgoodies.plaf.", "com.jgoodies.looks.", 1);
            dGuiSettings.setLookAndFeelClass(string);
        }
    }

    private void reactivateRespectCopyright(DPhex dPhex) {
        DGuiSettings dGuiSettings = dPhex.getGuiSettings();
        if (dGuiSettings == null) {
            return;
        }
        dGuiSettings.setShowRespectCopyrightNotice(true);
    }

    static {
        $assertionsDisabled = !GUIRegistry.class.desiredAssertionStatus();
        instance = new GUIRegistry();
    }
}

