/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.common;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import phex.gui.actions.FWAction;
import phex.gui.actions.FWToggleAction;
import phex.gui.common.GUIUtils;

public class FWToolBar
extends JToolBar {
    private boolean isTextShown;

    public FWToolBar(int n) {
        super(n);
        this.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        this.isTextShown = true;
    }

    public void setShowText(boolean bl) {
        this.isTextShown = bl;
    }

    public AbstractButton addAction(FWAction fWAction) {
        return this.addAction(fWAction, fWAction.isToggleAction());
    }

    public AbstractButton addAction(Action action, boolean bl) {
        AbstractButton abstractButton;
        if (bl) {
            abstractButton = new JToggleButton();
            abstractButton.setSelected(((FWToggleAction)action).isSelected());
        } else {
            abstractButton = new JButton();
        }
        Icon icon = (Icon)action.getValue("MediumIcon");
        if (icon == null) {
            icon = (Icon)action.getValue("SmallIcon");
        }
        abstractButton.setIcon(icon);
        abstractButton.setHorizontalTextPosition(4);
        abstractButton.setVerticalTextPosition(3);
        abstractButton.setEnabled(action.isEnabled());
        abstractButton.addActionListener(action);
        this.registerActionChangeListener(abstractButton, action);
        abstractButton.setToolTipText((String)action.getValue("ToolTipText"));
        if (this.isTextShown) {
            abstractButton.setText((String)action.getValue("Name"));
        }
        abstractButton.setRequestFocusEnabled(false);
        abstractButton.setMargin(GUIUtils.EMPTY_INSETS);
        this.add(abstractButton);
        return abstractButton;
    }

    private void registerActionChangeListener(AbstractButton abstractButton, Action action) {
        ActionChangedListener actionChangedListener = new ActionChangedListener(abstractButton);
        action.addPropertyChangeListener(actionChangedListener);
    }

    private class ActionChangedListener
    implements PropertyChangeListener {
        AbstractButton button;

        ActionChangedListener(AbstractButton abstractButton) {
            this.button = abstractButton;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("Name")) {
                String string2 = (String)propertyChangeEvent.getNewValue();
                this.button.setText(string2);
                this.button.repaint();
            } else if (string.equals("enabled")) {
                Boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                this.button.setEnabled(bl);
                this.button.repaint();
            } else if (string.equals("MediumIcon")) {
                Icon icon = (Icon)propertyChangeEvent.getNewValue();
                this.button.setIcon(icon);
                this.button.invalidate();
                this.button.repaint();
            } else if (string.equals("IsSelected")) {
                Boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                this.button.setSelected(bl);
                this.button.repaint();
            } else if (string.equals("ToolTipText")) {
                String string3 = (String)propertyChangeEvent.getNewValue();
                this.button.setToolTipText(string3);
                this.button.repaint();
            }
        }
    }
}

