/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.common;

import java.awt.Graphics;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public class FWImagePanel
extends JPanel {
    public static final int ALIGN_LEFT = 0;
    public static final int ALIGN_CENTER = 1;
    public static final int ALIGN_RIGHT = 2;
    private int alignment = 1;
    private ImageIcon image = null;
    private boolean fillEntireArea = false;
    private boolean tileImage = false;

    public int getAlignment() {
        return this.alignment;
    }

    public void setAlignment(int n) {
        this.alignment = n;
    }

    public void setFillEntireArea(boolean bl) {
        this.fillEntireArea = bl;
        this.repaint();
    }

    public boolean getFillEntireArea() {
        return this.fillEntireArea;
    }

    public void setTileImage(boolean bl) {
        this.tileImage = bl;
        this.repaint();
    }

    public boolean getTileImage() {
        return this.tileImage;
    }

    public void setImage(ImageIcon imageIcon) {
        this.image = imageIcon;
        this.repaint();
    }

    public ImageIcon getImage() {
        return this.image;
    }

    public void paintComponent(Graphics graphics) {
        if (this.isOpaque()) {
            super.paintComponent(graphics);
            if (this.image != null) {
                int n = this.getWidth();
                int n2 = this.getHeight();
                graphics.setColor(this.getBackground());
                graphics.fillRect(0, 0, n, n2);
                if (this.fillEntireArea) {
                    graphics.drawImage(this.image.getImage(), 0, 0, n, n2, this);
                } else if (!this.tileImage) {
                    int n3;
                    int n4;
                    switch (this.alignment) {
                        case 0: {
                            n4 = 0;
                            n3 = 0;
                            break;
                        }
                        case 2: {
                            n4 = n - this.image.getIconWidth();
                            n3 = n2 - this.image.getIconHeight();
                            break;
                        }
                        default: {
                            n4 = (n - this.image.getIconWidth()) / 2;
                            n3 = (n2 - this.image.getIconHeight()) / 2;
                        }
                    }
                    graphics.drawImage(this.image.getImage(), n4, n3, this);
                } else {
                    int n5 = this.image.getIconWidth();
                    int n6 = this.image.getIconHeight();
                    int n7 = 0;
                    while (n2 - n7 > 0) {
                        int n8 = 0;
                        while (n - n8 > 0) {
                            this.image.paintIcon(null, graphics, n8, n7);
                            n8 += n5;
                        }
                        n7 += n6;
                    }
                }
            }
        }
    }
}

