/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.common;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import phex.gui.common.PhexColors;
import phex.utils.NLogger;

public class BoxPanel
extends JPanel {
    private BoxHeader boxHeader;
    private JPanel contentPanel;
    private boolean isContentShown = true;

    public BoxPanel(String string) {
        super(new BorderLayout());
        this.boxHeader = new BoxHeader(string, this);
        this.add((Component)this.boxHeader, "North");
        this.contentPanel = new JPanel();
        this.add((Component)this.contentPanel, "Center");
        this.initialize();
    }

    private void initialize() {
        UIDefaults uIDefaults = UIManager.getDefaults();
        if (uIDefaults == null) {
            NLogger.error("USER_INTERFACE", "UIManager defaults are null!");
            return;
        }
        Color color = (Color)uIDefaults.get("window");
        if (color == null) {
            NLogger.error("USER_INTERFACE", "Failed to get default color: window. Using White.");
            color = Color.WHITE;
        }
        Color color2 = new Color(color.getRGB());
        Color color3 = PhexColors.getBoxPanelBorderColor();
        if (color3 == null) {
            NLogger.error("USER_INTERFACE", "Failed to get Phex color: BoxPanelBorderColor.");
            color3 = Color.BLACK;
        }
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(6, 6, 6, 6, color2), BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, color3), BorderFactory.createMatteBorder(1, 1, 1, 1, color2))));
        Color color4 = PhexColors.getBoxPanelBackground();
        if (color4 == null) {
            NLogger.error("USER_INTERFACE", "Failed to get Phex color: BoxPanelBackground.");
            color4 = Color.GRAY;
        }
        int n = color4.getRGB();
        color2 = new Color(n);
        this.setBackground(color2);
        if (this.contentPanel != null) {
            this.contentPanel.setBackground(color2);
            this.contentPanel.repaint();
        }
    }

    public void setHeaderText(String string) {
        this.boxHeader.setHeaderText(string);
    }

    public void setShowContent(boolean bl) {
        if (this.isContentShown != bl) {
            this.isContentShown = bl;
            this.contentPanel.setVisible(this.isContentShown);
            this.repaint();
        }
    }

    public void setContentLayout(LayoutManager layoutManager) {
        this.contentPanel.setLayout(layoutManager);
    }

    public void addContent(Component component, GridBagConstraints gridBagConstraints) {
        this.contentPanel.add(component, gridBagConstraints);
    }

    public JPanel getContentPanel() {
        return this.contentPanel;
    }

    public void updateUI() {
        super.updateUI();
        if (this.contentPanel != null) {
            this.initialize();
        }
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        Dimension dimension = this.getMaximumSize();
        Dimension dimension2 = super.getPreferredSize();
        dimension2.height = Math.min(dimension2.height, dimension.height);
        dimension2.width = Math.min(dimension2.width, dimension.width);
        return dimension2;
    }

    static class BoxHeader
    extends JComponent
    implements MouseListener {
        private String headerText;
        private boolean isRollover;
        private BoxPanel boxPanel;
        private static Rectangle viewRect = new Rectangle();
        private static Rectangle textRect = new Rectangle();
        private static Rectangle iconRect = new Rectangle();

        public BoxHeader(String string, BoxPanel boxPanel) {
            this.headerText = string;
            this.boxPanel = boxPanel;
            this.isRollover = false;
            this.addMouseListener(this);
            this.setCursor(Cursor.getPredefinedCursor(12));
            this.initialize();
        }

        public void initialize() {
            this.setBackground(PhexColors.getBoxHeaderBackground());
            this.setFont(UIManager.getFont("Label.font").deriveFont(1));
        }

        public void updateUI() {
            super.updateUI();
            this.initialize();
        }

        public void setHeaderText(String string) {
            this.headerText = string;
            this.invalidate();
            this.repaint();
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public Dimension getPreferredSize() {
            Font font = this.getFont();
            FontMetrics fontMetrics = this.getFontMetrics(font);
            BoxHeader.viewRect.width = Short.MAX_VALUE;
            BoxHeader.viewRect.height = Short.MAX_VALUE;
            SwingUtilities.layoutCompoundLabel(this, fontMetrics, this.headerText, null, 0, 0, 0, 0, viewRect, iconRect, textRect, 0);
            Insets insets = this.getInsets();
            BoxHeader.textRect.width += insets.left + insets.right + 10;
            BoxHeader.textRect.height += insets.top + insets.bottom + 8;
            return textRect.getSize();
        }

        protected void paintComponent(Graphics graphics) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            Insets insets = this.getInsets();
            BoxHeader.viewRect.x = insets.left;
            BoxHeader.viewRect.y = insets.top;
            BoxHeader.viewRect.width = this.getWidth() - (insets.right + BoxHeader.viewRect.x);
            BoxHeader.viewRect.height = this.getHeight() - (insets.bottom + BoxHeader.viewRect.y);
            Graphics2D graphics2D = (Graphics2D)graphics;
            GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, PhexColors.getBoxHeaderGradientFrom(), 0.0f, this.getHeight(), PhexColors.getBoxHeaderGradientTo());
            graphics2D.setPaint(gradientPaint);
            graphics2D.fillRect(BoxHeader.viewRect.x, BoxHeader.viewRect.y, BoxHeader.viewRect.width, BoxHeader.viewRect.height - 2);
            UIDefaults uIDefaults = UIManager.getDefaults();
            Color color = (Color)uIDefaults.get("window");
            graphics2D.setColor(color);
            graphics2D.fillRect(insets.left, this.getHeight() - (insets.bottom + insets.top + 2), this.getWidth() - (insets.right + insets.left), 1);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            BoxHeader.textRect.height = 0;
            BoxHeader.textRect.width = 0;
            BoxHeader.textRect.y = 0;
            BoxHeader.textRect.x = 0;
            BoxHeader.iconRect.height = 0;
            BoxHeader.iconRect.width = 0;
            BoxHeader.iconRect.y = 0;
            BoxHeader.iconRect.x = 0;
            String string = SwingUtilities.layoutCompoundLabel(this, fontMetrics, this.headerText, null, 0, 0, 0, 0, viewRect, iconRect, textRect, 0);
            this.paintText(graphics, textRect, string);
        }

        protected void paintText(Graphics graphics, Rectangle rectangle, String string) {
            FontMetrics fontMetrics = graphics.getFontMetrics();
            if (this.isRollover) {
                graphics.setColor(PhexColors.getLinkLabelRolloverForeground());
            } else {
                graphics.setColor(this.getForeground());
            }
            graphics.drawString(string, rectangle.x, rectangle.y + fontMetrics.getAscent());
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            this.isRollover = true;
            this.repaint();
        }

        public void mouseExited(MouseEvent mouseEvent) {
            this.isRollover = false;
            this.repaint();
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            this.boxPanel.setShowContent(!this.boxPanel.isContentShown);
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }
    }
}

